/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.util.NlsSafe;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleSourceRootEditHandler<P extends JpsElement> {
    public static final ExtensionPointName<ModuleSourceRootEditHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectStructure.sourceRootEditHandler");
    private final JpsModuleSourceRootType<P> myRootType;

    protected ModuleSourceRootEditHandler(JpsModuleSourceRootType<P> rootType) {
        this.myRootType = rootType;
    }

    @Nullable
    public static <P extends JpsElement> ModuleSourceRootEditHandler<P> getEditHandler(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(0);
        }
        return EP_NAME.getExtensionList().stream().filter(editor -> editor.getRootType().equals(type)).findFirst().orElse(null);
    }

    public final JpsModuleSourceRootType<P> getRootType() {
        return this.myRootType;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getRootTypeName();

    @NotNull
    @Nls
    public String getFullRootTypeName() {
        String string = ProjectBundle.message((String)"module.paths.root.node", (Object[])new Object[]{this.getRootTypeName()});
        if (string == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public abstract Icon getRootIcon();

    @NotNull
    public Icon getRootIcon(@NotNull P properties) {
        if (properties == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(2);
        }
        Icon icon2 = this.getRootIcon();
        if (icon2 == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    @Nullable
    public Icon getRootFileLayerIcon() {
        return null;
    }

    @Nullable
    public Icon getRootFileLayerIcon(@NotNull P properties) {
        if (properties == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(4);
        }
        return this.getRootFileLayerIcon();
    }

    @Nullable
    public abstract Icon getFolderUnderRootIcon();

    @Nullable
    public abstract CustomShortcutSet getMarkRootShortcutSet();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getRootsGroupTitle();

    @NotNull
    public abstract Color getRootsGroupColor();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getMarkRootButtonText() {
        String string = this.getRootTypeName();
        if (string == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getUnmarkRootButtonText();

    @Nullable
    @NlsSafe
    public String getPropertiesString(@NotNull P properties) {
        if (properties == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback2) {
        if (folder == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(7);
        }
        if (parentComponent == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(8);
        }
        if (callback2 == null) {
            ModuleSourceRootEditHandler.$$$reportNull$$$0(9);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullRootTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkRootButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditHandler";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootFileLayerIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

