/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.ScreenUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u00a8\u0006\t"}, d2={"updateFrameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "frame", "Ljavax/swing/JFrame;", "lastNormalFrameBounds", "Ljava/awt/Rectangle;", "oldFrameInfo", "intellij.platform.ide.impl"})
public final class FrameInfoHelperKt {
    @NotNull
    public static final FrameInfo updateFrameInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame, @Nullable Rectangle lastNormalFrameBounds, @Nullable FrameInfo oldFrameInfo) {
        FrameInfo frameInfo;
        FrameInfo frameInfo2;
        boolean usePreviousBounds;
        Object peer;
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int extendedState = frame.getExtendedState();
        if (SystemInfoRt.isMac && (peer = AWTAccessor.getComponentAccessor().getPeer(frame)) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isInFullScreen = FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs() && frameHelper.isInFullScreen();
        boolean isMaximized = FrameInfoHelper.Companion.isMaximized(extendedState) || isInFullScreen;
        FrameInfo frameInfo3 = oldFrameInfo;
        Rectangle oldBounds = frameInfo3 != null ? frameInfo3.getBounds() : null;
        Rectangle newBounds = FrameBoundsConverter.convertToDeviceSpace(frame.getGraphicsConfiguration(), isMaximized && lastNormalFrameBounds != null ? lastNormalFrameBounds : frame.getBounds());
        boolean bl = usePreviousBounds = lastNormalFrameBounds == null && isMaximized && oldBounds != null && newBounds.contains(new Point((int)oldBounds.getCenterX(), (int)oldBounds.getCenterY()));
        if (!usePreviousBounds && Intrinsics.areEqual((Object)oldBounds, (Object)newBounds) ^ true && !ScreenUtil.intersectsVisibleScreen((Window)frame)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WindowInfoImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Frame bounds are invalid: " + newBounds);
        }
        if ((frameInfo2 = oldFrameInfo) == null) {
            frameInfo2 = frameInfo = new FrameInfo();
        }
        if (!usePreviousBounds) {
            frameInfo.setBounds(newBounds);
        }
        frameInfo.setExtendedState(extendedState);
        if (FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            frameInfo.setFullScreen(isInFullScreen);
        }
        return frameInfo;
    }
}

