/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class IntMapForwardIndex
implements IntForwardIndex {
    private final File myStorageFile;
    private final boolean myHasChunks;
    private volatile PersistentHashMap<Integer, Integer> myPersistentMap;

    public IntMapForwardIndex(@NotNull File storageFile, boolean hasChunks) throws IOException {
        if (storageFile == null) {
            IntMapForwardIndex.$$$reportNull$$$0(0);
        }
        this.myStorageFile = storageFile;
        this.myHasChunks = hasChunks;
        this.createMap();
    }

    private void createMap() throws IOException {
        Boolean old = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        try {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!this.myHasChunks);
            this.myPersistentMap = new PersistentHashMap<Integer, Integer>(this.myStorageFile.toPath(), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE){

                protected boolean wantNonNegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException e) {
            IOUtil.deleteAllFilesStartingWith((File)this.myStorageFile);
            throw e;
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(old);
        }
    }

    public int getInt(@NotNull Integer key) throws IOException {
        if (key == null) {
            IntMapForwardIndex.$$$reportNull$$$0(1);
        }
        assert (this.myPersistentMap != null);
        return (Integer)this.myPersistentMap.get((Object)key);
    }

    public void putInt(@NotNull Integer key, int value2) throws IOException {
        if (key == null) {
            IntMapForwardIndex.$$$reportNull$$$0(2);
        }
        assert (this.myPersistentMap != null);
        this.myPersistentMap.put((Object)key, (Object)value2);
    }

    public void force() {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.force();
        }
    }

    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myPersistentMap);
        this.createMap();
    }

    public void close() throws IOException {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/forward/IntMapForwardIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "putInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

