/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerInlayUtil {
    public static final Key<Helper> HELPER_KEY = Key.create((String)"xdebug.inlay.helper");
    public static final String INLINE_HINTS_DELIMETER = ":";

    private static int getIdentifierEndOffset(@NotNull CharSequence text2, int startOffset) {
        if (text2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        while (startOffset < text2.length() && Character.isJavaIdentifierPart(text2.charAt(startOffset))) {
            ++startOffset;
        }
        return startOffset;
    }

    public static boolean createLineEndInlay(XValueNodeImpl valueNode, @NotNull XDebugSession session2, @NotNull VirtualFile file2, @NotNull XSourcePosition position, Document document) {
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        if (position == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(3);
        }
        if (valueNode.getValuePresentation() != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                int offset = document.getLineEndOffset(position.getLine());
                Project project = session2.getProject();
                FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
                if (editor instanceof TextEditor) {
                    Editor e = ((TextEditor)editor).getEditor();
                    boolean customNode = valueNode instanceof InlineWatchNodeImpl;
                    InlineDebugRenderer renderer2 = new InlineDebugRenderer(valueNode, position, session2, e);
                    Inlay<InlineDebugRenderer> inlay = ((InlayModelImpl)e.getInlayModel()).addAfterLineEndDebuggerHint(offset, customNode, renderer2);
                    if (customNode) {
                        ((InlineWatchNodeImpl)valueNode).inlayCreated(inlay);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void createInlay(@NotNull Project project, @NotNull VirtualFile file2, int offset, String inlayText) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(5);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
            if (editor instanceof TextEditor) {
                Editor e = ((TextEditor)editor).getEditor();
                CharSequence text2 = e.getDocument().getImmutableCharSequence();
                int insertOffset = XDebuggerInlayUtil.getIdentifierEndOffset(text2, offset);
                e.getInlayModel().getInlineElementsInRange(insertOffset, insertOffset, MyRenderer.class).forEach(Disposer::dispose);
                e.getInlayModel().addInlineElement(insertOffset, (EditorCustomElementRenderer)new MyRenderer(inlayText));
            }
        });
    }

    public static void clearInlays(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(6);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor[] editors2;
            for (FileEditor editor : editors2 = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                e.getInlayModel().getInlineElementsInRange(0, e.getDocument().getTextLength(), MyRenderer.class).forEach(Disposer::dispose);
                e.getInlayModel().getAfterLineEndElementsInRange(0, e.getDocument().getTextLength(), InlineDebugRenderer.class).forEach(Disposer::dispose);
            }
        });
    }

    public static void setupValuePlaceholders(@NotNull XDebugSessionImpl session2, boolean removePlaceholders) {
        XSourcePosition position;
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(7);
        }
        XSourcePosition xSourcePosition = position = removePlaceholders ? null : session2.getCurrentPosition();
        if (!removePlaceholders && position == null) {
            return;
        }
        Helper helper = (Helper)session2.getSessionData().getUserData(HELPER_KEY);
        if (helper == null) {
            return;
        }
        Project project = session2.getProject();
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> helper.setupValuePlaceholders(project, position));
    }

    public static boolean showValueInBlockInlay(@NotNull XDebugSessionImpl session2, @NotNull XValueNodeImpl node, @NotNull XSourcePosition position) {
        Helper helper;
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(8);
        }
        if (node == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(9);
        }
        if (position == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(10);
        }
        return (helper = (Helper)session2.getSessionData().getUserData(HELPER_KEY)) != null && helper.showValueInBlockInlay(session2.getProject(), node, position);
    }

    public static void createBlockInlay(@NotNull Editor editor, int offset) {
        if (editor == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(11);
        }
        editor.getInlayModel().addBlockElement(offset, false, false, 0, (EditorCustomElementRenderer)new MyBlockRenderer());
    }

    public static void addValueToBlockInlay(@NotNull Editor editor, int offset, String inlayText) {
        if (editor == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(12);
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
        List inlays = editor.getInlayModel().getBlockElementsInRange(lineStartOffset, lineStartOffset, MyBlockRenderer.class);
        if (inlays.size() != 1) {
            return;
        }
        Inlay inlay = (Inlay)inlays.get(0);
        CharSequence text2 = editor.getDocument().getImmutableCharSequence();
        int identifierEndOffset = XDebuggerInlayUtil.getIdentifierEndOffset(text2, offset);
        ((MyBlockRenderer)inlay.getRenderer()).addValue(offset, identifierEndOffset, inlayText);
        inlay.update();
    }

    public static void clearBlockInlays(@NotNull Editor editor) {
        if (editor == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(13);
        }
        editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength(), MyBlockRenderer.class).forEach(Disposer::dispose);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdentifierEndOffset";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineEndInlay";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlay";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlays";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setupValuePlaceholders";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showValueInBlockInlay";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlockInlay";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addValueToBlockInlay";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "clearBlockInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRenderer
    implements EditorCustomElementRenderer {
        private final String myText;

        private MyRenderer(String text2) {
            this.myText = "(" + text2 + ")";
        }

        private static FontInfo getFontInfo(@NotNull Editor editor) {
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            FontPreferences fontPreferences = colorsScheme.getFontPreferences();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            int fontStyle = attributes == null ? 0 : attributes.getFontType();
            return ComplementaryFontsRegistry.getFontAbleToDisplay(97, fontStyle, fontPreferences, FontInfo.getFontRenderContext(editor.getContentComponent()));
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            FontInfo fontInfo = MyRenderer.getFontInfo(inlay.getEditor());
            return fontInfo.fontMetrics().stringWidth(this.myText);
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Editor editor;
            TextAttributes attributes;
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            if (r == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            if (textAttributes == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            if ((attributes = (editor = inlay.getEditor()).getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE)) == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            g.setFont(fontInfo.getFont());
            FontMetrics metrics = fontInfo.fontMetrics();
            g.drawString(this.myText, r.x, r.y + metrics.getAscent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFontInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyBlockRenderer
    implements EditorCustomElementRenderer {
        private final SortedSet<ValueInfo> values = new TreeSet<ValueInfo>();

        private MyBlockRenderer() {
        }

        void addValue(int refStartOffset, int refEndOffset, @NotNull String value2) {
            if (value2 == null) {
                MyBlockRenderer.$$$reportNull$$$0(0);
            }
            ValueInfo info = new ValueInfo(refStartOffset, refEndOffset, value2);
            this.values.remove(info);
            this.values.add(info);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyBlockRenderer.$$$reportNull$$$0(1);
            }
            return 0;
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            if (inlay == null) {
                MyBlockRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                MyBlockRenderer.$$$reportNull$$$0(3);
            }
            if (targetRegion == null) {
                MyBlockRenderer.$$$reportNull$$$0(4);
            }
            if (textAttributes == null) {
                MyBlockRenderer.$$$reportNull$$$0(5);
            }
            if (this.values.isEmpty()) {
                return;
            }
            Editor editor = inlay.getEditor();
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            TextAttributes attributes = colorsScheme.getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            if (attributes == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            g.setFont(new Font(colorsScheme.getEditorFontName(), attributes.getFontType(), colorsScheme.getEditorFontSize()));
            int curX = 0;
            for (ValueInfo value2 : this.values) {
                curX += JBUIScale.scale((int)5);
                int xStart = editor.offsetToXY((int)value2.refStartOffset, (boolean)true, (boolean)false).x;
                int xEnd = editor.offsetToXY((int)value2.refEndOffset, (boolean)false, (boolean)true).x;
                int width = g.getFontMetrics().stringWidth(value2.value);
                curX = Math.max(curX, (xStart + xEnd - width) / 2);
                g.drawString(value2.value, curX, targetRegion.y + editor.getAscent());
                g.drawLine(MathUtil.clamp((int)(curX + width / 2), (int)xStart, (int)xEnd), targetRegion.y, curX + width / 2, targetRegion.y + 2);
                g.drawLine(curX, targetRegion.y + 2, curX + width, targetRegion.y + 2);
                curX += width;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$MyBlockRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class ValueInfo
        implements Comparable<ValueInfo> {
            private final int refStartOffset;
            private final int refEndOffset;
            private final String value;

            private ValueInfo(int refStartOffset, int refEndOffset, String value2) {
                this.refStartOffset = refStartOffset;
                this.refEndOffset = refEndOffset;
                this.value = value2;
            }

            @Override
            public int compareTo(@NotNull ValueInfo o) {
                if (o == null) {
                    ValueInfo.$$$reportNull$$$0(0);
                }
                return this.refStartOffset - o.refStartOffset;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$MyBlockRenderer$ValueInfo", "compareTo"));
            }
        }
    }

    public static interface Helper {
        public void setupValuePlaceholders(@NotNull Project var1, @Nullable XSourcePosition var2);

        public boolean showValueInBlockInlay(@NotNull Project var1, @NotNull XValueNodeImpl var2, @NotNull XSourcePosition var3);
    }
}

