/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001H\u0007\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\u000f"}, d2={"compareAuthority", "", "currentAuthority", "", "getBuiltInServerUrls", "", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "appendAccessToken", "Lcom/intellij/util/SmartList;", "info", "Lorg/jetbrains/builtInWebServer/PathInfo;", "intellij.platform.builtInServer.impl"})
public final class BuiltInWebBrowserUrlProviderKt {
    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project, @Nullable String currentAuthority, boolean appendAccessToken) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (currentAuthority != null && !BuiltInWebBrowserUrlProviderKt.compareAuthority(currentAuthority)) {
            return CollectionsKt.emptyList();
        }
        PathInfo pathInfo = WebServerPathToFileManager.Companion.getInstance(project).getPathInfo(file2);
        if (pathInfo == null) {
            return CollectionsKt.emptyList();
        }
        PathInfo info = pathInfo;
        return (List)BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(info, project, currentAuthority, appendAccessToken);
    }

    public static /* synthetic */ List getBuiltInServerUrls$default(VirtualFile virtualFile, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(virtualFile, project, string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project, @Nullable String currentAuthority) {
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default(file2, project, currentAuthority, false, 8, null);
    }

    @NotNull
    public static final SmartList<Url> getBuiltInServerUrls(@NotNull PathInfo info, @NotNull Project project, @Nullable String currentAuthority, boolean appendAccessToken) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BuiltInServerOptions builtInServerOptions = BuiltInServerOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)builtInServerOptions, (String)"BuiltInServerOptions.getInstance()");
        int effectiveBuiltInServerPort = builtInServerOptions.getEffectiveBuiltInServerPort();
        String path = info.getPath();
        String string = currentAuthority;
        if (string == null) {
            string = "localhost:" + effectiveBuiltInServerPort;
        }
        String authority = string;
        String query2 = appendAccessToken ? "?_ijt=" + BuiltInWebServerKt.acquireToken() : "";
        SmartList urls = new SmartList((Object)Urls.newHttpUrl((String)authority, (String)('/' + project.getName() + '/' + path), (String)query2));
        String path2 = info.getRootLessPathIfPossible();
        if (path2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '/';
            String string2 = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.name");
            String string3 = string2;
            boolean bl = false;
            urls.add((Object)Urls.newHttpUrl((String)authority, (String)stringBuilder.append(String.valueOf(c) + string3).append('/').append(path2).toString(), (String)query2));
        }
        int defaultPort = BuiltInServerManager.Companion.getInstance().getPort();
        if (currentAuthority == null && defaultPort != effectiveBuiltInServerPort) {
            String defaultAuthority = "localhost:" + defaultPort;
            urls.add((Object)Urls.newHttpUrl((String)defaultAuthority, (String)('/' + project.getName() + '/' + path), (String)query2));
            if (path2 != null) {
                urls.add((Object)Urls.newHttpUrl((String)defaultAuthority, (String)('/' + project.getName() + '/' + path2), (String)query2));
            }
        }
        return urls;
    }

    public static /* synthetic */ SmartList getBuiltInServerUrls$default(PathInfo pathInfo, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(pathInfo, project, string, bl);
    }

    public static final boolean compareAuthority(@Nullable String currentAuthority) {
        CharSequence charSequence = currentAuthority;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        String string = currentAuthority;
        Intrinsics.checkNotNull((Object)string);
        int portIndex = StringsKt.indexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null);
        if (portIndex < 0) {
            return false;
        }
        String string2 = currentAuthority;
        int n = 0;
        int n2 = 0;
        String string3 = string2.substring(n, portIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String host = string3;
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        String string4 = currentAuthority;
        n2 = portIndex + 1;
        boolean bl3 = false;
        String string5 = string4.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        int port = StringUtil.parseInt((String)string5, (int)-1);
        BuiltInServerOptions builtInServerOptions = BuiltInServerOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)builtInServerOptions, (String)"BuiltInServerOptions.getInstance()");
        return port == builtInServerOptions.getEffectiveBuiltInServerPort() || port == BuiltInServerManager.Companion.getInstance().getPort();
    }
}

