/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.StringKt;
import com.intellij.util.xmlb.annotations.OptionTag;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="PasswordSafe", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/credentialStore/PasswordSafeSettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/credentialStore/PasswordSafeSettings$PasswordSafeOptions;", "()V", "value", "", "keepassDb", "getKeepassDb", "()Ljava/lang/String;", "setKeepassDb", "(Ljava/lang/String;)V", "Lcom/intellij/credentialStore/ProviderType;", "providerType", "getProviderType", "()Lcom/intellij/credentialStore/ProviderType;", "setProviderType", "(Lcom/intellij/credentialStore/ProviderType;)V", "state", "getState", "getStateModificationCount", "", "loadState", "", "Companion", "PasswordSafeOptions", "intellij.platform.credentialStore"})
public final class PasswordSafeSettings
implements PersistentStateComponentWithModificationTracker<PasswordSafeOptions> {
    private PasswordSafeOptions state = new PasswordSafeOptions();
    @JvmField
    @NotNull
    public static final Topic<PasswordSafeSettingsListener> TOPIC;
    public static final Companion Companion;

    @Nullable
    public final String getKeepassDb() {
        String result = this.state.getKeepassDb();
        return result == null && this.getProviderType() == ProviderType.KEEPASS ? ((Object)PasswordSafeImplKt.getDefaultKeePassDbFile()).toString() : result;
    }

    public final void setKeepassDb(@Nullable String value) {
        String v = StringKt.nullize((String)value, (boolean)true);
        if (v != null && Intrinsics.areEqual((Object)v, (Object)((Object)PasswordSafeImplKt.getDefaultKeePassDbFile()).toString())) {
            v = null;
        }
        this.state.setKeepassDb(v);
    }

    @NotNull
    public final ProviderType getProviderType() {
        return SystemInfo.isWindows && this.state.getProvider() == ProviderType.KEYCHAIN ? ProviderType.KEEPASS : this.state.getProvider();
    }

    public final void setProviderType(@NotNull ProviderType value) {
        block2: {
            ProviderType oldValue;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            ProviderType newValue = value;
            if (newValue == ProviderType.DO_NOT_STORE) {
                newValue = ProviderType.MEMORY_ONLY;
            }
            if (newValue == (oldValue = this.state.getProvider())) break block2;
            this.state.setProvider(newValue);
            Object object = ApplicationManager.getApplication();
            if (object != null && (object = object.getMessageBus()) != null && (object = (PasswordSafeSettingsListener)object.syncPublisher(TOPIC)) != null) {
                object.typeChanged(oldValue, newValue);
            }
        }
    }

    @NotNull
    public PasswordSafeOptions getState() {
        return this.state;
    }

    public void loadState(@NotNull PasswordSafeOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.state = state;
        this.setProviderType(state.getProvider());
        state.setKeepassDb(StringKt.nullize((String)state.getKeepassDb(), (boolean)true));
    }

    public long getStateModificationCount() {
        return this.state.getModificationCount();
    }

    static {
        Companion = new Companion(null);
        Topic topic = Topic.create((String)"PasswordSafeSettingsListener", PasswordSafeSettingsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"Topic.create(\"PasswordSa\u2026ingsListener::class.java)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR/\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\n\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R/\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00168G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\n\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/credentialStore/PasswordSafeSettings$PasswordSafeOptions;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "isRememberPasswordByDefault", "()Z", "setRememberPasswordByDefault", "(Z)V", "isRememberPasswordByDefault$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "keepassDb", "getKeepassDb", "()Ljava/lang/String;", "setKeepassDb", "(Ljava/lang/String;)V", "keepassDb$delegate", "pgpKeyId", "getPgpKeyId", "setPgpKeyId", "pgpKeyId$delegate", "Lcom/intellij/credentialStore/ProviderType;", "provider", "getProvider", "()Lcom/intellij/credentialStore/ProviderType;", "setProvider", "(Lcom/intellij/credentialStore/ProviderType;)V", "provider$delegate", "intellij.platform.credentialStore"})
    public static final class PasswordSafeOptions
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty provider$delegate;
        @Nullable
        private final ReadWriteProperty keepassDb$delegate;
        @NotNull
        private final ReadWriteProperty isRememberPasswordByDefault$delegate;
        @Nullable
        private final ReadWriteProperty pgpKeyId$delegate;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PasswordSafeOptions.class, "provider", "getProvider()Lcom/intellij/credentialStore/ProviderType;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PasswordSafeOptions.class, "keepassDb", "getKeepassDb()Ljava/lang/String;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PasswordSafeOptions.class, "isRememberPasswordByDefault", "isRememberPasswordByDefault()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(PasswordSafeOptions.class, "pgpKeyId", "getPgpKeyId()Ljava/lang/String;", 0))};
        }

        @OptionTag(value="PROVIDER")
        @NotNull
        public final ProviderType getProvider() {
            return (ProviderType)((Object)this.provider$delegate.getValue((Object)this, $$delegatedProperties[0]));
        }

        public final void setProvider(@NotNull ProviderType providerType) {
            Intrinsics.checkNotNullParameter((Object)((Object)providerType), (String)"<set-?>");
            this.provider$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)providerType);
        }

        @Nullable
        public final String getKeepassDb() {
            return (String)this.keepassDb$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setKeepassDb(@Nullable String string) {
            this.keepassDb$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        public final boolean isRememberPasswordByDefault() {
            return (Boolean)this.isRememberPasswordByDefault$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setRememberPasswordByDefault(boolean bl) {
            this.isRememberPasswordByDefault$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        @Nullable
        public final String getPgpKeyId() {
            return (String)this.pgpKeyId$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public final void setPgpKeyId(@Nullable String string) {
            this.pgpKeyId$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
        }

        /*
         * WARNING - void declaration
         */
        public PasswordSafeOptions() {
            void this_$iv;
            BaseState baseState = this;
            Enum defaultValue$iv = Companion.getDefaultProviderType();
            boolean $i$f$enum = false;
            StoredPropertyBase storedPropertyBase = this_$iv.doEnum(defaultValue$iv, ProviderType.class);
            if (storedPropertyBase == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.components.StoredPropertyBase<T>");
            }
            this.provider$delegate = storedPropertyBase.provideDelegate((Object)this, $$delegatedProperties[0]);
            this.keepassDb$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
            this.isRememberPasswordByDefault$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
            this.pgpKeyId$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[3]);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/credentialStore/PasswordSafeSettings$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/credentialStore/PasswordSafeSettingsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "defaultProviderType", "Lcom/intellij/credentialStore/ProviderType;", "getDefaultProviderType", "()Lcom/intellij/credentialStore/ProviderType;", "intellij.platform.credentialStore"})
    public static final class Companion {
        private final ProviderType getDefaultProviderType() {
            return SystemInfo.isWindows ? ProviderType.KEEPASS : ProviderType.KEYCHAIN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

