/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OptionDescription
implements Comparable<OptionDescription> {
    @Nls
    private final String myOption;
    @NlsSafe
    private final String myHit;
    @NlsSafe
    private final String myPath;
    @NonNls
    private final String myConfigurableId;
    @Nls
    private final String myGroupName;

    public OptionDescription(@NlsSafe String hit) {
        this(null, hit, null);
    }

    public OptionDescription(@Nls String option, @NlsSafe String hit, @NlsSafe String path2) {
        this(option, null, hit, path2);
    }

    public OptionDescription(@Nls String option, @NonNls String configurableId, @NlsSafe String hit, @NlsSafe String path2) {
        this(option, configurableId, hit, path2, null);
    }

    public OptionDescription(@Nls String option, @NonNls String configurableId, @NlsSafe String hit, @NlsSafe String path2, @Nls String groupName) {
        this.myOption = option;
        this.myHit = hit;
        this.myPath = path2;
        this.myConfigurableId = configurableId;
        this.myGroupName = groupName;
    }

    @Nls
    public String getOption() {
        return this.myOption;
    }

    @NlsSafe
    @Nullable
    public String getHit() {
        return this.myHit;
    }

    @Nullable
    public String getPath() {
        return this.myPath;
    }

    @NonNls
    public String getConfigurableId() {
        return this.myConfigurableId;
    }

    @Nls
    public String getGroupName() {
        return this.myGroupName;
    }

    @NlsSafe
    public String getValue() {
        return null;
    }

    public boolean hasExternalEditor() {
        return false;
    }

    public void invokeInternalEditor() {
    }

    public String toString() {
        return this.myHit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionDescription that = (OptionDescription)o;
        if (!Objects.equals(this.myConfigurableId, that.myConfigurableId)) {
            return false;
        }
        if (!Objects.equals(this.myHit, that.myHit)) {
            return false;
        }
        if (!Objects.equals(this.myOption, that.myOption)) {
            return false;
        }
        return Objects.equals(this.myPath, that.myPath);
    }

    public int hashCode() {
        int result = this.myOption != null ? this.myOption.hashCode() : 0;
        result = 31 * result + (this.myHit != null ? this.myHit.hashCode() : 0);
        result = 31 * result + (this.myPath != null ? this.myPath.hashCode() : 0);
        result = 31 * result + (this.myConfigurableId != null ? this.myConfigurableId.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(OptionDescription o) {
        if (Comparing.strEqual((String)this.myHit, (String)o.getHit())) {
            return this.myOption != null ? this.myOption.compareTo(o.getOption()) : 0;
        }
        if (this.myHit != null && o.getHit() != null) {
            return this.myHit.compareTo(o.getHit());
        }
        return 0;
    }
}

