/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance(CurrentRevision.class);
    private final VirtualFile myFile;
    private final VcsRevisionNumber myRevisionNumber;

    public CurrentRevision(@NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
        if (file == null) {
            CurrentRevision.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            CurrentRevision.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myRevisionNumber = revision;
    }

    @Override
    public String getCommitMessage() {
        return "[" + CurrentRevision.getCurrent() + "]";
    }

    @Override
    public byte[] getContent() {
        return this.loadContent();
    }

    @Override
    public Date getRevisionDate() {
        return new Date(this.myFile.getTimeStamp());
    }

    @Override
    public byte[] loadContent() {
        try {
            Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(this.myFile));
            if (document != null) {
                return document.getText().getBytes(this.myFile.getCharset().name());
            }
            return this.myFile.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
        if (vcsRevisionNumber == null) {
            CurrentRevision.$$$reportNull$$$0(2);
        }
        return vcsRevisionNumber;
    }

    @Override
    public String getBranchName() {
        return null;
    }

    @Override
    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    @Nls
    public static String getCurrent() {
        return VcsBundle.message("vcs.revision.name.current", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/CurrentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/CurrentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

