/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyUiDisposable<T>
implements Activatable {
    private final AtomicReference<JComponent> myUI;
    private final Disposable myParent;
    private final T myChild;

    public LazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, @NotNull T child) {
        if (ui == null) {
            LazyUiDisposable.$$$reportNull$$$0(0);
        }
        if (child == null) {
            LazyUiDisposable.$$$reportNull$$$0(1);
        }
        this.myUI = new AtomicReference<JComponent>(ui);
        this.myParent = parent;
        this.myChild = child;
        new UiNotifyConnector.Once(ui, this);
    }

    @Override
    public final void showNotify() {
        JComponent ui = this.myUI.getAndSet(null);
        if (ui == null) {
            return;
        }
        Project project = null;
        Object parent = this.myParent;
        if (ApplicationManager.getApplication() != null) {
            DataContext context = DataManager.getInstance().getDataContext(ui);
            project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (parent == null) {
                parent = (Disposable)PlatformDataKeys.UI_DISPOSABLE.getData(context);
            }
        }
        if (parent == null) {
            if (project == null) {
                Logger.getInstance(LazyUiDisposable.class).warn("use application as a parent disposable");
                parent = Disposer.get((String)"ui");
            } else {
                Logger.getInstance(LazyUiDisposable.class).warn("use project as a parent disposable");
                parent = project;
            }
        }
        this.initialize((Disposable)parent, this.myChild, project);
        if (this.myChild instanceof Disposable) {
            Disposer.register((Disposable)parent, (Disposable)((Disposable)this.myChild));
        }
    }

    protected abstract void initialize(@NotNull Disposable var1, @NotNull T var2, @Nullable Project var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ui";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "child";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/ui/update/LazyUiDisposable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

