/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.stubs.PyClassAttributesIndex;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyStructuralTypeAttributesCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(PyStructuralTypeAttributesCompletionContributor.class);
    private static final Set<String> COMMON_OBJECT_ATTRIBUTES = ImmutableSet.of((Object)"__init__", (Object)"__new__", (Object)"__str__", (Object)"__repr__", (Object)"__doc__", (Object)"__class__", (Object[])new String[]{"__module__", "__dict__"});
    private static final PsiElementPattern.Capture<PsiElement> ATTRIBUTE_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PyTokenTypes.IDENTIFIER).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)PyTokenTypes.DOT))).withParent((ElementPattern)PlatformPatterns.psiElement(PyReferenceExpression.class));

    public PyStructuralTypeAttributesCompletionContributor() {
        this.extend(CompletionType.SMART, (ElementPattern)ATTRIBUTE_PATTERN, new AttributesCompletionProvider());
    }

    private static class AttributesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private AttributesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PyReferenceExpression refExpr;
            if (parameters == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((refExpr = PyUtil.as((position = parameters.getPosition()).getParent(), PyReferenceExpression.class)) == null || !refExpr.isQualified() || parameters.getCompletionType() != CompletionType.SMART) {
                return;
            }
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(refExpr.getProject(), parameters.getOriginalFile());
            PyStructuralType structType = PyUtil.as(typeEvalContext.getType(refExpr.getQualifier()), PyStructuralType.class);
            LOG.debug("Structural type: " + structType);
            if (structType != null) {
                HashSet names = Sets.newHashSet(structType.getAttributeNames());
                names.remove(refExpr.getReferencedName());
                Set<PyClass> suitableClasses = this.suggestClassesFromUsedAttributes((PsiElement)refExpr, names, typeEvalContext);
                LOG.debug("Result classes that contain attributes " + names + ": ", new Object[]{suitableClasses});
                for (PyClass pyClass : suitableClasses) {
                    Object[] variants;
                    PsiElement origPosition = parameters.getOriginalPosition();
                    String prefix = origPosition != null && origPosition.getNode().getElementType() == PyTokenTypes.IDENTIFIER ? origPosition.getText() : "";
                    for (Object variant : variants = new PyClassTypeImpl(pyClass, false).getCompletionVariants(prefix, position, context)) {
                        if (!(variant instanceof LookupElement)) continue;
                        result.addElement((LookupElement)variant);
                    }
                }
            }
        }

        private Set<PyClass> suggestClassesFromUsedAttributes(@NotNull PsiElement anchor, @NotNull Set<String> seenAttrs, @NotNull TypeEvalContext context) {
            if (anchor == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (seenAttrs == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(4);
            }
            if (context == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(5);
            }
            HashSet<PyClass> candidates = new HashSet<PyClass>();
            HashMap ancestorsCache = Maps.newHashMap();
            for (String attribute : seenAttrs) {
                if (COMMON_OBJECT_ATTRIBUTES.contains(attribute)) {
                    candidates.add(PyBuiltinCache.getInstance(anchor).getClass("object"));
                    continue;
                }
                Collection<PyClass> declaringClasses = PyClassAttributesIndex.find(attribute, anchor.getProject());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Classes containing " + attribute + ": " + ContainerUtil.map(declaringClasses, AttributesCompletionProvider::debugClassCoordinates));
                }
                candidates.addAll(declaringClasses);
            }
            HashSet<PyClass> suitableClasses = new HashSet<PyClass>();
            for (PyClass candidate : candidates) {
                if (PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(candidate.getContainingFile())) continue;
                Set<String> inherited = this.getAllInheritedAttributeNames(candidate, context, ancestorsCache);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("All attributes of " + AttributesCompletionProvider.debugClassCoordinates(candidate) + ": " + inherited);
                }
                if (!inherited.containsAll(seenAttrs)) continue;
                suitableClasses.add(candidate);
            }
            return Collections.unmodifiableSet(suitableClasses);
        }

        @NotNull
        private Set<String> getAllInheritedAttributeNames(@NotNull PyClass candidate, @NotNull TypeEvalContext context, @NotNull Map<PyClass, Set<PyClass>> ancestorsCache) {
            if (candidate == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(6);
            }
            if (context == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(7);
            }
            if (ancestorsCache == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(8);
            }
            HashSet availableAttrs = Sets.newHashSet(PyClassAttributesIndex.getAllDeclaredAttributeNames(candidate));
            for (PyClass parent : this.getAncestorClassesFast(candidate, context, ancestorsCache)) {
                availableAttrs.addAll(PyClassAttributesIndex.getAllDeclaredAttributeNames(parent));
            }
            HashSet hashSet = availableAttrs;
            if (hashSet == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private Set<PyClass> getAncestorClassesFast(@NotNull PyClass pyClass, @NotNull TypeEvalContext context, @NotNull Map<PyClass, Set<PyClass>> ancestorsCache) {
            Set<PyClass> ancestors;
            if (pyClass == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(10);
            }
            if (context == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(11);
            }
            if (ancestorsCache == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(12);
            }
            if ((ancestors = ancestorsCache.get(pyClass)) != null) {
                Set<PyClass> set = ancestors;
                if (set == null) {
                    AttributesCompletionProvider.$$$reportNull$$$0(13);
                }
                return set;
            }
            ancestorsCache.put(pyClass, Collections.emptySet());
            HashSet<PyClass> result = new HashSet<PyClass>();
            try {
                for (PyClassLikeType baseType : pyClass.getSuperClassTypes(context)) {
                    if (!(baseType instanceof PyClassType)) continue;
                    PyClass baseClass = ((PyClassType)baseType).getPyClass();
                    result.add(baseClass);
                    result.addAll(this.getAncestorClassesFast(baseClass, context, ancestorsCache));
                }
            }
            finally {
                result.remove(pyClass);
                ancestorsCache.put(pyClass, Collections.unmodifiableSet(result));
            }
            HashSet<PyClass> hashSet = result;
            if (hashSet == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(14);
            }
            return hashSet;
        }

        @NotNull
        private static String debugClassCoordinates(PyClass cls) {
            String string = cls.getQualifiedName() + " (" + cls.getContainingFile().getVirtualFile().getPath() + ")";
            if (string == null) {
                AttributesCompletionProvider.$$$reportNull$$$0(15);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 5: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "seenAttrs";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestorsCache";
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyStructuralTypeAttributesCompletionContributor$AttributesCompletionProvider";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyStructuralTypeAttributesCompletionContributor$AttributesCompletionProvider";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllInheritedAttributeNames";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAncestorClassesFast";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "debugClassCoordinates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestClassesFromUsedAttributes";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllInheritedAttributeNames";
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getAncestorClassesFast";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

