/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUserSkeletonsUtil {
    public static final String USER_SKELETONS_DIR = "python-skeletons";
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil");
    public static final Key<Boolean> HAS_SKELETON = Key.create((String)"PyUserSkeleton.hasSkeleton");
    private static final ImmutableSet<String> STDLIB_SKELETONS = ImmutableSet.of((Object)"asyncio", (Object)"multiprocessing", (Object)"os", (Object)"_csv.py", (Object)"copy.py", (Object)"cStringIO.py", (Object[])new String[]{"decimal.py", "io.py", "itertools.py", "logging.py", "pathlib.py", "pickle.py", "StringIO.py", "struct.py", "sys.py"});
    @Nullable
    private static VirtualFile ourUserSkeletonsDirectory;
    private static boolean ourNoSkeletonsErrorReported;

    @NotNull
    private static List<String> getPossibleUserSkeletonsPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PathManager.getConfigPath() + File.separator + USER_SKELETONS_DIR);
        result.add(PythonHelpersLocator.getHelperPath(USER_SKELETONS_DIR));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile getUserSkeletonsDirectory() {
        if (ourUserSkeletonsDirectory == null) {
            for (String path : PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths()) {
                ourUserSkeletonsDirectory = StandardFileSystems.local().findFileByPath(path);
                if (ourUserSkeletonsDirectory == null) continue;
                break;
            }
        }
        if (!ourNoSkeletonsErrorReported && ourUserSkeletonsDirectory == null) {
            ourNoSkeletonsErrorReported = true;
            LOG.warn("python-skeletons directory not found in paths: " + PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths());
        }
        return ourUserSkeletonsDirectory;
    }

    public static boolean isUnderUserSkeletonsDirectory(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return false;
        }
        return PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(virtualFile);
    }

    public static boolean isUnderUserSkeletonsDirectory(@NotNull VirtualFile virtualFile) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(2);
        }
        return (skeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static boolean isStandardLibrarySkeleton(@NotNull VirtualFile virtualFile) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(3);
        }
        if ((skeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) == null) {
            return false;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)skeletonsDir, (char)'/');
        if (relativePath == null) {
            return false;
        }
        String firstComponent = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)relativePath, (String)"/"));
        return STDLIB_SKELETONS.contains((Object)firstComponent);
    }

    @Nullable
    public static <T extends PyElement> T getUserSkeleton(@NotNull T element) {
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(4);
        }
        return PyUserSkeletonsUtil.getUserSkeletonWithContext(element, null);
    }

    @Nullable
    public static <T extends PyElement> T getUserSkeletonWithContext(@NotNull T element, @Nullable TypeEvalContext context) {
        PyFile skeletonFile;
        PsiFile file;
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(5);
        }
        if ((file = element.getContainingFile()) instanceof PyFile && (skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForFile((PyFile)file)) != null && skeletonFile != file) {
            PsiElement skeletonElement = PyUserSkeletonsUtil.getUserSkeleton(element, skeletonFile, context);
            if (element.getClass().isInstance(skeletonElement) && skeletonElement != element) {
                return (T)((PyElement)skeletonElement);
            }
        }
        return null;
    }

    @Nullable
    public static PyFile getUserSkeletonForModuleQName(@NotNull String qName, @NotNull PsiElement foothold) {
        Sdk sdk;
        if (qName == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(6);
        }
        if (foothold == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(7);
        }
        if ((sdk = PythonSdkUtil.findPythonSdk(foothold)) != null) {
            VirtualFile directory2;
            QualifiedName cacheQName;
            Project project = foothold.getProject();
            PythonSdkPathCache cache2 = PythonSdkPathCache.getInstance(project, sdk);
            List<PsiElement> results = cache2.get(cacheQName = QualifiedName.fromDottedString((String)("python-skeletons." + qName)));
            if (results != null) {
                PsiElement element;
                PsiElement psiElement = element = results.isEmpty() ? null : results.get(0);
                if (element instanceof PyFile) {
                    return (PyFile)element;
                }
            }
            if ((directory2 = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(directory2);
                PsiElement fileSkeleton = PyResolveImportUtil.resolveModuleAt(QualifiedName.fromDottedString((String)qName), (PsiFileSystemItem)psiDirectory, PyResolveImportUtil.fromFoothold(foothold)).stream().findFirst().orElse(null);
                if (fileSkeleton instanceof PsiDirectory) {
                    fileSkeleton = PyUtil.getPackageElement((PsiDirectory)fileSkeleton, foothold);
                }
                if (fileSkeleton instanceof PyFile) {
                    cache2.put(cacheQName, Collections.singletonList(fileSkeleton));
                    return (PyFile)fileSkeleton;
                }
            }
            cache2.put(cacheQName, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    private static PsiElement getUserSkeleton(@NotNull PyElement element, @NotNull PyFile skeletonFile, @Nullable TypeEvalContext context) {
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(8);
        }
        if (skeletonFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(9);
        }
        if (element instanceof PyFile) {
            return skeletonFile;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
        String name = element.getName();
        if (owner != null && name != null) {
            assert (owner != element);
            PsiElement originalOwner = PyUserSkeletonsUtil.getUserSkeleton(owner, skeletonFile, context);
            if (originalOwner instanceof PyClass) {
                PyClass classOwner = (PyClass)originalOwner;
                PyType type = TypeEvalContext.codeInsightFallback(classOwner.getProject()).getType(classOwner);
                if (type instanceof PyClassLikeType) {
                    List<? extends RatedResolveResult> resolveResults;
                    PyClassLikeType classType = (PyClassLikeType)type;
                    PyClassLikeType instanceType = (PyClassLikeType)classType.toInstance();
                    PyResolveContext resolveContext = PyResolveContext.defaultContext();
                    if (context != null) {
                        resolveContext = resolveContext.withTypeEvalContext(context);
                    }
                    if ((resolveResults = instanceType.resolveMember(name, null, AccessDirection.READ, resolveContext, false)) != null && !resolveResults.isEmpty()) {
                        return resolveResults.get(0).getElement();
                    }
                }
            } else if (originalOwner instanceof PyFile) {
                return ((PyFile)originalOwner).getElementNamed(name);
            }
        }
        return null;
    }

    @Nullable
    private static PyFile getUserSkeletonForFile(@NotNull PyFile file) {
        String moduleName;
        Boolean hasSkeleton;
        if (file == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(10);
        }
        if ((hasSkeleton = (Boolean)file.getUserData(HAS_SKELETON)) != null && !hasSkeleton.booleanValue()) {
            return null;
        }
        VirtualFile moduleVirtualFile = file.getVirtualFile();
        if (moduleVirtualFile != null && (moduleName = QualifiedNameFinder.findShortestImportableName((PsiElement)file, moduleVirtualFile)) != null) {
            PyFile skeletonFile;
            QualifiedName qName = QualifiedName.fromDottedString((String)moduleName);
            QualifiedName restored = QualifiedNameFinder.canonizeQualifiedName((PsiElement)file, qName, null);
            if (restored != null) {
                moduleName = restored.toString();
            }
            file.putUserData(HAS_SKELETON, (skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForModuleQName(moduleName, (PsiElement)file)) != null);
            return skeletonFile;
        }
        return null;
    }

    static {
        ourNoSkeletonsErrorReported = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleUserSkeletonsPaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderUserSkeletonsDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStandardLibrarySkeleton";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeleton";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonWithContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonForModuleQName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

