/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.exceptons.NoSdkException;
import training.learn.lesson.kimpl.LessonUtil;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001b0!H\u0016J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J=\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001f2!\u0010/\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u001b0!H\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Lcom/jetbrains/python/ift/PythonLangSupport;", "Ltraining/lang/AbstractLangSupport;", "()V", "defaultProductName", "", "getDefaultProductName", "()Ljava/lang/String;", "defaultProjectName", "getDefaultProjectName", "filename", "getFilename", "langCourseFeedback", "getLangCourseFeedback", "primaryLanguage", "getPrimaryLanguage", "projectSandboxRelativePath", "getProjectSandboxRelativePath", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "sourcesDirectoryName", "useVenv", "", "getUseVenv", "()Z", "applyProjectSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "applyToProjectAfterConfigure", "Lkotlin/Function1;", "blockProjectFileModification", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkSdk", "createVenv", "findSystemWideSdk", "getExistingSdks", "", "getSdkForProject", "installAndOpenLearningProject", "projectPath", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/ParameterName;", "name", "learnProject", "isNoOlderThan27", "intellij.python.featuresTrainer"})
public final class PythonLangSupport
extends AbstractLangSupport {
    @NotNull
    private final String defaultProjectName;
    @NotNull
    private final String primaryLanguage;
    @NotNull
    private final String defaultProductName;
    private final String sourcesDirectoryName;
    @NotNull
    private final String filename;
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String projectSandboxRelativePath;

    @NotNull
    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    @NotNull
    public String getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    @NotNull
    public String getDefaultProductName() {
        return this.defaultProductName;
    }

    @NotNull
    public String getFilename() {
        return this.filename;
    }

    @Nullable
    public String getLangCourseFeedback() {
        return UtilsKt.getFeedbackLink((LangSupport)((LangSupport)this), (boolean)false);
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    @NotNull
    public Function1<Project, Unit> applyToProjectAfterConfigure() {
        return (Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PythonLangSupport this$0;

            public final void invoke(@NotNull Project project) {
                ContentEntry contentEntry;
                boolean bl;
                Object object;
                ModifiableRootModel rootsModel;
                VirtualFile sourcesRoot;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Object[] objectArray = PyStatisticToolsKt.getModules(project);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
                    Module module = (Module)ArraysKt.first((Object[])objectArray);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = project.getBasePath();
                    Intrinsics.checkNotNull((Object)string);
                    String sourcesPath = stringBuilder.append(string).append('/').append(PythonLangSupport.access$getSourcesDirectoryName$p(this.this$0)).toString();
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourcesPath);
                    if (virtualFile == null) {
                        String string2 = "Failed to find directory with source files: " + sourcesPath;
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026rce files: $sourcesPath\")");
                    sourcesRoot = virtualFile;
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    ModifiableRootModel modifiableRootModel = moduleRootManager.getModifiableModel();
                    Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"ModuleRootManager.getIns\u2026e(module).modifiableModel");
                    rootsModel = modifiableRootModel;
                    ContentEntry[] contentEntryArray = rootsModel.getContentEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"rootsModel.contentEntries");
                    object = contentEntryArray;
                    bl = false;
                    ContentEntry[] contentEntryArray2 = object;
                    boolean bl3 = false;
                    ContentEntry[] contentEntryArray3 = contentEntryArray2;
                    int n = contentEntryArray3.length;
                    for (int i = 0; i < n; ++i) {
                        ContentEntry contentEntry2;
                        ContentEntry it = contentEntry2 = contentEntryArray3[i];
                        boolean bl4 = false;
                        ContentEntry contentEntry3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry3, (String)"it");
                        VirtualFile contentEntryFile = contentEntry3.getFile();
                        boolean bl5 = contentEntryFile != null && VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)sourcesRoot, (boolean)false);
                        if (!bl5) continue;
                        contentEntry = contentEntry2;
                        break block3;
                    }
                    contentEntry = null;
                }
                if (contentEntry == null) {
                    object = "Failed to find content entry for file: " + sourcesRoot.getName();
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                ContentEntry contentEntry4 = contentEntry;
                contentEntry4.addSourceFolder(sourcesRoot, false);
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(rootsModel, project){
                    final /* synthetic */ ModifiableRootModel $rootsModel$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$rootsModel$inlined = modifiableRootModel;
                        this.$project$inlined = project;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.$rootsModel$inlined.commit();
                        this.$project$inlined.save();
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = pythonLangSupport;
                super(1);
            }
        };
    }

    public void installAndOpenLearningProject(@NotNull Path projectPath, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask = new OpenProjectTask(false, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, true, false, null, null, null, 1015805, null);
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(projectPath, (LangSupport)this, openProjectTask, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        return this.getUseVenv() ? this.createVenv(project) : this.findSystemWideSdk(project);
    }

    /*
     * WARNING - void declaration
     */
    private final Sdk findSystemWideSdk(Project project) {
        void $this$filterTo$iv$iv;
        List sdkList2;
        List list = sdkList2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<List<? extends Sdk>, Exception>(project){
            final /* synthetic */ Project $project;

            public final List<Sdk> compute() {
                return PySdkExtKt.findAllPythonSdks(Path.of(this.$project.getBasePath(), new String[0]));
            }
            {
                this.$project = project;
            }
        }, LearnBundle.INSTANCE.message("learn.project.initializing.python.sdk.finding.progress.title", new Object[0]), false, project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sdkList");
        Iterable $this$filter$iv = PySdkExtKt.filterSystemWideSdks(list);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            if (!(this.isNoOlderThan27(it) && !PythonSdkUtil.isInvalid(it) && !PythonSdkUtil.isVirtualEnv(it) && !PythonSdkUtil.isCondaVirtualEnv(it) && !PythonSdkUtil.isRemote(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        Comparator comparator = ((Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Sdk sdk = (Sdk)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(PythonSdkUtil.isConda(sdk));
                sdk = (Sdk)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Boolean.valueOf(PythonSdkUtil.isConda(sdk));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }).thenComparing(PreferredSdkComparator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"compareBy { sdk: Sdk -> \u2026edSdkComparator.INSTANCE)");
        Sdk preferredSdk = (Sdk)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)iterable2, comparator));
        if (preferredSdk == null) {
            throw (Throwable)new NoSdkException();
        }
        if (preferredSdk instanceof PyDetectedSdk) {
            String string = ((PyDetectedSdk)preferredSdk).getHomePath();
            Intrinsics.checkNotNull((Object)string);
            preferredSdk = SdkConfigurationUtil.createAndAddSDK((String)string, (SdkType)PythonSdkType.getInstance());
        }
        return preferredSdk;
    }

    private final Sdk createVenv(Project project) {
        Sdk sdk;
        Sdk venvSdk;
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Module module = (Module)ArraysKt.first((Object[])objectArray);
        List<Sdk> existingSdks = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks, module, (UserDataHolder)project);
        Sdk preferredSdk = PyProjectVirtualEnvConfiguration.INSTANCE.findPreferredVirtualEnvBaseSdk(baseSdks);
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026sePath(project.basePath))");
        String venvRoot = string;
        Sdk sdk2 = venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration.INSTANCE, preferredSdk, existingSdks, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, 384, null);
        if (sdk2 != null) {
            Sdk sdk3 = sdk2;
            boolean bl = false;
            boolean bl2 = false;
            Sdk it = sdk3;
            boolean bl3 = false;
            SdkConfigurationUtil.addSdk((Sdk)it);
            sdk = sdk3;
        } else {
            sdk = null;
        }
        return sdk;
    }

    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Object object = ArraysKt.first((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.modules.first()");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)object, sdk);
        if (!this.getUseVenv() && Intrinsics.areEqual((Object)LessonUtil.INSTANCE.getProductName(), (Object)this.getDefaultProductName()) ^ true) {
            ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
            rootManager.addProjectJdkListener(new ProjectRootManagerEx.ProjectJdkListener(rootManager, project, sdk){
                final /* synthetic */ ProjectRootManagerEx $rootManager;
                final /* synthetic */ Project $project;
                final /* synthetic */ Sdk $sdk;

                public final void projectJdkChanged() {
                    ProjectRootManagerEx projectRootManagerEx = this.$rootManager;
                    Intrinsics.checkNotNullExpressionValue((Object)projectRootManagerEx, (String)"rootManager");
                    Sdk sdk = projectRootManagerEx.getProjectSdk();
                    if (!((sdk != null ? sdk.getSdkType() : null) instanceof PythonSdkType)) {
                        Object[] objectArray = PyStatisticToolsKt.getModules(this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
                        Object object = ArraysKt.first((Object[])objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.modules.first()");
                        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(this.$project, (Module)object, this.$sdk);
                    }
                }
                {
                    this.$rootManager = projectRootManagerEx;
                    this.$project = project;
                    this.$sdk = sdk;
                }
            });
        }
    }

    private final List<Sdk> getExistingSdks() {
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        List<Sdk> list = pyConfigurableInterpreterList.getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyConfigurableInterprete\u2026tance(null).allPythonSdks");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"PreferredSdkComparator.INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    private final boolean isNoOlderThan27(Sdk sdk) {
        LanguageLevel languageLevel;
        LanguageLevel languageLevel2;
        if (sdk instanceof PyDetectedSdk) {
            languageLevel2 = PySdkExtKt.getGuessedLanguageLevel((PyDetectedSdk)sdk);
        } else {
            PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk);
            languageLevel2 = pythonSdkFlavor != null ? pythonSdkFlavor.getLanguageLevel(sdk) : null;
        }
        LanguageLevel languageLevel3 = languageLevel = languageLevel2;
        return languageLevel3 != null ? languageLevel3.isAtLeast(LanguageLevel.PYTHON27) : false;
    }

    private final boolean getUseVenv() {
        return Registry.is((String)"ide.features.trainer.use.venv");
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public boolean blockProjectFileModification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)this.getProjectSandboxRelativePath()) ^ true;
    }

    @NotNull
    public String getProjectSandboxRelativePath() {
        return this.projectSandboxRelativePath;
    }

    public PythonLangSupport() {
        this.defaultProjectName = "PyCharmLearningProject";
        this.primaryLanguage = "Python";
        this.defaultProductName = "PyCharm";
        this.sourcesDirectoryName = "src";
        this.filename = "Learning.py";
        this.projectSandboxRelativePath = "src/sandbox.py";
    }

    public static final /* synthetic */ String access$getSourcesDirectoryName$p(PythonLangSupport $this) {
        return $this.sourcesDirectoryName;
    }
}

