/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IronPythonSdkFlavor
extends PythonSdkFlavor {
    public static final Pattern VERSION_RE = Pattern.compile("\\w+ ([0-9\\.]+).*");

    private IronPythonSdkFlavor() {
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @Nullable
    public String envPathParam() {
        return "IRONPYTHONPATH";
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        File[] dirs;
        TreeSet<String> result = new TreeSet<String>();
        String root = System.getenv("ProgramFiles(x86)");
        if (root == null) {
            root = System.getenv("ProgramFiles");
        }
        if (root != null && (dirs = new File(root).listFiles()) != null) {
            for (File dir : dirs) {
                File ipy;
                if (!dir.getName().startsWith("IronPython") || !(ipy = new File(dir, "ipy.exe")).exists()) continue;
                result.add(ipy.getPath());
            }
        }
        WinPythonSdkFlavor.findInPath(result, "ipy.exe");
        WinPythonSdkFlavor.findInPath(result, "ipy64.exe");
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        String name;
        if (file == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return (name = file.getName()).equals("ipy.exe") || name.equals("ipy64.exe");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        String match;
        if (output == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        return (match = PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE)) != null ? this.getName() + " " + match : null;
    }

    @Override
    public String getVersionOption() {
        return "-V";
    }

    @Override
    public Collection<String> getExtraDebugOptions() {
        return Collections.singletonList("-X:Frames");
    }

    @Override
    public void initPythonPath(GeneralCommandLine cmd, boolean passParentEnvs, Collection<String> path) {
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    @Override
    public void initPythonPath(Collection<String> path, boolean passParentEnvs, Map<String, String> env) {
        PythonEnvUtil.addToEnv("IRONPYTHONPATH", StringUtil.join(path, (String)File.pathSeparator), env);
    }

    @Override
    @NotNull
    public String getName() {
        return "IronPython";
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Dotnet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

