/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.UtilBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltraining/project/FileUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyDirWithDestFilter", "", "fromDir", "Ljava/io/File;", "toDir", "destinationFilter", "Ljava/io/FileFilter;", "copyJarResourcesRecursively", "", "destDir", "jarConnection", "Ljava/net/JarURLConnection;", "copyResourcesRecursively", "originUrl", "Ljava/net/URL;", "destination", "copyStream", "inputStream", "Ljava/io/InputStream;", "f", "os", "Ljava/io/OutputStream;", "ensureDirectoryExists", "intellij.featuresTrainer"})
public final class FileUtils {
    private static final Logger LOG;
    public static final FileUtils INSTANCE;

    public final boolean copyJarResourcesRecursively(@NotNull File destDir, @NotNull JarURLConnection jarConnection, @Nullable FileFilter destinationFilter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)jarConnection, (String)"jarConnection");
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry;
            JarEntry jarEntry = entry = entries.nextElement();
            Intrinsics.checkNotNullExpressionValue((Object)jarEntry, (String)"entry");
            String string = jarEntry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            String string2 = jarConnection.getEntryName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jarConnection.entryName");
            if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            String filename = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            File f = new File(destDir, filename);
            if (destinationFilter != null && !destinationFilter.accept(f)) continue;
            if (!entry.isDirectory()) {
                InputStream entryInputStream;
                InputStream inputStream = entryInputStream = jarFile.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"entryInputStream");
                if (!this.copyStream(inputStream, f)) {
                    return false;
                }
                entryInputStream.close();
                continue;
            }
            if (this.ensureDirectoryExists(f)) continue;
            throw (Throwable)new IOException("Could not create directory: " + f.getAbsolutePath());
        }
        return true;
    }

    public static /* synthetic */ boolean copyJarResourcesRecursively$default(FileUtils fileUtils, File file, JarURLConnection jarURLConnection, FileFilter fileFilter, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyJarResourcesRecursively(file, jarURLConnection, fileFilter);
    }

    public final boolean copyResourcesRecursively(@NotNull URL originUrl, @NotNull File destination, @Nullable FileFilter destinationFilter) {
        Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection, destinationFilter);
            } else {
                this.copyDirWithDestFilter(new File(originUrl.getPath()), destination, destinationFilter);
            }
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean copyResourcesRecursively$default(FileUtils fileUtils, URL uRL, File file, FileFilter fileFilter, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyResourcesRecursively(uRL, file, fileFilter);
    }

    private final void copyDirWithDestFilter(File fromDir, File toDir, FileFilter destinationFilter) {
        FileUtil.ensureExists((File)toDir);
        if (FileUtil.isAncestor((File)fromDir, (File)toDir, (boolean)true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] fileArray = fromDir.listFiles();
        if (fileArray == null) {
            throw (Throwable)new IOException(UtilBundle.message((String)"exception.directory.is.invalid", (Object[])new Object[]{fromDir.getPath()}));
        }
        File[] files = fileArray;
        if (!fromDir.canRead()) {
            throw (Throwable)new IOException(UtilBundle.message((String)"exception.directory.is.not.readable", (Object[])new Object[]{fromDir.getPath()}));
        }
        File[] fileArray2 = files;
        int n = fileArray2.length;
        for (int j = 0; j < n; ++j) {
            File file;
            File file2 = file = fileArray2[j];
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            File destinationFile = new File(toDir, file2.getName());
            if (file.isDirectory()) {
                this.copyDirWithDestFilter(file, destinationFile, destinationFilter);
                continue;
            }
            if (destinationFilter != null && !destinationFilter.accept(destinationFile)) continue;
            FileUtil.copy((File)file, (File)destinationFile);
        }
    }

    private final boolean copyStream(InputStream inputStream, File f) {
        try {
            return this.copyStream(inputStream, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private final boolean copyStream(InputStream inputStream, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            int len = inputStream.read(buf);
            while (len > 0) {
                os.write(buf, 0, len);
                len = inputStream.read(buf);
            }
            inputStream.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public final boolean ensureDirectoryExists(@NotNull File f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return f.exists() || f.mkdir();
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        Logger logger = Logger.getInstance(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileUtils::class.java)");
        LOG = logger;
    }
}

