/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.i18n.GitBundle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002\u001a&\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\nH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "feedUrl", "", "downloadGit", "", "installer", "Lgit4idea/config/GitInstaller;", "fileToSave", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "downloadGitJson", "", "downloadListOfGitInstallers", "", "fetchInstaller", "condition", "Lkotlin/Function1;", "parse", "node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "readTree", "rawData", "verifyHashCode", "", "downloadedFile", "intellij.vcs.git"})
public final class GitDownloadAndInstallKt {
    private static final String feedUrl = "https://download.jetbrains.com/jdk/feed/v1/gits.json.xz";
    private static final Logger LOG;

    @Nullable
    public static final GitInstaller fetchInstaller(@NotNull ErrorNotifier errorNotifier, @NotNull Function1<? super GitInstaller, Boolean> condition) {
        Object v1;
        List<GitInstaller> installers;
        block4: {
            List<GitInstaller> list2;
            Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            try {
                list2 = GitDownloadAndInstallKt.downloadListOfGitInstallers();
            }
            catch (Throwable t) {
                LOG.warn(t);
                String string = GitBundle.message("install.general.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.general.error\")");
                errorNotifier.showError(string);
                return null;
            }
            installers = list2;
            Iterable iterable = installers;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                if (!((Boolean)condition.invoke(t)).booleanValue()) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        GitInstaller matchingInstaller = v1;
        if (matchingInstaller != null) {
            return matchingInstaller;
        }
        LOG.warn("Couldn't find installer among " + installers);
        String string = GitBundle.message("install.general.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.general.error\")");
        errorNotifier.showError(string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<GitInstaller> downloadListOfGitInstallers() {
        List<GitInstaller> list2;
        byte[] compressedJson = GitDownloadAndInstallKt.downloadGitJson();
        try {
            byte[] byArray;
            list2 = new ByteArrayInputStream(compressedJson);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray2;
                ByteArrayInputStream input = (ByteArrayInputStream)((Object)list2);
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray2 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray = byArray2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list2), (Throwable)throwable);
            }
            list2 = (List<GitInstaller>)byArray;
        }
        catch (Throwable t) {
            throw (Throwable)new RuntimeException("Failed to unpack the list of available Gits from https://download.jetbrains.com/jdk/feed/v1/gits.json.xz. " + t.getMessage(), t);
        }
        List<GitInstaller> jsonBytes = list2;
        try {
            list2 = GitDownloadAndInstallKt.parse(GitDownloadAndInstallKt.readTree((byte[])jsonBytes));
        }
        catch (Throwable t) {
            throw (Throwable)new RuntimeException("Failed to parse the downloaded list of available Gits. " + t.getMessage(), t);
        }
        return list2;
    }

    private static final byte[] downloadGitJson() {
        RequestBuilder requestBuilder = HttpRequests.request((String)feedUrl).productNameAsUserAgent();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        byte[] byArray = requestBuilder.readBytes(progressManager.getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"HttpRequests\n    .reques\u2026ance().progressIndicator)");
        return byArray;
    }

    private static final ObjectNode readTree(byte[] rawData) {
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode == null) {
            String string = "Unexpected JSON data";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitInstaller> parse(ObjectNode node2) {
        void $this$filterIsInstanceTo$iv$iv;
        JsonNode jsonNode = node2.get("gits");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            String string = "`gits` element is missing in JSON";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ArrayNode items = arrayNode;
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            Object object = item.get("os");
            if (object == null || (object = object.asText()) == null) {
                continue;
            }
            Object object2 = item.get("arch");
            if (object2 == null || (object2 = object2.asText()) == null) {
                continue;
            }
            Object object3 = item.get("version");
            if (object3 == null || (object3 = object3.asText()) == null) {
                continue;
            }
            Object object4 = item.get("url");
            if (object4 == null || (object4 = object4.asText()) == null) {
                continue;
            }
            Object object5 = item.get("fileName");
            if (object5 == null || (object5 = object5.asText()) == null) {
                continue;
            }
            JsonNode jsonNode2 = item.get("pkgFileName");
            Object object6 = item.get("sha256");
            if (object6 == null || (object6 = object6.asText()) == null) {
                continue;
            }
            Object object7 = object6;
            String string = jsonNode2 != null ? jsonNode2.asText() : null;
            Object object8 = object5;
            Object object9 = object4;
            Object object10 = object3;
            Object object11 = object2;
            Object object12 = object;
            result2.add(new GitInstaller((String)object12, (String)object11, (String)object10, (String)object9, (String)object8, string, (String)object7));
        }
        return result2;
    }

    public static final boolean downloadGit(@NotNull GitInstaller installer2, @NotNull File fileToSave, @NotNull Project project, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)installer2, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)fileToSave, (String)"fileToSave");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        try {
            RequestBuilder requestBuilder = HttpRequests.request((String)installer2.getUrl()).productNameAsUserAgent();
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            requestBuilder.saveToFile(fileToSave, progressManager.getProgressIndicator());
            GitDownloadAndInstallKt.verifyHashCode(installer2, fileToSave);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Couldn't download " + installer2.getFileName() + " from " + installer2.getUrl(), (Throwable)e);
            String string = GitBundle.message("install.general.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.general.error\")");
            errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(project));
            return false;
        }
    }

    private static final void verifyHashCode(GitInstaller installer2, File downloadedFile) {
        String string = Files.asByteSource((File)downloadedFile).hash(Hashing.sha256()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Files.asByteSource(downl\u2026hing.sha256()).toString()");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)installer2.getSha256(), (boolean)true)) {
            throw (Throwable)new IllegalStateException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + installer2.getSha256());
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.config.GitDownloadAndInstall");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#git\u2026g.GitDownloadAndInstall\")");
        LOG = logger;
    }
}

