/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "StoreRecentPlacesListener", "intellij.completionMlRanking"})
public final class RecentPlacesFeatures
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "recent_places";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
        boolean inRecentPlaces = StoreRecentPlacesListener.Companion.isInRecentPlaces(string);
        String string2 = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.lookupString");
        boolean inChildrenRecentPlaces = StoreRecentPlacesListener.Companion.isInChildrenRecentPlaces(string2);
        return inRecentPlaces && inChildrenRecentPlaces ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"contains", (Object)MLFeatureValue.Companion.binary(true)), TuplesKt.to((Object)"children_contains", (Object)MLFeatureValue.Companion.binary(true))}) : (inRecentPlaces ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"contains", (Object)MLFeatureValue.Companion.binary(true))) : (inChildrenRecentPlaces ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"children_contains", (Object)MLFeatureValue.Companion.binary(true))) : MapsKt.emptyMap()));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J%\u0010\u000f\u001a\u00020\t\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u0012\u001a\u0002H\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures$StoreRecentPlacesListener;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "findDeclaration", "Lcom/intellij/psi/PsiElement;", "element", "recentPlaceAdded", "", "changePlace", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "isChanged", "", "recentPlaceRemoved", "addToTop", "T", "", "value", "(Ljava/util/Set;Ljava/lang/Object;)V", "getChildrenNames", "", "", "Companion", "intellij.completionMlRanking"})
    public static final class StoreRecentPlacesListener
    implements IdeDocumentHistoryImpl.RecentPlacesListener {
        private final Project project;
        private static final Set<String> recentPlaces;
        private static final Set<String> childrenRecentPlaces;
        private static final int MAX_CHILDREN_PER_PLACE = 10;
        public static final Companion Companion;

        public void recentPlaceAdded(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) break block8;
                    VirtualFile virtualFile = changePlace.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"changePlace.file");
                    if (virtualFile.isValid()) break block9;
                }
                return;
            }
            FileViewProvider fileViewProvider = PsiManager.getInstance((Project)this.project).findViewProvider(changePlace.getFile());
            if (fileViewProvider == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"PsiManager.getInstance(p\u2026angePlace.file) ?: return");
            FileViewProvider provider = fileViewProvider;
            NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(provider.getBaseLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"LanguageNamesValidation.\u2026ge(provider.baseLanguage)");
            NamesValidator namesValidator2 = namesValidator;
            RangeMarker rangeMarker = changePlace.getCaretPosition();
            if (rangeMarker == null) {
                return;
            }
            int offset = rangeMarker.getStartOffset();
            PsiElement element = provider.findElementAt(offset);
            if (element != null && namesValidator2.isIdentifier(element.getText(), this.project)) {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                this.addToTop(recentPlaces, string);
                PsiElement psiElement = this.findDeclaration(element);
                if (psiElement == null) {
                    return;
                }
                PsiElement declaration = psiElement;
                for (String childName : CollectionsKt.take((Iterable)this.getChildrenNames(declaration), (int)10)) {
                    this.addToTop(childrenRecentPlaces, childName);
                }
            }
        }

        public void recentPlaceRemoved(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
            Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getChildrenNames(PsiElement $this$getChildrenNames) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = $this$getChildrenNames.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"this.children");
            PsiElement[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiNamedElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiNamedElement it = (PsiNamedElement)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final PsiElement findDeclaration(PsiElement element) {
            PsiElement curElement = element;
            while (!(curElement instanceof PsiFile)) {
                if (curElement instanceof PsiNameIdentifierOwner) {
                    return curElement;
                }
                if (curElement.getParent() != null) continue;
                return null;
            }
            return null;
        }

        private final <T> void addToTop(Set<T> $this$addToTop, T value) {
            $this$addToTop.remove(value);
            $this$addToTop.add(value);
        }

        public StoreRecentPlacesListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        static {
            Companion = new Companion(null);
            recentPlaces = StoreRecentPlacesListener.Companion.createFixedSizeSet(20);
            childrenRecentPlaces = StoreRecentPlacesListener.Companion.createFixedSizeSet(100);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures$StoreRecentPlacesListener$Companion;", "", "()V", "MAX_CHILDREN_PER_PLACE", "", "childrenRecentPlaces", "", "", "recentPlaces", "createFixedSizeSet", "maxSize", "isInChildrenRecentPlaces", "", "value", "isInRecentPlaces", "intellij.completionMlRanking"})
        public static final class Companion {
            private final Set<String> createFixedSizeSet(int maxSize) {
                Set<String> set = Collections.newSetFromMap((Map)new LinkedHashMap<String, Boolean>(maxSize){
                    final /* synthetic */ int $maxSize;

                    protected boolean removeEldestEntry(@NotNull Map.Entry<String, Boolean> eldest) {
                        Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                        return this.size() > this.$maxSize;
                    }
                    {
                        this.$maxSize = $captured_local_variable$0;
                    }
                });
                Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMa\u2026ze\n          }\n        })");
                return set;
            }

            public final boolean isInRecentPlaces(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return recentPlaces.contains(value);
            }

            public final boolean isInChildrenRecentPlaces(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return childrenRecentPlaces.contains(value);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

