/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferWrapper;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class PagedFileStorageCache {
    private static final int UNKNOWN_PAGE = -1;
    private int myLastPage = -1;
    private int myLastPage2 = -1;
    private int myLastPage3 = -1;
    private ByteBufferWrapper myLastBuffer;
    private ByteBufferWrapper myLastBuffer2;
    private ByteBufferWrapper myLastBuffer3;
    private int myLastChangeCount;
    private int myLastChangeCount2;
    private int myLastChangeCount3;

    PagedFileStorageCache() {
    }

    synchronized void clear() {
        this.myLastPage = -1;
        this.myLastPage2 = -1;
        this.myLastPage3 = -1;
        this.myLastBuffer = null;
        this.myLastBuffer2 = null;
        this.myLastBuffer3 = null;
    }

    @Nullable
    synchronized ByteBufferWrapper getPageFromCache(long page, int mappingChangeCount, boolean readOnly) {
        ByteBuffer buf;
        if ((long)this.myLastPage == page) {
            ByteBuffer buf2 = this.myLastBuffer.getCachedBuffer();
            if (buf2 != null && this.myLastChangeCount == mappingChangeCount) {
                return this.myLastBuffer;
            }
        } else if ((long)this.myLastPage2 == page) {
            ByteBuffer buf3 = this.myLastBuffer2.getCachedBuffer();
            if (buf3 != null && this.myLastChangeCount2 == mappingChangeCount) {
                return this.myLastBuffer2;
            }
        } else if ((long)this.myLastPage3 == page && (buf = this.myLastBuffer3.getCachedBuffer()) != null && this.myLastChangeCount3 == mappingChangeCount) {
            return this.myLastBuffer3;
        }
        return null;
    }

    synchronized void updateCache(long page, ByteBufferWrapper byteBufferWrapper, int mappingChangeCount) {
        if ((long)this.myLastPage != page) {
            this.myLastPage3 = this.myLastPage2;
            this.myLastBuffer3 = this.myLastBuffer2;
            this.myLastChangeCount3 = this.myLastChangeCount2;
            this.myLastPage2 = this.myLastPage;
            this.myLastBuffer2 = this.myLastBuffer;
            this.myLastChangeCount2 = this.myLastChangeCount;
            this.myLastBuffer = byteBufferWrapper;
            this.myLastPage = (int)page;
        } else {
            this.myLastBuffer = byteBufferWrapper;
        }
        this.myLastChangeCount = mappingChangeCount;
    }
}

