/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerCertificateTypeExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerCertificateTypeExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerCertificateTypeExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCertificateTypeExtensionHandler
extends ExtensionHandler<ServerCertificateTypeExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerCertificateTypeExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ServerCertificateTypeExtensionParser getParser(byte[] message, int pointer) {
        return new ServerCertificateTypeExtensionParser(pointer, message);
    }

    public ServerCertificateTypeExtensionPreparator getPreparator(ServerCertificateTypeExtensionMessage message) {
        return new ServerCertificateTypeExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public ServerCertificateTypeExtensionSerializer getSerializer(ServerCertificateTypeExtensionMessage message) {
        return new ServerCertificateTypeExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(ServerCertificateTypeExtensionMessage message) {
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            if (((byte[])message.getCertificateTypes().getValue()).length != 1) {
                LOGGER.warn("Invalid ServerCertificateType extension. Not adjusting context");
            } else {
                this.context.setSelectedServerCertificateType(CertificateType.getCertificateType(((byte[])message.getCertificateTypes().getValue())[0]));
            }
        } else {
            this.context.setServerCertificateTypeDesiredTypes(CertificateType.getCertificateTypesAsList((byte[])message.getCertificateTypes().getValue()));
        }
    }
}

