/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class PostgresStoredProcedureSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof PostgresDatabase) {
            try {
                if (database.getDatabaseMajorVersion() > 10) {
                    return super.getPriority(clazz, database);
                }
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public PostgresStoredProcedureSnapshotGenerator() {
        super(StoredProcedure.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "PROCEDURE";
    }

    protected StoredDatabaseLogic<StoredProcedure> createReturnObject() {
        return new StoredProcedure();
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        return String.format("select  pp.proname AS OBJECT_NAME, pp.proargnames AS OBJECT_ARG, pl.lanname as TYPE,'VALID' as STATUS, pg_get_functiondef(pp.oid) AS OBJECT_BODY \nfrom pg_proc pp \ninner join pg_namespace pn on (pp.pronamespace = pn.oid) inner join pg_language pl on (pp.prolang = pl.oid) where pn.nspname NOT LIKE 'pg_%%'   and pn.nspname = '%s'   and pp.prokind = 'p' ", schema.getName());
    }

    @Override
    public String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database object) {
        object = this.getAddToSql(storedDatabaseLogic.getSchema(), (Database)object);
        return (String)object + " and pp.proname = '" + storedDatabaseLogic.getName() + "' ";
    }

    @Override
    public void addTo(DatabaseObject databaseObject, DatabaseSnapshot object) {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        databaseObject = (Schema)databaseObject;
        Database object22 = ((DatabaseSnapshot)((Object)object)).getDatabase();
        Executor executor = ExecutorService.getInstance().getExecutor("jdbc", object22);
        for (Map<String, ?> map : this.queryForList((DatabaseSnapshot)((Object)object), (Schema)databaseObject, executor)) {
            String string = (String)map.get("OBJECT_NAME");
            String string2 = (String)map.get("TYPE");
            String string3 = (String)map.get("OBJECT_BODY");
            Object t2 = ((StoredProcedure)this.createReturnObject().setSchema((Schema)databaseObject).setName(string)).setBody(string3);
            ((AbstractDatabaseObject)t2).setAttribute("TYPE".toLowerCase(), string2);
            ((Schema)databaseObject).addDatabaseObject((DatabaseObject)t2);
        }
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        return storedDatabaseLogic;
    }
}

