/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import java.sql.SQLException;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.database.ManagableObjects;
import org.traccar.database.SimpleObjectManager;
import org.traccar.helper.LogAction;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.ScheduledModel;
import org.traccar.model.User;

public abstract class BaseObjectResource<T extends BaseModel>
extends BaseResource {
    private final Class<T> baseClass;

    public BaseObjectResource(Class<T> baseClass) {
        this.baseClass = baseClass;
    }

    protected final Class<T> getBaseClass() {
        return this.baseClass;
    }

    protected final Set<Long> getSimpleManagerItems(BaseObjectManager<T> manager, boolean all, long userId) {
        Set<Long> result;
        if (all) {
            if (Context.getPermissionsManager().getUserAdmin(this.getUserId())) {
                result = manager.getAllItems();
            } else {
                Context.getPermissionsManager().checkManager(this.getUserId());
                result = ((ManagableObjects)((Object)manager)).getManagedItems(this.getUserId());
            }
        } else {
            if (userId == 0L) {
                userId = this.getUserId();
            }
            Context.getPermissionsManager().checkUser(this.getUserId(), userId);
            result = ((ManagableObjects)((Object)manager)).getUserItems(userId);
        }
        return result;
    }

    @Path(value="{id}")
    @GET
    public Response getSingle(@PathParam(value="id") long id) throws SQLException {
        Context.getPermissionsManager().checkPermission(this.baseClass, this.getUserId(), id);
        BaseObjectManager<T> manager = Context.getManager(this.baseClass);
        T entity = manager.getById(id);
        if (entity != null) {
            return Response.ok(entity).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response add(T entity) throws SQLException {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        if (this.baseClass.equals(Device.class)) {
            Context.getPermissionsManager().checkDeviceReadonly(this.getUserId());
            Context.getPermissionsManager().checkDeviceLimit(this.getUserId());
        } else if (this.baseClass.equals(Command.class)) {
            Context.getPermissionsManager().checkLimitCommands(this.getUserId());
        } else if (entity instanceof GroupedModel && ((GroupedModel)entity).getGroupId() != 0L) {
            Context.getPermissionsManager().checkPermission(Group.class, this.getUserId(), ((GroupedModel)entity).getGroupId());
        } else if (entity instanceof ScheduledModel && ((ScheduledModel)entity).getCalendarId() != 0L) {
            Context.getPermissionsManager().checkPermission(Calendar.class, this.getUserId(), ((ScheduledModel)entity).getCalendarId());
        }
        BaseObjectManager<T> manager = Context.getManager(this.baseClass);
        manager.addItem(entity);
        LogAction.create(this.getUserId(), entity);
        Context.getDataManager().linkObject(User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId(), true);
        LogAction.link(this.getUserId(), User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId());
        if (manager instanceof SimpleObjectManager) {
            ((SimpleObjectManager)manager).refreshUserItems();
        } else if (this.baseClass.equals(Group.class) || this.baseClass.equals(Device.class)) {
            Context.getPermissionsManager().refreshDeviceAndGroupPermissions();
            Context.getPermissionsManager().refreshAllExtendedPermissions();
        }
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @PUT
    public Response update(T entity) throws SQLException {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        if (this.baseClass.equals(Device.class)) {
            Context.getPermissionsManager().checkDeviceReadonly(this.getUserId());
        } else if (this.baseClass.equals(User.class)) {
            User before = Context.getPermissionsManager().getUser(((BaseModel)entity).getId());
            Context.getPermissionsManager().checkUserUpdate(this.getUserId(), before, (User)entity);
        } else if (this.baseClass.equals(Command.class)) {
            Context.getPermissionsManager().checkLimitCommands(this.getUserId());
        } else if (entity instanceof GroupedModel && ((GroupedModel)entity).getGroupId() != 0L) {
            Context.getPermissionsManager().checkPermission(Group.class, this.getUserId(), ((GroupedModel)entity).getGroupId());
        } else if (entity instanceof ScheduledModel && ((ScheduledModel)entity).getCalendarId() != 0L) {
            Context.getPermissionsManager().checkPermission(Calendar.class, this.getUserId(), ((ScheduledModel)entity).getCalendarId());
        }
        Context.getPermissionsManager().checkPermission(this.baseClass, this.getUserId(), ((BaseModel)entity).getId());
        Context.getManager(this.baseClass).updateItem(entity);
        LogAction.edit(this.getUserId(), entity);
        if (this.baseClass.equals(Group.class) || this.baseClass.equals(Device.class)) {
            Context.getPermissionsManager().refreshDeviceAndGroupPermissions();
            Context.getPermissionsManager().refreshAllExtendedPermissions();
        }
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws SQLException {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        if (this.baseClass.equals(Device.class)) {
            Context.getPermissionsManager().checkDeviceReadonly(this.getUserId());
        } else if (this.baseClass.equals(Command.class)) {
            Context.getPermissionsManager().checkLimitCommands(this.getUserId());
        }
        Context.getPermissionsManager().checkPermission(this.baseClass, this.getUserId(), id);
        BaseObjectManager<T> manager = Context.getManager(this.baseClass);
        manager.removeItem(id);
        LogAction.remove(this.getUserId(), this.baseClass, id);
        if (manager instanceof SimpleObjectManager) {
            ((SimpleObjectManager)manager).refreshUserItems();
            if (manager instanceof ExtendedObjectManager) {
                ((ExtendedObjectManager)manager).refreshExtendedPermissions();
            }
        }
        if (this.baseClass.equals(Group.class) || this.baseClass.equals(Device.class) || this.baseClass.equals(User.class)) {
            if (this.baseClass.equals(Group.class)) {
                Context.getGroupsManager().refreshItems();
                Context.getDeviceManager().updateDeviceCache(true);
            }
            Context.getPermissionsManager().refreshDeviceAndGroupPermissions();
            if (this.baseClass.equals(User.class)) {
                Context.getPermissionsManager().refreshAllUsersPermissions();
            } else {
                Context.getPermissionsManager().refreshAllExtendedPermissions();
            }
        } else if (this.baseClass.equals(Calendar.class)) {
            Context.getGeofenceManager().refreshItems();
            Context.getNotificationManager().refreshItems();
        }
        return Response.noContent().build();
    }
}

