/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class FifotrackProtocolEncoder
extends StringProtocolEncoder {
    public FifotrackProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private Object formatCommand(Command command, String content) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        int length = 1 + uniqueId.length() + 3 + content.length();
        String result = String.format("##%02d,%s,1,%s*", length, uniqueId, content);
        result = result + Checksum.sum(result) + "\r\n";
        return result;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, command.getString("data"));
            }
            case "requestPhoto": {
                return this.formatCommand(command, "D05,3");
            }
        }
        return null;
    }
}

