/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class KhdProtocolEncoder
extends BaseProtocolEncoder {
    public static final int MSG_CUT_OIL = 57;
    public static final int MSG_RESUME_OIL = 56;

    public KhdProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeCommand(int command, String uniqueId) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(41);
        buf.writeByte(41);
        buf.writeByte(command);
        buf.writeShort(6);
        uniqueId = "00000000".concat(uniqueId);
        uniqueId = uniqueId.substring(uniqueId.length() - 8);
        buf.writeByte(Integer.parseInt(uniqueId.substring(0, 2)));
        buf.writeByte(Integer.parseInt(uniqueId.substring(2, 4)) + 128);
        buf.writeByte(Integer.parseInt(uniqueId.substring(4, 6)) + 128);
        buf.writeByte(Integer.parseInt(uniqueId.substring(6, 8)));
        buf.writeByte(Checksum.xor(buf.nioBuffer()));
        buf.writeByte(13);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        switch (command.getType()) {
            case "engineStop": {
                return this.encodeCommand(57, uniqueId);
            }
            case "engineResume": {
                return this.encodeCommand(56, uniqueId);
            }
        }
        return null;
    }
}

