# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class AuthenticationManagement(VapiStruct):
    """
    ``AuthenticationManagement`` class This structure contains the Spec
    required for Authentication Management configurations.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 privileges_list=None,
                 global_permission_list=None,
                 role_list=None,
                 password_policy=None,
                 token_policy=None,
                 lockout_policy=None,
                ):
        """
        :type  privileges_list: :class:`list` of :class:`Privileges`
        :param privileges_list: List of Privileges.
        :type  global_permission_list: :class:`list` of :class:`GlobalPermission`
        :param global_permission_list: List of Global Permission.
        :type  role_list: :class:`list` of :class:`Roles`
        :param role_list: List of Roles.
        :type  password_policy: :class:`PasswordPolicy` or ``None``
        :param password_policy: Password Policy.
        :type  token_policy: :class:`TokenPolicy` or ``None``
        :param token_policy: Token Policy.
        :type  lockout_policy: :class:`LockoutPolicy` or ``None``
        :param lockout_policy: Lockout Policy.
        """
        self.privileges_list = privileges_list
        self.global_permission_list = global_permission_list
        self.role_list = role_list
        self.password_policy = password_policy
        self.token_policy = token_policy
        self.lockout_policy = lockout_policy
        VapiStruct.__init__(self)


AuthenticationManagement._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.authentication_management', {
        'privileges_list': type.ListType(type.ReferenceType(__name__, 'Privileges')),
        'global_permission_list': type.ListType(type.ReferenceType(__name__, 'GlobalPermission')),
        'role_list': type.ListType(type.ReferenceType(__name__, 'Roles')),
        'password_policy': type.OptionalType(type.ReferenceType(__name__, 'PasswordPolicy')),
        'token_policy': type.OptionalType(type.ReferenceType(__name__, 'TokenPolicy')),
        'lockout_policy': type.OptionalType(type.ReferenceType(__name__, 'LockoutPolicy')),
    },
    AuthenticationManagement,
    False,
    None))



class LockoutPolicy(VapiStruct):
    """
    ``LockoutPolicy`` class This structure represents the configuration in
    Lockout Policy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 failed_login_attempts=None,
                 failure_interval=None,
                 unlock_time=None,
                ):
        """
        :type  failed_login_attempts: :class:`long`
        :param failed_login_attempts: Maximum number of failed login attempts.
        :type  failure_interval: :class:`long`
        :param failure_interval: Time interval between failures.
        :type  unlock_time: :class:`long`
        :param unlock_time: Unlock time.
        """
        self.failed_login_attempts = failed_login_attempts
        self.failure_interval = failure_interval
        self.unlock_time = unlock_time
        VapiStruct.__init__(self)


LockoutPolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.lockout_policy', {
        'failed_login_attempts': type.IntegerType(),
        'failure_interval': type.IntegerType(),
        'unlock_time': type.IntegerType(),
    },
    LockoutPolicy,
    False,
    None))



class PasswordPolicy(VapiStruct):
    """
    ``PasswordPolicy`` class This structure represents the configuration in
    Password Policy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 special_chars=None,
                 alpha_chars=None,
                 uppercase_chars=None,
                 lowercase_chars=None,
                 numeric_chars=None,
                 adj_identical_chars=None,
                 password_reuse=None,
                 max_life=None,
                 max_length=None,
                 min_length=None,
                ):
        """
        :type  special_chars: :class:`long`
        :param special_chars: Minimum special characters.
        :type  alpha_chars: :class:`long`
        :param alpha_chars: Minimum alphabetic characters.
        :type  uppercase_chars: :class:`long`
        :param uppercase_chars: Minimum uppercase characters.
        :type  lowercase_chars: :class:`long`
        :param lowercase_chars: Minimum lowercase characters.
        :type  numeric_chars: :class:`long`
        :param numeric_chars: Minimum numeric characters.
        :type  adj_identical_chars: :class:`long`
        :param adj_identical_chars: Maximum adjacent identical characters.
        :type  password_reuse: :class:`long`
        :param password_reuse: Previous password reuse restriction.
        :type  max_life: :class:`long`
        :param max_life: Maximum lifetime.
        :type  max_length: :class:`long`
        :param max_length: Maximum length.
        :type  min_length: :class:`long`
        :param min_length: Minimum length.
        """
        self.special_chars = special_chars
        self.alpha_chars = alpha_chars
        self.uppercase_chars = uppercase_chars
        self.lowercase_chars = lowercase_chars
        self.numeric_chars = numeric_chars
        self.adj_identical_chars = adj_identical_chars
        self.password_reuse = password_reuse
        self.max_life = max_life
        self.max_length = max_length
        self.min_length = min_length
        VapiStruct.__init__(self)


PasswordPolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.password_policy', {
        'special_chars': type.IntegerType(),
        'alpha_chars': type.IntegerType(),
        'uppercase_chars': type.IntegerType(),
        'lowercase_chars': type.IntegerType(),
        'numeric_chars': type.IntegerType(),
        'adj_identical_chars': type.IntegerType(),
        'password_reuse': type.IntegerType(),
        'max_life': type.IntegerType(),
        'max_length': type.IntegerType(),
        'min_length': type.IntegerType(),
    },
    PasswordPolicy,
    False,
    None))



class TokenPolicy(VapiStruct):
    """
    ``TokenPolicy`` class This structure represents the configuration in Token
    Policy.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 clock_tolerance=None,
                 token_renewal=None,
                 token_delegation=None,
                 bearer_refresh=None,
                 hok_refresh=None,
                ):
        """
        :type  clock_tolerance: :class:`long`
        :param clock_tolerance: Clock tolerance ms.
        :type  token_renewal: :class:`long`
        :param token_renewal: Maximum token renewal count.
        :type  token_delegation: :class:`long`
        :param token_delegation: Maximum token delegation count.
        :type  bearer_refresh: :class:`long`
        :param bearer_refresh: Maximum Bearer RefreshToken lifetime.
        :type  hok_refresh: :class:`long`
        :param hok_refresh: Maximum HoK RefreshToken lifetime.
        """
        self.clock_tolerance = clock_tolerance
        self.token_renewal = token_renewal
        self.token_delegation = token_delegation
        self.bearer_refresh = bearer_refresh
        self.hok_refresh = hok_refresh
        VapiStruct.__init__(self)


TokenPolicy._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.token_policy', {
        'clock_tolerance': type.IntegerType(),
        'token_renewal': type.IntegerType(),
        'token_delegation': type.IntegerType(),
        'bearer_refresh': type.IntegerType(),
        'hok_refresh': type.IntegerType(),
    },
    TokenPolicy,
    False,
    None))



class Privileges(VapiStruct):
    """
    ``Privileges`` class This structure represents the configuration for
    Privileges.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 id=None,
                 description=None,
                 group=None,
                 is_on_parent=None,
                ):
        """
        :type  id: :class:`str`
        :param id: Privilege identifier.
        :type  description: :class:`str`
        :param description: Privilege description.
        :type  group: :class:`str`
        :param group: Group to which the privilege belongs to.
        :type  is_on_parent: :class:`bool`
        :param is_on_parent: Is on parent.
        """
        self.id = id
        self.description = description
        self.group = group
        self.is_on_parent = is_on_parent
        VapiStruct.__init__(self)


Privileges._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.privileges', {
        'id': type.StringType(),
        'description': type.StringType(),
        'group': type.StringType(),
        'is_on_parent': type.BooleanType(),
    },
    Privileges,
    False,
    None))



class Roles(VapiStruct):
    """
    ``Roles`` class This structure represents the configuration for Roles.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 id=None,
                 name=None,
                 description=None,
                 privilege_id=None,
                ):
        """
        :type  id: :class:`long`
        :param id: Role identifier.
        :type  name: :class:`str`
        :param name: Role name.
        :type  description: :class:`str`
        :param description: Role description.
        :type  privilege_id: :class:`list` of :class:`str`
        :param privilege_id: List of Privileges present in the Role.
        """
        self.id = id
        self.name = name
        self.description = description
        self.privilege_id = privilege_id
        VapiStruct.__init__(self)


Roles._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.roles', {
        'id': type.IntegerType(),
        'name': type.StringType(),
        'description': type.StringType(),
        'privilege_id': type.ListType(type.StringType()),
    },
    Roles,
    False,
    None))



class GlobalPermission(VapiStruct):
    """
    ``GlobalPermissions`` class This structure represents the configuration for
    Global Permissions

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 principal=None,
                 role_ids=None,
                 propagate=None,
                ):
        """
        :type  principal: :class:`Principal`
        :param principal: Role identifier.
        :type  role_ids: :class:`list` of :class:`long`
        :param role_ids: Role Ids assigned to this Principal
        :type  propagate: :class:`bool`
        :param propagate: Propagating to child objects.
        """
        self.principal = principal
        self.role_ids = role_ids
        self.propagate = propagate
        VapiStruct.__init__(self)


GlobalPermission._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.global_permission', {
        'principal': type.ReferenceType(__name__, 'Principal'),
        'role_ids': type.ListType(type.IntegerType()),
        'propagate': type.BooleanType(),
    },
    GlobalPermission,
    False,
    None))



class Principal(VapiStruct):
    """
    ``Principal`` class This structure represents the configuration for
    Principal

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 name=None,
                 group=None,
                ):
        """
        :type  name: :class:`str`
        :param name: Principal name.
        :type  group: :class:`bool`
        :param group: Is a Group
        """
        self.name = name
        self.group = group
        VapiStruct.__init__(self)


Principal._set_binding_type(type.StructType(
    'com.vmware.appliance.vcenter.settings.v1.config.components.authmanagement.principal', {
        'name': type.StringType(),
        'group': type.BooleanType(),
    },
    Principal,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

