/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StringUtils {
    public static String join(String delimiter, String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            result.append(delimiter);
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String join(String delimiter, List<String> strings) {
        return StringUtils.join(delimiter, strings.toArray(new String[0]));
    }

    public static String chop(String str, int maxLength) {
        return str.length() > maxLength ? str.substring(0, maxLength) : str;
    }

    public static String lastPart(String s, String delim) {
        int last = s == null ? -1 : s.lastIndexOf(delim);
        return last > 0 ? s.substring(last + delim.length(), s.length()) : s;
    }

    public static String getEnumKey(Enum<?> value) {
        String base = value.toString().toLowerCase(Locale.US);
        int len = base.length();
        StringBuilder sb = new StringBuilder(len);
        int from = 0;
        while (true) {
            int idx;
            if ((idx = base.indexOf(95, from)) < 0) {
                sb.append(base.substring(from));
                break;
            }
            sb.append(base.substring(from, idx));
            from = idx + 1;
            if (from >= len) break;
            char ch = base.charAt(from);
            if (!Character.isLetter(ch)) continue;
            sb.append(Character.toUpperCase(ch));
            ++from;
        }
        return sb.toString();
    }

    public static int getBreakingPoint(String string) {
        return StringUtils.getBreakingPoint(string, " ");
    }

    public static int getBreakingPoint(String string, String delim) {
        int center = string.length() / 2;
        for (int offset = 0; offset < center; ++offset) {
            if (delim.indexOf(string.charAt(center + offset)) >= 0) {
                return center + offset;
            }
            if (delim.indexOf(string.charAt(center - offset)) < 0) continue;
            return center - offset;
        }
        return -1;
    }

    public static List<String> splitText(String text, String delim, FontMetrics fontMetrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        int len = text.length();
        int i = 0;
        String top = "";
        Character d = null;
        while (true) {
            String t;
            if (i < len && delim.indexOf(text.charAt(i)) >= 0) {
                ++i;
                continue;
            }
            if (i >= len) break;
            int start = i;
            while (i < len && delim.indexOf(text.charAt(i)) < 0) {
                ++i;
            }
            String s = text.substring(start, i);
            String string = t = top.isEmpty() ? s : top + d + s;
            if (fontMetrics.stringWidth(t) > width) {
                if (top.isEmpty()) {
                    result.add(s);
                } else {
                    result.add(top);
                    top = s;
                }
            } else {
                top = t;
            }
            if (i >= len) {
                if (top.isEmpty()) break;
                result.add(top);
                break;
            }
            d = Character.valueOf(text.charAt(i));
        }
        return result;
    }
}

