"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../../utils/specs");
var utils_1 = require("../utils");
var dimensions_1 = require("./dimensions");
function computeRectAnnotationTooltipState(cursorPosition, annotationRects, chartRotation, chartDimensions) {
    var rotatedProjectedCursorPosition = utils_1.getTransformedCursor(cursorPosition, chartDimensions, chartRotation, true);
    var totalAnnotationRect = annotationRects.length;
    for (var i = 0; i < totalAnnotationRect; i++) {
        var rectProps = annotationRects[i];
        var rect = rectProps.rect, details = rectProps.details;
        var startX = rect.x;
        var endX = startX + rect.width;
        var startY = rect.y;
        var endY = startY + rect.height;
        var bounds = { startX: startX, endX: endX, startY: startY, endY: endY };
        var isWithinBounds = dimensions_1.isWithinRectBounds(rotatedProjectedCursorPosition, bounds);
        if (isWithinBounds) {
            return __assign({ isVisible: true, annotationType: specs_1.AnnotationTypes.Rectangle, anchor: {
                    left: cursorPosition.x,
                    top: cursorPosition.y,
                } }, (details && { details: details }));
        }
    }
    return null;
}
exports.computeRectAnnotationTooltipState = computeRectAnnotationTooltipState;
//# sourceMappingURL=tooltip.js.map