"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplicationUsage = void 0;

var _momentTimezone = _interopRequireDefault(require("moment-timezone"));

var _ = require("./");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ApplicationUsage {
  constructor() {
    _defineProperty(this, "currentUsage", void 0);
  }

  start() {
    // Count any clicks and assign it to the current app
    if (window) window.addEventListener('click', () => this.currentUsage && this.currentUsage.numberOfClicks++);
  }

  appChanged(appId) {
    const currentUsage = this.currentUsage;

    if (appId) {
      this.currentUsage = {
        type: _.METRIC_TYPE.APPLICATION_USAGE,
        appId,
        startTime: (0, _momentTimezone.default)(),
        numberOfClicks: 0
      };
    } else {
      this.currentUsage = void 0;
    }

    return currentUsage;
  }

}

exports.ApplicationUsage = ApplicationUsage;