/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class LogFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "LOG";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        Number result = context.getTypeRegistry().convertToNumber(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        double d = result.doubleValue();
        if (d <= 0.0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        double n = 10.0;
        if (parameterCount == 2) {
            Type type2 = parameters.getType(1);
            Object value2 = parameters.getValue(1);
            Number result2 = context.getTypeRegistry().convertToNumber(type2, value2);
            if (result2 == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            n = result2.doubleValue();
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(Math.log(d) / Math.log(n)));
    }
}

