/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public final class TestRuleMarkFailure
implements TestRule {
    private final TestRuleMarkFailure[] chained;
    private volatile boolean failures;

    public TestRuleMarkFailure(TestRuleMarkFailure ... chained) {
        this.chained = chained;
    }

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestRuleMarkFailure.this.failures = false;
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    if (!TestRuleMarkFailure.isAssumption(t)) {
                        TestRuleMarkFailure.this.markFailed();
                    }
                    throw t;
                }
            }
        };
    }

    public static boolean isAssumption(Throwable t) {
        for (Throwable t2 : TestRuleMarkFailure.expandFromMultiple(t)) {
            if (t2 instanceof AssumptionViolatedException) continue;
            return false;
        }
        return true;
    }

    private static List<Throwable> expandFromMultiple(Throwable t) {
        return TestRuleMarkFailure.expandFromMultiple(t, new ArrayList<Throwable>());
    }

    private static List<Throwable> expandFromMultiple(Throwable t, List<Throwable> list) {
        if (t instanceof MultipleFailureException) {
            for (Throwable sub : ((MultipleFailureException)t).getFailures()) {
                TestRuleMarkFailure.expandFromMultiple(sub, list);
            }
        } else {
            list.add(t);
        }
        return list;
    }

    public void markFailed() {
        this.failures = true;
        for (TestRuleMarkFailure next : this.chained) {
            next.markFailed();
        }
    }

    public boolean hadFailures() {
        return this.failures;
    }

    public boolean wasSuccessful() {
        return !this.hadFailures();
    }
}

