/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.AppendableWriter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public final class CharStreams {
    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    @CanIgnoreReturnValue
    public static long copy(Readable readable, Appendable appendable) {
        if (readable instanceof Reader) {
            if (appendable instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)readable, (StringBuilder)appendable);
            }
            return CharStreams.copyReaderToWriter((Reader)readable, CharStreams.asWriter(appendable));
        }
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(appendable);
        long l = 0L;
        CharBuffer charBuffer = CharStreams.createBuffer();
        while (readable.read(charBuffer) != -1) {
            charBuffer.flip();
            appendable.append(charBuffer);
            l += (long)charBuffer.remaining();
            charBuffer.clear();
        }
        return l;
    }

    @CanIgnoreReturnValue
    static long copyReaderToBuilder(Reader reader, StringBuilder stringBuilder) {
        int n;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(stringBuilder);
        char[] cArray = new char[2048];
        long l = 0L;
        while ((n = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @CanIgnoreReturnValue
    static long copyReaderToWriter(Reader reader, Writer writer) {
        int n;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(writer);
        char[] cArray = new char[2048];
        long l = 0L;
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static String toString(Readable readable) {
        return CharStreams.toStringBuilder(readable).toString();
    }

    private static StringBuilder toStringBuilder(Readable readable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (readable instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)readable, stringBuilder);
        } else {
            CharStreams.copy(readable, stringBuilder);
        }
        return stringBuilder;
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

