/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.Utilities;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.filters.ActionsFilter;

public class ReviewActionsFilters {
    private static final int LABEL_HEIGHT = 12;
    private final ActionsScreen screen;
    private MatcherEditor matcherEditor;
    private JPanel component;

    public ReviewActionsFilters(ActionsScreen screen) {
        this.screen = screen;
    }

    public MatcherEditor getMatcherEditor() {
        if (this.matcherEditor == null) {
            BasicEventList list = new BasicEventList();
            for (ActionsFilter m : this.screen.getFilters()) {
                list.add((Object)m);
            }
            this.matcherEditor = new CompositeMatcherEditor((EventList)list);
        }
        return this.matcherEditor;
    }

    public int getComponentWidth() {
        return 140;
    }

    public int getComponentHeight() {
        int margin = Utilities.isMac() ? 2 : 6;
        return 35 + margin;
    }

    public JPanel getPanel() {
        if (this.component == null) {
            this.component = new JPanel(new FlowLayout(0, 1, 1));
            for (ActionsFilter m : this.screen.getFilters()) {
                if (!m.isUsed() || !m.isShown()) continue;
                JPanel panel = new JPanel(new FlowLayout(0, 1, 0));
                Dimension d = new Dimension(this.getComponentWidth(), this.getComponentHeight());
                panel.setPreferredSize(d);
                panel.setMinimumSize(d);
                panel.setMaximumSize(d);
                panel.add(new JLabel("   " + m.getLabel()));
                panel.add(m.getFilterCombo().getJComboBox());
                this.component.add(panel);
            }
        }
        return this.component;
    }

    public JPanel getPanel(boolean rebuild) {
        if (rebuild) {
            this.component = null;
        }
        return this.getPanel();
    }
}

