(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/19#time-tai 'time-tai)
  (define std/srfi/19#time-utc 'time-utc)
  (define std/srfi/19#time-monotonic 'time-monotonic)
  (define std/srfi/19#time-thread 'time-thread)
  (define std/srfi/19#time-process 'time-process)
  (define std/srfi/19#time-duration 'time-duration)
  (define std/srfi/19#tm:locale-number-separator '".")
  (define std/srfi/19#tm:locale-abbr-weekday-vector
    (vector '"Sun" '"Mon" '"Tue" '"Wed" '"Thu" '"Fri" '"Sat"))
  (define std/srfi/19#tm:locale-long-weekday-vector
    (vector '"Sunday"
            '"Monday"
            '"Tuesday"
            '"Wednesday"
            '"Thursday"
            '"Friday"
            '"Saturday"))
  (define std/srfi/19#tm:locale-abbr-month-vector
    (vector '""
            '"Jan"
            '"Feb"
            '"Mar"
            '"Apr"
            '"May"
            '"Jun"
            '"Jul"
            '"Aug"
            '"Sep"
            '"Oct"
            '"Nov"
            '"Dec"))
  (define std/srfi/19#tm:locale-long-month-vector
    (vector '""
            '"January"
            '"February"
            '"March"
            '"April"
            '"May"
            '"June"
            '"July"
            '"August"
            '"September"
            '"October"
            '"November"
            '"December"))
  (define std/srfi/19#tm:locale-pm '"PM")
  (define std/srfi/19#tm:locale-am '"AM")
  (define std/srfi/19#tm:locale-date-time-format '"~a ~b ~d ~H:~M:~S~z ~Y")
  (define std/srfi/19#tm:locale-short-date-format '"~m/~d/~y")
  (define std/srfi/19#tm:locale-time-format '"~H:~M:~S")
  (define std/srfi/19#tm:iso-8601-date-time-format '"~Y-~m-~dT~H:~M:~S~z")
  (define std/srfi/19#tm:nano (expt '10 '9))
  (define std/srfi/19#tm:sid '86400)
  (define std/srfi/19#tm:sihd '43200)
  (define std/srfi/19#tm:tai-epoch-in-jd '4881175/2)
  (define std/srfi/19#tm:time-error-types
    '(invalid-clock-type
      unsupported-clock-type
      incompatible-time-types
      not-duration
      dates-are-immutable
      bad-date-format-string
      bad-date-template-string
      invalid-month-specification))
  (define std/srfi/19#tm:time-error
    (lambda (_caller1321_ _type1322_ _value1323_)
      (if (member _type1322_ std/srfi/19#tm:time-error-types)
          (if _value1323_
              (error '"TIME-ERROR type" _caller1321_ _type1322_ _value1323_)
              (error '"TIME-ERROR type" _caller1321_ _type1322_))
          (error '"TIME-ERROR unsupported error type"
                 _caller1321_
                 _type1322_))))
  (define std/srfi/19#tm:read-tai-utc-data
    (lambda (_filename1296_)
      (letrec ((_convert-jd1298_
                (lambda (_jd1319_)
                  (* (- (inexact->exact _jd1319_)
                        std/srfi/19#tm:tai-epoch-in-jd)
                     std/srfi/19#tm:sid)))
               (_convert-sec1299_
                (lambda (_sec1317_) (inexact->exact _sec1317_))))
        (let ((_port1301_ (open-input-file _filename1296_)) (_table1302_ '()))
          (let _loop1304_ ((_line1306_ (read-line _port1301_)))
            (if (not (eof-object? _line1306_))
                (let* ((_data1308_
                        (read (open-input-string
                               (string-append '"(" _line1306_ '")"))))
                       (_year1310_ (car _data1308_))
                       (_jd1312_ (cadddr (cdr _data1308_)))
                       (_secs1314_ (cadddr (cdddr _data1308_))))
                  (if (>= _year1310_ '1972)
                      (set! _table1302_
                            (cons (cons (_convert-jd1298_ _jd1312_)
                                        (inexact->exact _secs1314_))
                                  _table1302_))
                      '#!void)
                  (_loop1304_ (read-line _port1301_)))
                '#!void))
          _table1302_))))
  (define std/srfi/19#tm:leap-second-table
    '((1483228800 . 37)
      (1435708800 . 36)
      (1341100800 . 35)
      (1230768000 . 34)
      (1136073600 . 33)
      (915148800 . 32)
      (867715200 . 31)
      (820454400 . 30)
      (773020800 . 29)
      (741484800 . 28)
      (709948800 . 27)
      (662688000 . 26)
      (631152000 . 25)
      (567993600 . 24)
      (489024000 . 23)
      (425865600 . 22)
      (394329600 . 21)
      (362793600 . 20)
      (315532800 . 19)
      (283996800 . 18)
      (252460800 . 17)
      (220924800 . 16)
      (189302400 . 15)
      (157766400 . 14)
      (126230400 . 13)
      (94694400 . 12)
      (78796800 . 11)
      (63072000 . 10)))
  (define std/srfi/19#read-leap-second-table
    (lambda (_filename1294_)
      (set! std/srfi/19#tm:leap-second-table
            (std/srfi/19#tm:read-tai-utc-data _filename1294_))
      '#!void))
  (define std/srfi/19#tm:leap-second-delta
    (lambda (_utc-seconds1288_)
      (letrec ((_lsd1290_
                (lambda (_table1292_)
                  (if (>= _utc-seconds1288_ (caar _table1292_))
                      (cdar _table1292_)
                      (_lsd1290_ (cdr _table1292_))))))
        (if (< _utc-seconds1288_ (* (- '1972 '1970) '365 std/srfi/19#tm:sid))
            '0
            (_lsd1290_ std/srfi/19#tm:leap-second-table)))))
  (define std/srfi/19#tm:leap-second-neg-delta
    (lambda (_tai-seconds1282_)
      (letrec ((_lsd1284_
                (lambda (_table1286_)
                  (if (null? _table1286_)
                      '0
                      (if (<= (cdar _table1286_)
                              (- _tai-seconds1282_ (caar _table1286_)))
                          (cdar _table1286_)
                          (_lsd1284_ (cdr _table1286_)))))))
        (if (< _tai-seconds1282_ (* (- '1972 '1970) '365 std/srfi/19#tm:sid))
            '0
            (_lsd1284_ std/srfi/19#tm:leap-second-table)))))
  (define std/srfi/19#time::t
    (make-struct-type
     'std/srfi/19#time::t
     '#f
     '3
     'time
     '((transparent: . #t))
     '#f
     '(type nanosecond second)))
  (define std/srfi/19#time? (make-struct-predicate std/srfi/19#time::t))
  (define std/srfi/19#make-time
    (lambda _$args1279_
      (apply make-struct-instance std/srfi/19#time::t _$args1279_)))
  (define std/srfi/19#time-type
    (make-struct-field-accessor std/srfi/19#time::t '0))
  (define std/srfi/19#time-nanosecond
    (make-struct-field-accessor std/srfi/19#time::t '1))
  (define std/srfi/19#time-second
    (make-struct-field-accessor std/srfi/19#time::t '2))
  (define std/srfi/19#time-type-set!
    (make-struct-field-mutator std/srfi/19#time::t '0))
  (define std/srfi/19#time-nanosecond-set!
    (make-struct-field-mutator std/srfi/19#time::t '1))
  (define std/srfi/19#time-second-set!
    (make-struct-field-mutator std/srfi/19#time::t '2))
  (define std/srfi/19#make-time%
    (lambda (_type1257_ _nanosecond1258_ _second1259_)
      (let ((_$e1261_ _type1257_))
        (if (or (eq? 'time-tai _$e1261_)
                (eq? 'time-utc _$e1261_)
                (eq? 'time-monotonic _$e1261_)
                (eq? 'time-thread _$e1261_)
                (eq? 'time-process _$e1261_)
                (eq? 'time-duration _$e1261_))
            '#t
            (error '"Wrong time type" _type1257_)))
      (if (exact-integer? _second1259_)
          '#!void
          (error '"Invalid time second" _second1259_))
      (if (and (exact-integer? _nanosecond1258_)
               (<= (if (eq? _type1257_ std/srfi/19#time-duration)
                       '-999999999
                       '0)
                   _nanosecond1258_
                   '999999999))
          '#!void
          (error '"Invalid time nanosecond" _nanosecond1258_))
      (let ()
        (declare (not safe))
        (##structure
         std/srfi/19#time::t
         _type1257_
         _nanosecond1258_
         _second1259_))))
  (define std/srfi/19#copy-time
    (lambda (_time1255_)
      (let ((__tmp4925 (##structure-ref _time1255_ '1 std/srfi/19#time::t '#f))
            (__tmp4924 (##structure-ref _time1255_ '2 std/srfi/19#time::t '#f))
            (__tmp4923
             (##structure-ref _time1255_ '3 std/srfi/19#time::t '#f)))
        (declare (not safe))
        (##structure std/srfi/19#time::t __tmp4925 __tmp4924 __tmp4923))))
  (define std/srfi/19#current-seconds
    (lambda ()
      (inexact->exact
       (floor (let () (declare (not safe)) (##current-time-point))))))
  (define std/srfi/19#current-milliseconds
    (lambda ()
      (inexact->exact
       (floor (fl* '1000.
                   (let () (declare (not safe)) (##current-time-point)))))))
  (define std/srfi/19#tm:get-time-of-day
    (lambda ()
      (let* ((_now1248_ (let () (declare (not safe)) (##current-time-point)))
             (_sec1250_ (floor _now1248_)))
        (values (inexact->exact _sec1250_)
                (inexact->exact
                 (floor (fl* (fl- _now1248_ _sec1250_) '1000000000.)))))))
  (define std/srfi/19#tm:current-time-utc
    (lambda ()
      (let ((_g4926_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g4927_ (let ()
                           (declare (not safe))
                           (if (##values? _g4926_)
                               (##vector-length _g4926_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4927_ 2)))
                (error "Context expects 2 values" _g4927_)))
          (let ((_seconds1244_
                 (let () (declare (not safe)) (##vector-ref _g4926_ 0)))
                (_ns1245_
                 (let () (declare (not safe)) (##vector-ref _g4926_ 1))))
            (let ()
              (declare (not safe))
              (##structure
               std/srfi/19#time::t
               std/srfi/19#time-utc
               _ns1245_
               _seconds1244_)))))))
  (define std/srfi/19#tm:current-time-tai
    (lambda ()
      (let ((_g4928_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g4929_ (let ()
                           (declare (not safe))
                           (if (##values? _g4928_)
                               (##vector-length _g4928_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4929_ 2)))
                (error "Context expects 2 values" _g4929_)))
          (let ((_seconds1240_
                 (let () (declare (not safe)) (##vector-ref _g4928_ 0)))
                (_ns1241_
                 (let () (declare (not safe)) (##vector-ref _g4928_ 1))))
            (let ((__tmp4930
                   (+ _seconds1240_
                      (std/srfi/19#tm:leap-second-delta _seconds1240_))))
              (declare (not safe))
              (##structure
               std/srfi/19#time::t
               std/srfi/19#time-tai
               _ns1241_
               __tmp4930)))))))
  (define std/srfi/19#tm:current-time-monotonic
    (lambda ()
      (let ((_g4931_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g4932_ (let ()
                           (declare (not safe))
                           (if (##values? _g4931_)
                               (##vector-length _g4931_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4932_ 2)))
                (error "Context expects 2 values" _g4932_)))
          (let ((_seconds1236_
                 (let () (declare (not safe)) (##vector-ref _g4931_ 0)))
                (_ns1237_
                 (let () (declare (not safe)) (##vector-ref _g4931_ 1))))
            (let ((__tmp4933
                   (+ _seconds1236_
                      (std/srfi/19#tm:leap-second-delta _seconds1236_))))
              (declare (not safe))
              (##structure
               std/srfi/19#time::t
               std/srfi/19#time-monotonic
               _ns1237_
               __tmp4933)))))))
  (define std/srfi/19#tm:current-time-thread
    (lambda () (error '"Unimplemented")))
  (define std/srfi/19#tm:current-time-process
    (lambda () (error '"Unimplemented")))
  (define std/srfi/19#current-time
    (lambda _clock-type1226_
      (let ((_clock-type1231_
             (let ((_maybe-arg1228_ _clock-type1226_))
               (if (null? _maybe-arg1228_)
                   std/srfi/19#time-utc
                   (if (null? (cdr _maybe-arg1228_))
                       (car _maybe-arg1228_)
                       (error '"too many optional arguments"
                              _maybe-arg1228_))))))
        (if (eq? _clock-type1231_ std/srfi/19#time-tai)
            (std/srfi/19#tm:current-time-tai)
            (if (eq? _clock-type1231_ std/srfi/19#time-utc)
                (std/srfi/19#tm:current-time-utc)
                (if (eq? _clock-type1231_ std/srfi/19#time-monotonic)
                    (std/srfi/19#tm:current-time-monotonic)
                    (if (eq? _clock-type1231_ std/srfi/19#time-thread)
                        (std/srfi/19#tm:current-time-thread)
                        (if (eq? _clock-type1231_ std/srfi/19#time-process)
                            (std/srfi/19#tm:current-time-process)
                            (std/srfi/19#tm:time-error
                             'current-time
                             'invalid-clock-type
                             _clock-type1231_)))))))))
  (define std/srfi/19#time-resolution
    (lambda _clock-type1219_
      (let ((_clock-type1224_
             (let ((_maybe-arg1221_ _clock-type1219_))
               (if (null? _maybe-arg1221_)
                   std/srfi/19#time-utc
                   (if (null? (cdr _maybe-arg1221_))
                       (car _maybe-arg1221_)
                       (error '"too many optional arguments"
                              _maybe-arg1221_))))))
        (if (eq? _clock-type1224_ std/srfi/19#time-tai)
            '1
            (if (eq? _clock-type1224_ std/srfi/19#time-utc)
                '1
                (if (eq? _clock-type1224_ std/srfi/19#time-monotonic)
                    '1
                    (if (eq? _clock-type1224_ std/srfi/19#time-thread)
                        '1000
                        (if (eq? _clock-type1224_ std/srfi/19#time-process)
                            '1000
                            (std/srfi/19#tm:time-error
                             'time-resolution
                             'invalid-clock-type
                             _clock-type1224_)))))))))
  (define std/srfi/19#tm:time-compare-check
    (lambda (_time11212_ _time21213_ _caller1214_)
      (if (or (not (and (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _time11212_
                           'std/srfi/19#time::t))
                        (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _time21213_
                           'std/srfi/19#time::t))))
              (not (eq? (##structure-ref
                         _time11212_
                         '1
                         std/srfi/19#time::t
                         '#f)
                        (##structure-ref
                         _time21213_
                         '1
                         std/srfi/19#time::t
                         '#f))))
          (std/srfi/19#tm:time-error _caller1214_ 'incompatible-time-types '#f)
          '#t)))
  (define std/srfi/19#time=?
    (lambda (_time11209_ _time21210_)
      (std/srfi/19#tm:time-compare-check _time11209_ _time21210_ 'time=?)
      (if (= (##structure-ref _time11209_ '3 std/srfi/19#time::t '#f)
             (##structure-ref _time21210_ '3 std/srfi/19#time::t '#f))
          (= (##structure-ref _time11209_ '2 std/srfi/19#time::t '#f)
             (##structure-ref _time21210_ '2 std/srfi/19#time::t '#f))
          '#f)))
  (define std/srfi/19#time>?
    (lambda (_time11203_ _time21204_)
      (std/srfi/19#tm:time-compare-check _time11203_ _time21204_ 'time>?)
      (let ((_$e1206_
             (> (##structure-ref _time11203_ '3 std/srfi/19#time::t '#f)
                (##structure-ref _time21204_ '3 std/srfi/19#time::t '#f))))
        (if _$e1206_
            _$e1206_
            (if (= (##structure-ref _time11203_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time21204_ '3 std/srfi/19#time::t '#f))
                (> (##structure-ref _time11203_ '2 std/srfi/19#time::t '#f)
                   (##structure-ref _time21204_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time<?
    (lambda (_time11197_ _time21198_)
      (std/srfi/19#tm:time-compare-check _time11197_ _time21198_ 'time<?)
      (let ((_$e1200_
             (< (##structure-ref _time11197_ '3 std/srfi/19#time::t '#f)
                (##structure-ref _time21198_ '3 std/srfi/19#time::t '#f))))
        (if _$e1200_
            _$e1200_
            (if (= (##structure-ref _time11197_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time21198_ '3 std/srfi/19#time::t '#f))
                (< (##structure-ref _time11197_ '2 std/srfi/19#time::t '#f)
                   (##structure-ref _time21198_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time>=?
    (lambda (_time11191_ _time21192_)
      (std/srfi/19#tm:time-compare-check _time11191_ _time21192_ 'time>=?)
      (let ((_$e1194_
             (>= (##structure-ref _time11191_ '3 std/srfi/19#time::t '#f)
                 (##structure-ref _time21192_ '3 std/srfi/19#time::t '#f))))
        (if _$e1194_
            _$e1194_
            (if (= (##structure-ref _time11191_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time21192_ '3 std/srfi/19#time::t '#f))
                (>= (##structure-ref _time11191_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref _time21192_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time<=?
    (lambda (_time11185_ _time21186_)
      (std/srfi/19#tm:time-compare-check _time11185_ _time21186_ 'time<=?)
      (let ((_$e1188_
             (<= (##structure-ref _time11185_ '3 std/srfi/19#time::t '#f)
                 (##structure-ref _time21186_ '3 std/srfi/19#time::t '#f))))
        (if _$e1188_
            _$e1188_
            (if (= (##structure-ref _time11185_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time21186_ '3 std/srfi/19#time::t '#f))
                (<= (##structure-ref _time11185_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref _time21186_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#tm:time->nanoseconds
    (lambda (_time1179_)
      (letrec ((_sign11181_
                (lambda (_n1183_) (if (negative? _n1183_) '-1 '1))))
        (+ (* (##structure-ref _time1179_ '3 std/srfi/19#time::t '#f)
              std/srfi/19#tm:nano)
           (##structure-ref _time1179_ '2 std/srfi/19#time::t '#f)))))
  (define std/srfi/19#tm:nanoseconds->time
    (lambda (_time-type1176_ _nanoseconds1177_)
      (let ((__tmp4935 (remainder _nanoseconds1177_ std/srfi/19#tm:nano))
            (__tmp4934 (quotient _nanoseconds1177_ std/srfi/19#tm:nano)))
        (declare (not safe))
        (##structure
         std/srfi/19#time::t
         _time-type1176_
         __tmp4935
         __tmp4934))))
  (define std/srfi/19#tm:nanoseconds->values
    (lambda (_nanoseconds1174_)
      (values (abs (remainder _nanoseconds1174_ std/srfi/19#tm:nano))
              (quotient _nanoseconds1174_ std/srfi/19#tm:nano))))
  (define std/srfi/19#tm:time-difference
    (lambda (_time11164_ _time21165_ _time31166_)
      (if (or (not (and (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _time11164_
                           'std/srfi/19#time::t))
                        (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _time21165_
                           'std/srfi/19#time::t))))
              (not (eq? (##structure-ref
                         _time11164_
                         '1
                         std/srfi/19#time::t
                         '#f)
                        (##structure-ref
                         _time21165_
                         '1
                         std/srfi/19#time::t
                         '#f))))
          (std/srfi/19#tm:time-error
           'time-difference
           'incompatible-time-types
           '#f)
          '#!void)
      (##structure-set!
       _time31166_
       std/srfi/19#time-duration
       '1
       std/srfi/19#time::t
       '#f)
      (if (std/srfi/19#time=? _time11164_ _time21165_)
          (begin
            (##structure-set! _time31166_ '0 '3 std/srfi/19#time::t '#f)
            (##structure-set! _time31166_ '0 '2 std/srfi/19#time::t '#f))
          (let ((_g4936_ (std/srfi/19#tm:nanoseconds->values
                          (- (std/srfi/19#tm:time->nanoseconds _time11164_)
                             (std/srfi/19#tm:time->nanoseconds _time21165_)))))
            (begin
              (let ((_g4937_ (let ()
                               (declare (not safe))
                               (if (##values? _g4936_)
                                   (##vector-length _g4936_)
                                   1))))
                (if (not (let () (declare (not safe)) (##fx= _g4937_ 2)))
                    (error "Context expects 2 values" _g4937_)))
              (let ((_nanos1171_
                     (let () (declare (not safe)) (##vector-ref _g4936_ 0)))
                    (_secs1172_
                     (let () (declare (not safe)) (##vector-ref _g4936_ 1))))
                (begin
                  (##structure-set!
                   _time31166_
                   _secs1172_
                   '3
                   std/srfi/19#time::t
                   '#f)
                  (##structure-set!
                   _time31166_
                   _nanos1171_
                   '2
                   std/srfi/19#time::t
                   '#f))))))
      _time31166_))
  (define std/srfi/19#time-difference
    (lambda (_time11161_ _time21162_)
      (std/srfi/19#tm:time-difference
       _time11161_
       _time21162_
       (let ()
         (declare (not safe))
         (##structure std/srfi/19#time::t '#f '#f '#f)))))
  (define std/srfi/19#time-difference!
    (lambda (_time11158_ _time21159_)
      (std/srfi/19#tm:time-difference _time11158_ _time21159_ _time11158_)))
  (define std/srfi/19#tm:add-duration
    (lambda (_time11148_ _duration1149_ _time31150_)
      (if (not (and (let ()
                      (declare (not safe))
                      (##structure-instance-of?
                       _time11148_
                       'std/srfi/19#time::t))
                    (let ()
                      (declare (not safe))
                      (##structure-instance-of?
                       _duration1149_
                       'std/srfi/19#time::t))))
          (std/srfi/19#tm:time-error
           'add-duration
           'incompatible-time-types
           '#f)
          '#!void)
      (if (not (eq? (##structure-ref _duration1149_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-duration))
          (std/srfi/19#tm:time-error
           'add-duration
           'not-duration
           _duration1149_)
          (let ((_sec-plus1152_
                 (+ (##structure-ref _time11148_ '3 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration1149_
                     '3
                     std/srfi/19#time::t
                     '#f)))
                (_nsec-plus1153_
                 (+ (##structure-ref _time11148_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration1149_
                     '2
                     std/srfi/19#time::t
                     '#f))))
            (let ((_r1155_ (remainder _nsec-plus1153_ std/srfi/19#tm:nano))
                  (_q1156_ (quotient _nsec-plus1153_ std/srfi/19#tm:nano)))
              (if (negative? _r1155_)
                  (begin
                    (##structure-set!
                     _time31150_
                     (+ _sec-plus1152_ _q1156_ '-1)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time31150_
                     (+ std/srfi/19#tm:nano _r1155_)
                     '2
                     std/srfi/19#time::t
                     '#f))
                  (begin
                    (##structure-set!
                     _time31150_
                     (+ _sec-plus1152_ _q1156_)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time31150_
                     _r1155_
                     '2
                     std/srfi/19#time::t
                     '#f)))
              _time31150_)))))
  (define std/srfi/19#add-duration
    (lambda (_time11145_ _duration1146_)
      (std/srfi/19#tm:add-duration
       _time11145_
       _duration1146_
       (let ((__tmp4938
              (##structure-ref _time11145_ '1 std/srfi/19#time::t '#f)))
         (declare (not safe))
         (##structure std/srfi/19#time::t __tmp4938 '#f '#f)))))
  (define std/srfi/19#add-duration!
    (lambda (_time11142_ _duration1143_)
      (std/srfi/19#tm:add-duration _time11142_ _duration1143_ _time11142_)))
  (define std/srfi/19#tm:subtract-duration
    (lambda (_time11132_ _duration1133_ _time31134_)
      (if (not (and (let ()
                      (declare (not safe))
                      (##structure-instance-of?
                       _time11132_
                       'std/srfi/19#time::t))
                    (let ()
                      (declare (not safe))
                      (##structure-instance-of?
                       _duration1133_
                       'std/srfi/19#time::t))))
          (std/srfi/19#tm:time-error
           'add-duration
           'incompatible-time-types
           '#f)
          '#!void)
      (if (not (eq? (##structure-ref _duration1133_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-duration))
          (std/srfi/19#tm:time-error
           'tm:subtract-duration
           'not-duration
           _duration1133_)
          (let ((_sec-minus1136_
                 (- (##structure-ref _time11132_ '3 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration1133_
                     '3
                     std/srfi/19#time::t
                     '#f)))
                (_nsec-minus1137_
                 (- (##structure-ref _time11132_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration1133_
                     '2
                     std/srfi/19#time::t
                     '#f))))
            (let ((_r1139_ (remainder _nsec-minus1137_ std/srfi/19#tm:nano))
                  (_q1140_ (quotient _nsec-minus1137_ std/srfi/19#tm:nano)))
              (if (negative? _r1139_)
                  (begin
                    (##structure-set!
                     _time31134_
                     (- _sec-minus1136_ _q1140_ '1)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time31134_
                     (+ std/srfi/19#tm:nano _r1139_)
                     '2
                     std/srfi/19#time::t
                     '#f))
                  (begin
                    (##structure-set!
                     _time31134_
                     (- _sec-minus1136_ _q1140_)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time31134_
                     _r1139_
                     '2
                     std/srfi/19#time::t
                     '#f)))
              _time31134_)))))
  (define std/srfi/19#subtract-duration
    (lambda (_time11129_ _duration1130_)
      (std/srfi/19#tm:subtract-duration
       _time11129_
       _duration1130_
       (let ((__tmp4939
              (##structure-ref _time11129_ '1 std/srfi/19#time::t '#f)))
         (declare (not safe))
         (##structure std/srfi/19#time::t __tmp4939 '#f '#f)))))
  (define std/srfi/19#subtract-duration!
    (lambda (_time11126_ _duration1127_)
      (std/srfi/19#tm:subtract-duration
       _time11126_
       _duration1127_
       _time11126_)))
  (define std/srfi/19#tm:time-tai->time-utc!
    (lambda (_time-in1122_ _time-out1123_ _caller1124_)
      (if (not (eq? (##structure-ref _time-in1122_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           _caller1124_
           'incompatible-time-types
           _time-in1122_)
          '#!void)
      (##structure-set!
       _time-out1123_
       std/srfi/19#time-utc
       '1
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out1123_
       (##structure-ref _time-in1122_ '2 std/srfi/19#time::t '#f)
       '2
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out1123_
       (- (##structure-ref _time-in1122_ '3 std/srfi/19#time::t '#f)
          (std/srfi/19#tm:leap-second-neg-delta
           (##structure-ref _time-in1122_ '3 std/srfi/19#time::t '#f)))
       '3
       std/srfi/19#time::t
       '#f)
      _time-out1123_))
  (define std/srfi/19#time-tai->time-utc
    (lambda (_time-in1120_)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in1120_
       (let ()
         (declare (not safe))
         (##structure std/srfi/19#time::t '#f '#f '#f))
       'time-tai->time-utc)))
  (define std/srfi/19#time-tai->time-utc!
    (lambda (_time-in1118_)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in1118_
       _time-in1118_
       'time-tai->time-utc!)))
  (define std/srfi/19#tm:time-utc->time-tai!
    (lambda (_time-in1114_ _time-out1115_ _caller1116_)
      (if (not (eq? (##structure-ref _time-in1114_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           _caller1116_
           'incompatible-time-types
           _time-in1114_)
          '#!void)
      (##structure-set!
       _time-out1115_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out1115_
       (##structure-ref _time-in1114_ '2 std/srfi/19#time::t '#f)
       '2
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out1115_
       (+ (##structure-ref _time-in1114_ '3 std/srfi/19#time::t '#f)
          (std/srfi/19#tm:leap-second-delta
           (##structure-ref _time-in1114_ '3 std/srfi/19#time::t '#f)))
       '3
       std/srfi/19#time::t
       '#f)
      _time-out1115_))
  (define std/srfi/19#time-utc->time-tai
    (lambda (_time-in1112_)
      (std/srfi/19#tm:time-utc->time-tai!
       _time-in1112_
       (let ()
         (declare (not safe))
         (##structure std/srfi/19#time::t '#f '#f '#f))
       'time-utc->time-tai)))
  (define std/srfi/19#time-utc->time-tai!
    (lambda (_time-in1110_)
      (std/srfi/19#tm:time-utc->time-tai!
       _time-in1110_
       _time-in1110_
       'time-utc->time-tai!)))
  (define std/srfi/19#time-monotonic->time-utc
    (lambda (_time-in1106_)
      (if (not (eq? (##structure-ref _time-in1106_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-utc
           'incompatible-time-types
           _time-in1106_)
          '#!void)
      (let ((_ntime1108_ (std/srfi/19#copy-time _time-in1106_)))
        (##structure-set!
         _ntime1108_
         std/srfi/19#time-tai
         '1
         std/srfi/19#time::t
         '#f)
        (std/srfi/19#tm:time-tai->time-utc!
         _ntime1108_
         _ntime1108_
         'time-monotonic->time-utc))))
  (define std/srfi/19#time-monotonic->time-utc!
    (lambda (_time-in1104_)
      (if (not (eq? (##structure-ref _time-in1104_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-utc!
           'incompatible-time-types
           _time-in1104_)
          '#!void)
      (##structure-set!
       _time-in1104_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in1104_
       _time-in1104_
       'time-monotonic->time-utc)))
  (define std/srfi/19#time-monotonic->time-tai
    (lambda (_time-in1100_)
      (if (not (eq? (##structure-ref _time-in1100_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-tai
           'incompatible-time-types
           _time-in1100_)
          '#!void)
      (let ((_ntime1102_ (std/srfi/19#copy-time _time-in1100_)))
        (##structure-set!
         _ntime1102_
         std/srfi/19#time-tai
         '1
         std/srfi/19#time::t
         '#f)
        _ntime1102_)))
  (define std/srfi/19#time-monotonic->time-tai!
    (lambda (_time-in1098_)
      (if (not (eq? (##structure-ref _time-in1098_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-tai!
           'incompatible-time-types
           _time-in1098_)
          '#!void)
      (##structure-set!
       _time-in1098_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      _time-in1098_))
  (define std/srfi/19#time-utc->time-monotonic
    (lambda (_time-in1094_)
      (if (not (eq? (##structure-ref _time-in1094_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->time-monotonic
           'incompatible-time-types
           _time-in1094_)
          '#!void)
      (let ((_ntime1096_
             (std/srfi/19#tm:time-utc->time-tai!
              _time-in1094_
              (let ()
                (declare (not safe))
                (##structure std/srfi/19#time::t '#f '#f '#f))
              'time-utc->time-monotonic)))
        (##structure-set!
         _ntime1096_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime1096_)))
  (define std/srfi/19#time-utc->time-monotonic!
    (lambda (_time-in1090_)
      (if (not (eq? (##structure-ref _time-in1090_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->time-montonic!
           'incompatible-time-types
           _time-in1090_)
          '#!void)
      (let ((_ntime1092_
             (std/srfi/19#tm:time-utc->time-tai!
              _time-in1090_
              _time-in1090_
              'time-utc->time-monotonic!)))
        (##structure-set!
         _ntime1092_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime1092_)))
  (define std/srfi/19#time-tai->time-monotonic
    (lambda (_time-in1086_)
      (if (not (eq? (##structure-ref _time-in1086_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->time-monotonic
           'incompatible-time-types
           _time-in1086_)
          '#!void)
      (let ((_ntime1088_ (std/srfi/19#copy-time _time-in1086_)))
        (##structure-set!
         _ntime1088_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime1088_)))
  (define std/srfi/19#time-tai->time-monotonic!
    (lambda (_time-in1084_)
      (if (not (eq? (##structure-ref _time-in1084_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->time-monotonic!
           'incompatible-time-types
           _time-in1084_)
          '#!void)
      (##structure-set!
       _time-in1084_
       std/srfi/19#time-monotonic
       '1
       std/srfi/19#time::t
       '#f)
      _time-in1084_))
  (define std/srfi/19#date::t
    (make-struct-type
     'std/srfi/19#date::t
     '#f
     '8
     'date
     '((transparent: . #t))
     '#f
     '(nanosecond second minute hour day month year zone-offset)))
  (define std/srfi/19#date? (make-struct-predicate std/srfi/19#date::t))
  (define std/srfi/19#make-date
    (lambda _$args1081_
      (apply make-struct-instance std/srfi/19#date::t _$args1081_)))
  (define std/srfi/19#date-nanosecond
    (make-struct-field-accessor std/srfi/19#date::t '0))
  (define std/srfi/19#date-second
    (make-struct-field-accessor std/srfi/19#date::t '1))
  (define std/srfi/19#date-minute
    (make-struct-field-accessor std/srfi/19#date::t '2))
  (define std/srfi/19#date-hour
    (make-struct-field-accessor std/srfi/19#date::t '3))
  (define std/srfi/19#date-day
    (make-struct-field-accessor std/srfi/19#date::t '4))
  (define std/srfi/19#date-month
    (make-struct-field-accessor std/srfi/19#date::t '5))
  (define std/srfi/19#date-year
    (make-struct-field-accessor std/srfi/19#date::t '6))
  (define std/srfi/19#date-zone-offset
    (make-struct-field-accessor std/srfi/19#date::t '7))
  (define std/srfi/19#date-nanosecond-set!
    (make-struct-field-mutator std/srfi/19#date::t '0))
  (define std/srfi/19#date-second-set!
    (make-struct-field-mutator std/srfi/19#date::t '1))
  (define std/srfi/19#date-minute-set!
    (make-struct-field-mutator std/srfi/19#date::t '2))
  (define std/srfi/19#date-hour-set!
    (make-struct-field-mutator std/srfi/19#date::t '3))
  (define std/srfi/19#date-day-set!
    (make-struct-field-mutator std/srfi/19#date::t '4))
  (define std/srfi/19#date-month-set!
    (make-struct-field-mutator std/srfi/19#date::t '5))
  (define std/srfi/19#date-year-set!
    (make-struct-field-mutator std/srfi/19#date::t '6))
  (define std/srfi/19#date-zone-offset-set!
    (make-struct-field-mutator std/srfi/19#date::t '7))
  (define std/srfi/19#tm:encode-julian-day-number
    (lambda (_day1070_ _month1071_ _year1072_)
      (let* ((_a1074_ (quotient (- '14 _month1071_) '12))
             (_y1076_ (- (- (+ _year1072_ '4800) _a1074_)
                         (if (negative? _year1072_) '-1 '0)))
             (_m1078_ (- (+ _month1071_ (* '12 _a1074_)) '3)))
        (+ _day1070_
           (quotient (+ (* '153 _m1078_) '2) '5)
           (* '365 _y1076_)
           (quotient _y1076_ '4)
           (- (quotient _y1076_ '100))
           (quotient _y1076_ '400)
           '-32045))))
  (define std/srfi/19#tm:char-pos
    (lambda (_char1065_ _str1066_ _index1067_ _len1068_)
      (if (>= _index1067_ _len1068_)
          '#f
          (if (char=? (string-ref _str1066_ _index1067_) _char1065_)
              _index1067_
              (std/srfi/19#tm:char-pos
               _char1065_
               _str1066_
               (+ _index1067_ '1)
               _len1068_)))))
  (define std/srfi/19#tm:fractional-part
    (lambda (_r1059_)
      (if (integer? _r1059_)
          '"0"
          (let* ((_str1061_ (number->string (exact->inexact _r1059_)))
                 (_ppos1063_
                  (std/srfi/19#tm:char-pos
                   '#\.
                   _str1061_
                   '0
                   (string-length _str1061_))))
            (substring
             _str1061_
             (+ _ppos1063_ '1)
             (string-length _str1061_))))))
  (define std/srfi/19#tm:decode-julian-day-number
    (lambda (_jdn1040_)
      (let* ((_days1042_ (truncate _jdn1040_))
             (_a1044_ (+ _days1042_ '32044))
             (_b1046_ (quotient (+ (* '4 _a1044_) '3) '146097))
             (_c1048_ (- _a1044_ (quotient (* '146097 _b1046_) '4)))
             (_d1050_ (quotient (+ (* '4 _c1048_) '3) '1461))
             (_e1052_ (- _c1048_ (quotient (* '1461 _d1050_) '4)))
             (_m1054_ (quotient (+ (* '5 _e1052_) '2) '153))
             (_y1056_ (+ (* '100 _b1046_)
                         _d1050_
                         '-4800
                         (quotient _m1054_ '10))))
        (values (* (- _jdn1040_ _days1042_) std/srfi/19#tm:sid)
                (+ _e1052_ (- (quotient (+ (* '153 _m1054_) '2) '5)) '1)
                (+ _m1054_ '3 (* '-12 (quotient _m1054_ '10)))
                (if (>= '0 _y1056_) (- _y1056_ '1) _y1056_)))))
  (define std/srfi/19#tm:local-tz-offset (lambda () '0))
  (define std/srfi/19#tm:time->julian-day-number
    (lambda (_seconds1036_ _tz-offset1037_)
      (+ (/ (+ _seconds1036_ _tz-offset1037_ std/srfi/19#tm:sihd)
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#tm:find
    (lambda (_proc1033_ _l1034_)
      (if (null? _l1034_)
          '#f
          (if (_proc1033_ (car _l1034_))
              '#t
              (std/srfi/19#tm:find _proc1033_ (cdr _l1034_))))))
  (define std/srfi/19#tm:tai-before-leap-second?
    (lambda (_second1029_)
      (std/srfi/19#tm:find
       (lambda (_x1031_)
         (= _second1029_ (- (+ (car _x1031_) (cdr _x1031_)) '1)))
       std/srfi/19#tm:leap-second-table)))
  (define std/srfi/19#tm:time->date
    (lambda (_time1005_ _tz-offset1006_ _ttype1007_)
      (if (not (eq? (##structure-ref _time1005_ '1 std/srfi/19#time::t '#f)
                    _ttype1007_))
          (std/srfi/19#tm:time-error
           'time->date
           'incompatible-time-types
           _time1005_)
          '#!void)
      (let ((_offset1012_
             (let ((_maybe-arg1009_ _tz-offset1006_))
               (if (null? _maybe-arg1009_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg1009_))
                       (car _maybe-arg1009_)
                       (error '"too many optional arguments"
                              _maybe-arg1009_))))))
        (let ((_g4940_ (std/srfi/19#tm:decode-julian-day-number
                        (std/srfi/19#tm:time->julian-day-number
                         (##structure-ref
                          _time1005_
                          '3
                          std/srfi/19#time::t
                          '#f)
                         _offset1012_))))
          (begin
            (let ((_g4941_ (let ()
                             (declare (not safe))
                             (if (##values? _g4940_)
                                 (##vector-length _g4940_)
                                 1))))
              (if (not (let () (declare (not safe)) (##fx= _g4941_ 4)))
                  (error "Context expects 4 values" _g4941_)))
            (let ((_secs1015_
                   (let () (declare (not safe)) (##vector-ref _g4940_ 0)))
                  (_date1016_
                   (let () (declare (not safe)) (##vector-ref _g4940_ 1)))
                  (_month1017_
                   (let () (declare (not safe)) (##vector-ref _g4940_ 2)))
                  (_year1018_
                   (let () (declare (not safe)) (##vector-ref _g4940_ 3))))
              (let* ((_hours1020_ (quotient _secs1015_ (* '60 '60)))
                     (_rem1022_ (remainder _secs1015_ (* '60 '60)))
                     (_minutes1024_ (quotient _rem1022_ '60))
                     (_seconds1026_ (remainder _rem1022_ '60)))
                (let ((__tmp4942
                       (##structure-ref
                        _time1005_
                        '2
                        std/srfi/19#time::t
                        '#f)))
                  (declare (not safe))
                  (##structure
                   std/srfi/19#date::t
                   __tmp4942
                   _seconds1026_
                   _minutes1024_
                   _hours1020_
                   _date1016_
                   _month1017_
                   _year1018_
                   _offset1012_)))))))))
  (define std/srfi/19#time-tai->date
    (lambda (_time1000_ . _tz-offset1001_)
      (if (std/srfi/19#tm:tai-before-leap-second?
           (##structure-ref _time1000_ '3 std/srfi/19#time::t '#f))
          (let ((_d1003_ (std/srfi/19#tm:time->date
                          (std/srfi/19#subtract-duration!
                           (std/srfi/19#time-tai->time-utc _time1000_)
                           (let ()
                             (declare (not safe))
                             (##structure
                              std/srfi/19#time::t
                              std/srfi/19#time-duration
                              '0
                              '1)))
                          _tz-offset1001_
                          std/srfi/19#time-utc)))
            (##structure-set! _d1003_ '60 '2 std/srfi/19#date::t '#f)
            _d1003_)
          (std/srfi/19#tm:time->date
           (std/srfi/19#time-tai->time-utc _time1000_)
           _tz-offset1001_
           std/srfi/19#time-utc))))
  (define std/srfi/19#time-utc->date
    (lambda (_time997_ . _tz-offset998_)
      (std/srfi/19#tm:time->date
       _time997_
       _tz-offset998_
       std/srfi/19#time-utc)))
  (define std/srfi/19#time-monotonic->date
    (lambda (_time994_ . _tz-offset995_)
      (std/srfi/19#tm:time->date
       _time994_
       _tz-offset995_
       std/srfi/19#time-monotonic)))
  (define std/srfi/19#date->time-utc
    (lambda (_date981_)
      (let ((_nanosecond983_
             (##structure-ref _date981_ '1 std/srfi/19#date::t '#f))
            (_second984_
             (##structure-ref _date981_ '2 std/srfi/19#date::t '#f))
            (_minute985_
             (##structure-ref _date981_ '3 std/srfi/19#date::t '#f))
            (_hour986_ (##structure-ref _date981_ '4 std/srfi/19#date::t '#f))
            (_day987_ (##structure-ref _date981_ '5 std/srfi/19#date::t '#f))
            (_month988_ (##structure-ref _date981_ '6 std/srfi/19#date::t '#f))
            (_year989_ (##structure-ref _date981_ '7 std/srfi/19#date::t '#f))
            (_offset990_
             (##structure-ref _date981_ '8 std/srfi/19#date::t '#f)))
        (let* ((_jdays992_
                (- (std/srfi/19#tm:encode-julian-day-number
                    _day987_
                    _month988_
                    _year989_)
                   std/srfi/19#tm:tai-epoch-in-jd))
               (__tmp4943
                (+ (* (- _jdays992_ '1/2) '24 '60 '60)
                   (* _hour986_ '60 '60)
                   (* _minute985_ '60)
                   _second984_
                   (- _offset990_))))
          (declare (not safe))
          (##structure
           std/srfi/19#time::t
           std/srfi/19#time-utc
           _nanosecond983_
           __tmp4943)))))
  (define std/srfi/19#date->time-tai
    (lambda (_d979_)
      (if (= (##structure-ref _d979_ '2 std/srfi/19#date::t '#f) '60)
          (std/srfi/19#subtract-duration!
           (std/srfi/19#time-utc->time-tai!
            (std/srfi/19#date->time-utc _d979_))
           (let ()
             (declare (not safe))
             (##structure
              std/srfi/19#time::t
              std/srfi/19#time-duration
              '0
              '1)))
          (std/srfi/19#time-utc->time-tai!
           (std/srfi/19#date->time-utc _d979_)))))
  (define std/srfi/19#date->time-monotonic
    (lambda (_date977_)
      (std/srfi/19#time-utc->time-monotonic!
       (std/srfi/19#date->time-utc _date977_))))
  (define std/srfi/19#tm:leap-year?
    (lambda (_year972_)
      (let ((_$e974_ (= (modulo _year972_ '400) '0)))
        (if _$e974_
            _$e974_
            (if (= (modulo _year972_ '4) '0)
                (not (= (modulo _year972_ '100) '0))
                '#f)))))
  (define std/srfi/19#leap-year?
    (lambda (_date970_)
      (std/srfi/19#tm:leap-year?
       (##structure-ref _date970_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:month-assoc
    '((0 . 0)
      (1 . 31)
      (2 . 59)
      (3 . 90)
      (4 . 120)
      (5 . 151)
      (6 . 181)
      (7 . 212)
      (8 . 243)
      (9 . 273)
      (10 . 304)
      (11 . 334)))
  (define std/srfi/19#tm:year-day
    (lambda (_day964_ _month965_ _year966_)
      (let ((_days-pr968_
             (assoc (- _month965_ '1) std/srfi/19#tm:month-assoc)))
        (if (not _days-pr968_)
            (std/srfi/19#tm:time-error
             'date-year-day
             'invalid-month-specification
             _month965_)
            '#!void)
        (if (and (std/srfi/19#tm:leap-year? _year966_) (> _month965_ '2))
            (+ _day964_ (cdr _days-pr968_) '1)
            (+ _day964_ (cdr _days-pr968_))))))
  (define std/srfi/19#date-year-day
    (lambda (_date962_)
      (std/srfi/19#tm:year-day
       (##structure-ref _date962_ '5 std/srfi/19#date::t '#f)
       (##structure-ref _date962_ '6 std/srfi/19#date::t '#f)
       (##structure-ref _date962_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:week-day
    (lambda (_day951_ _month952_ _year953_)
      (let* ((_a955_ (quotient (- '14 _month952_) '12))
             (_y957_ (- _year953_ _a955_))
             (_m959_ (+ _month952_ (* '12 _a955_) '-2)))
        (modulo (+ _day951_
                   _y957_
                   (quotient _y957_ '4)
                   (- (quotient _y957_ '100))
                   (quotient _y957_ '400)
                   (quotient (* '31 _m959_) '12))
                '7))))
  (define std/srfi/19#date-week-day
    (lambda (_date949_)
      (std/srfi/19#tm:week-day
       (##structure-ref _date949_ '5 std/srfi/19#date::t '#f)
       (##structure-ref _date949_ '6 std/srfi/19#date::t '#f)
       (##structure-ref _date949_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:days-before-first-week
    (lambda (_date941_ _day-of-week-starting-week942_)
      (let* ((_first-day944_
              (let ((__tmp4944
                     (##structure-ref _date941_ '7 std/srfi/19#date::t '#f)))
                (declare (not safe))
                (##structure
                 std/srfi/19#date::t
                 '0
                 '0
                 '0
                 '0
                 '1
                 '1
                 __tmp4944
                 '#f)))
             (_fdweek-day946_ (std/srfi/19#date-week-day _first-day944_)))
        (modulo (- _day-of-week-starting-week942_ _fdweek-day946_) '7))))
  (define std/srfi/19#date-week-number
    (lambda (_date938_ _day-of-week-starting-week939_)
      (quotient
       (- (std/srfi/19#date-year-day _date938_)
          (std/srfi/19#tm:days-before-first-week
           _date938_
           _day-of-week-starting-week939_))
       '7)))
  (define std/srfi/19#current-date
    (lambda _tz-offset933_
      (std/srfi/19#time-utc->date
       (std/srfi/19#current-time std/srfi/19#time-utc)
       (let ((_maybe-arg935_ _tz-offset933_))
         (if (null? _maybe-arg935_)
             (std/srfi/19#tm:local-tz-offset)
             (if (null? (cdr _maybe-arg935_))
                 (car _maybe-arg935_)
                 (error '"too many optional arguments" _maybe-arg935_)))))))
  (define std/srfi/19#tm:natural-year
    (lambda (_n926_)
      (let* ((_current-year928_
              (##structure-ref
               (std/srfi/19#current-date)
               '7
               std/srfi/19#date::t
               '#f))
             (_current-century930_ (* (quotient _current-year928_ '100) '100)))
        (if (>= _n926_ '100)
            _n926_
            (if (< _n926_ '0)
                _n926_
                (if (<= (- (+ _current-century930_ _n926_) _current-year928_)
                        '50)
                    (+ _current-century930_ _n926_)
                    (+ (- _current-century930_ '100) _n926_)))))))
  (define std/srfi/19#date->julian-day
    (lambda (_date915_)
      (let ((_nanosecond917_
             (##structure-ref _date915_ '1 std/srfi/19#date::t '#f))
            (_second918_
             (##structure-ref _date915_ '2 std/srfi/19#date::t '#f))
            (_minute919_
             (##structure-ref _date915_ '3 std/srfi/19#date::t '#f))
            (_hour920_ (##structure-ref _date915_ '4 std/srfi/19#date::t '#f))
            (_day921_ (##structure-ref _date915_ '5 std/srfi/19#date::t '#f))
            (_month922_ (##structure-ref _date915_ '6 std/srfi/19#date::t '#f))
            (_year923_ (##structure-ref _date915_ '7 std/srfi/19#date::t '#f))
            (_offset924_
             (##structure-ref _date915_ '8 std/srfi/19#date::t '#f)))
        (+ (std/srfi/19#tm:encode-julian-day-number
            _day921_
            _month922_
            _year923_)
           (- '1/2)
           (+ (/ (/ (+ (* _hour920_ '60 '60)
                       (* _minute919_ '60)
                       _second918_
                       (/ _nanosecond917_ std/srfi/19#tm:nano))
                    std/srfi/19#tm:sid)
                 (- _offset924_)))))))
  (define std/srfi/19#date->modified-julian-day
    (lambda (_date913_)
      (- (std/srfi/19#date->julian-day _date913_) '4800001/2)))
  (define std/srfi/19#time-utc->julian-day
    (lambda (_time911_)
      (if (not (eq? (##structure-ref _time911_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->julian-day
           'incompatible-time-types
           _time911_)
          '#!void)
      (+ (/ (+ (##structure-ref _time911_ '3 std/srfi/19#time::t '#f)
               (/ (##structure-ref _time911_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-utc->modified-julian-day
    (lambda (_time909_)
      (- (std/srfi/19#time-utc->julian-day _time909_) '4800001/2)))
  (define std/srfi/19#time-tai->julian-day
    (lambda (_time907_)
      (if (not (eq? (##structure-ref _time907_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->julian-day
           'incompatible-time-types
           _time907_)
          '#!void)
      (+ (/ (+ (- (##structure-ref _time907_ '3 std/srfi/19#time::t '#f)
                  (std/srfi/19#tm:leap-second-delta
                   (##structure-ref _time907_ '3 std/srfi/19#time::t '#f)))
               (/ (##structure-ref _time907_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-tai->modified-julian-day
    (lambda (_time905_)
      (- (std/srfi/19#time-tai->julian-day _time905_) '4800001/2)))
  (define std/srfi/19#time-monotonic->julian-day
    (lambda (_time903_)
      (if (not (eq? (##structure-ref _time903_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->julian-day
           'incompatible-time-types
           _time903_)
          '#!void)
      (+ (/ (+ (- (##structure-ref _time903_ '3 std/srfi/19#time::t '#f)
                  (std/srfi/19#tm:leap-second-delta
                   (##structure-ref _time903_ '3 std/srfi/19#time::t '#f)))
               (/ (##structure-ref _time903_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-monotonic->modified-julian-day
    (lambda (_time901_)
      (- (std/srfi/19#time-monotonic->julian-day _time901_) '4800001/2)))
  (define std/srfi/19#julian-day->time-utc
    (lambda (_jdn897_)
      (let ((_nanosecs899_
             (* std/srfi/19#tm:nano
                std/srfi/19#tm:sid
                (- _jdn897_ std/srfi/19#tm:tai-epoch-in-jd))))
        (let ((__tmp4946 (remainder _nanosecs899_ std/srfi/19#tm:nano))
              (__tmp4945 (floor (/ _nanosecs899_ std/srfi/19#tm:nano))))
          (declare (not safe))
          (##structure
           std/srfi/19#time::t
           std/srfi/19#time-utc
           __tmp4946
           __tmp4945)))))
  (define std/srfi/19#julian-day->time-tai
    (lambda (_jdn895_)
      (std/srfi/19#time-utc->time-tai!
       (std/srfi/19#julian-day->time-utc _jdn895_))))
  (define std/srfi/19#julian-day->time-monotonic
    (lambda (_jdn893_)
      (std/srfi/19#time-utc->time-monotonic!
       (std/srfi/19#julian-day->time-utc _jdn893_))))
  (define std/srfi/19#julian-day->date
    (lambda (_jdn885_ . _tz-offset886_)
      (let ((_offset891_
             (let ((_maybe-arg888_ _tz-offset886_))
               (if (null? _maybe-arg888_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg888_))
                       (car _maybe-arg888_)
                       (error '"too many optional arguments"
                              _maybe-arg888_))))))
        (std/srfi/19#time-utc->date
         (std/srfi/19#julian-day->time-utc _jdn885_)
         _offset891_))))
  (define std/srfi/19#modified-julian-day->date
    (lambda (_jdn877_ . _tz-offset878_)
      (let ((_offset883_
             (let ((_maybe-arg880_ _tz-offset878_))
               (if (null? _maybe-arg880_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg880_))
                       (car _maybe-arg880_)
                       (error '"too many optional arguments"
                              _maybe-arg880_))))))
        (std/srfi/19#julian-day->date (+ _jdn877_ '4800001/2) _offset883_))))
  (define std/srfi/19#modified-julian-day->time-utc
    (lambda (_jdn875_)
      (std/srfi/19#julian-day->time-utc (+ _jdn875_ '4800001/2))))
  (define std/srfi/19#modified-julian-day->time-tai
    (lambda (_jdn873_)
      (std/srfi/19#julian-day->time-tai (+ _jdn873_ '4800001/2))))
  (define std/srfi/19#modified-julian-day->time-monotonic
    (lambda (_jdn871_)
      (std/srfi/19#julian-day->time-monotonic (+ _jdn871_ '4800001/2))))
  (define std/srfi/19#current-julian-day
    (lambda ()
      (std/srfi/19#time-utc->julian-day
       (std/srfi/19#current-time std/srfi/19#time-utc))))
  (define std/srfi/19#current-modified-julian-day
    (lambda ()
      (std/srfi/19#time-utc->modified-julian-day
       (std/srfi/19#current-time std/srfi/19#time-utc))))
  (define std/srfi/19#tm:padding
    (lambda (_n847_ _pad-with848_ _length849_)
      (let* ((_str851_ (number->string _n847_))
             (_str-len853_ (string-length _str851_)))
        (if (or (> _str-len853_ _length849_) (not _pad-with848_))
            _str851_
            (let* ((_new-str859_ (make-string _length849_ _pad-with848_))
                   (_new-str-offset861_
                    (- (string-length _new-str859_) _str-len853_)))
              (let _$loop864_ ((_i867_ '0))
                (if (>= _i867_ (string-length _str851_))
                    '#!void
                    (begin
                      (string-set!
                       _new-str859_
                       (+ _new-str-offset861_ _i867_)
                       (string-ref _str851_ _i867_))
                      (_$loop864_ (+ _i867_ '1)))))
              _new-str859_)))))
  (define std/srfi/19#tm:last-n-digits
    (lambda (_i844_ _n845_) (abs (remainder _i844_ (expt '10 _n845_)))))
  (define std/srfi/19#tm:locale-abbr-weekday
    (lambda (_n842_)
      (vector-ref std/srfi/19#tm:locale-abbr-weekday-vector _n842_)))
  (define std/srfi/19#tm:locale-long-weekday
    (lambda (_n840_)
      (vector-ref std/srfi/19#tm:locale-long-weekday-vector _n840_)))
  (define std/srfi/19#tm:locale-abbr-month
    (lambda (_n838_)
      (vector-ref std/srfi/19#tm:locale-abbr-month-vector _n838_)))
  (define std/srfi/19#tm:locale-long-month
    (lambda (_n836_)
      (vector-ref std/srfi/19#tm:locale-long-month-vector _n836_)))
  (define std/srfi/19#tm:vector-find
    (lambda (_needle826_ _haystack827_ _comparator828_)
      (let ((_len830_ (vector-length _haystack827_)))
        (letrec ((_tm:vector-find-int832_
                  (lambda (_index834_)
                    (if (>= _index834_ _len830_)
                        '#f
                        (if (_comparator828_
                             _needle826_
                             (vector-ref _haystack827_ _index834_))
                            _index834_
                            (_tm:vector-find-int832_ (+ _index834_ '1)))))))
          (_tm:vector-find-int832_ '0)))))
  (define std/srfi/19#tm:locale-abbr-weekday->index
    (lambda (_string824_)
      (std/srfi/19#tm:vector-find
       _string824_
       std/srfi/19#tm:locale-abbr-weekday-vector
       string=?)))
  (define std/srfi/19#tm:locale-long-weekday->index
    (lambda (_string822_)
      (std/srfi/19#tm:vector-find
       _string822_
       std/srfi/19#tm:locale-long-weekday-vector
       string=?)))
  (define std/srfi/19#tm:locale-abbr-month->index
    (lambda (_string820_)
      (std/srfi/19#tm:vector-find
       _string820_
       std/srfi/19#tm:locale-abbr-month-vector
       string=?)))
  (define std/srfi/19#tm:locale-long-month->index
    (lambda (_string818_)
      (std/srfi/19#tm:vector-find
       _string818_
       std/srfi/19#tm:locale-long-month-vector
       string=?)))
  (define std/srfi/19#tm:locale-print-time-zone
    (lambda (_date815_ _port816_) '#!void))
  (define std/srfi/19#tm:locale-am/pm
    (lambda (_hr813_)
      (if (> _hr813_ '11) std/srfi/19#tm:locale-pm std/srfi/19#tm:locale-am)))
  (define std/srfi/19#tm:tz-printer
    (lambda (_offset807_ _port808_)
      (if (= _offset807_ '0)
          (display '"Z" _port808_)
          (if (negative? _offset807_)
              (display '"-" _port808_)
              (display '"+" _port808_)))
      (if (not (= _offset807_ '0))
          (let ((_hours810_ (abs (quotient _offset807_ (* '60 '60))))
                (_minutes811_
                 (abs (quotient (remainder _offset807_ (* '60 '60)) '60))))
            (display (std/srfi/19#tm:padding _hours810_ '#\0 '2) _port808_)
            (display (std/srfi/19#tm:padding _minutes811_ '#\0 '2) _port808_))
          '#!void)))
  (define std/srfi/19#tm:directives
    (list (cons '#\~
                (lambda (_date634_ _pad-with635_ _port636_)
                  (display '#\~ _port636_)))
          (cons '#\a
                (lambda (_date638_ _pad-with639_ _port640_)
                  (display (std/srfi/19#tm:locale-abbr-weekday
                            (std/srfi/19#date-week-day _date638_))
                           _port640_)))
          (cons '#\A
                (lambda (_date642_ _pad-with643_ _port644_)
                  (display (std/srfi/19#tm:locale-long-weekday
                            (std/srfi/19#date-week-day _date642_))
                           _port644_)))
          (cons '#\b
                (lambda (_date646_ _pad-with647_ _port648_)
                  (display (std/srfi/19#tm:locale-abbr-month
                            (##structure-ref
                             _date646_
                             '6
                             std/srfi/19#date::t
                             '#f))
                           _port648_)))
          (cons '#\B
                (lambda (_date650_ _pad-with651_ _port652_)
                  (display (std/srfi/19#tm:locale-long-month
                            (##structure-ref
                             _date650_
                             '6
                             std/srfi/19#date::t
                             '#f))
                           _port652_)))
          (cons '#\c
                (lambda (_date654_ _pad-with655_ _port656_)
                  (display (std/srfi/19#date->string
                            _date654_
                            std/srfi/19#tm:locale-date-time-format)
                           _port656_)))
          (cons '#\d
                (lambda (_date658_ _pad-with659_ _port660_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date658_
                             '5
                             std/srfi/19#date::t
                             '#f)
                            '#\0
                            '2)
                           _port660_)))
          (cons '#\D
                (lambda (_date662_ _pad-with663_ _port664_)
                  (display (std/srfi/19#date->string _date662_ '"~m/~d/~y")
                           _port664_)))
          (cons '#\e
                (lambda (_date666_ _pad-with667_ _port668_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date666_
                             '5
                             std/srfi/19#date::t
                             '#f)
                            '#\space
                            '2)
                           _port668_)))
          (cons '#\f
                (lambda (_date670_ _pad-with671_ _port672_)
                  (if (> (##structure-ref _date670_ '1 std/srfi/19#date::t '#f)
                         std/srfi/19#tm:nano)
                      (display (std/srfi/19#tm:padding
                                (+ (##structure-ref
                                    _date670_
                                    '2
                                    std/srfi/19#date::t
                                    '#f)
                                   '1)
                                _pad-with671_
                                '2)
                               _port672_)
                      (display (std/srfi/19#tm:padding
                                (##structure-ref
                                 _date670_
                                 '2
                                 std/srfi/19#date::t
                                 '#f)
                                _pad-with671_
                                '2)
                               _port672_))
                  (let* ((_ns674_ (std/srfi/19#tm:fractional-part
                                   (/ (##structure-ref
                                       _date670_
                                       '1
                                       std/srfi/19#date::t
                                       '#f)
                                      std/srfi/19#tm:nano
                                      '1.)))
                         (_le676_ (string-length _ns674_)))
                    (if (> _le676_ '2)
                        (begin
                          (display std/srfi/19#tm:locale-number-separator
                                   _port672_)
                          (display (substring _ns674_ '2 _le676_) _port672_))
                        '#!void))))
          (cons '#\h
                (lambda (_date679_ _pad-with680_ _port681_)
                  (display (std/srfi/19#date->string _date679_ '"~b")
                           _port681_)))
          (cons '#\H
                (lambda (_date683_ _pad-with684_ _port685_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date683_
                             '4
                             std/srfi/19#date::t
                             '#f)
                            _pad-with684_
                            '2)
                           _port685_)))
          (cons '#\I
                (lambda (_date687_ _pad-with688_ _port689_)
                  (let ((_hr691_ (##structure-ref
                                  _date687_
                                  '4
                                  std/srfi/19#date::t
                                  '#f)))
                    (if (> _hr691_ '12)
                        (display (std/srfi/19#tm:padding
                                  (- _hr691_ '12)
                                  _pad-with688_
                                  '2)
                                 _port689_)
                        (display (std/srfi/19#tm:padding
                                  _hr691_
                                  _pad-with688_
                                  '2)
                                 _port689_)))))
          (cons '#\j
                (lambda (_date693_ _pad-with694_ _port695_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#date-year-day _date693_)
                            _pad-with694_
                            '3)
                           _port695_)))
          (cons '#\k
                (lambda (_date697_ _pad-with698_ _port699_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date697_
                             '4
                             std/srfi/19#date::t
                             '#f)
                            '#\0
                            '2)
                           _port699_)))
          (cons '#\l
                (lambda (_date701_ _pad-with702_ _port703_)
                  (let ((_hr705_ (if (> (##structure-ref
                                         _date701_
                                         '4
                                         std/srfi/19#date::t
                                         '#f)
                                        '12)
                                     (- (##structure-ref
                                         _date701_
                                         '4
                                         std/srfi/19#date::t
                                         '#f)
                                        '12)
                                     (##structure-ref
                                      _date701_
                                      '4
                                      std/srfi/19#date::t
                                      '#f))))
                    (display (std/srfi/19#tm:padding _hr705_ '#\space '2)
                             _port703_))))
          (cons '#\m
                (lambda (_date707_ _pad-with708_ _port709_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date707_
                             '6
                             std/srfi/19#date::t
                             '#f)
                            _pad-with708_
                            '2)
                           _port709_)))
          (cons '#\M
                (lambda (_date711_ _pad-with712_ _port713_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date711_
                             '3
                             std/srfi/19#date::t
                             '#f)
                            _pad-with712_
                            '2)
                           _port713_)))
          (cons '#\n
                (lambda (_date715_ _pad-with716_ _port717_)
                  (newline _port717_)))
          (cons '#\N
                (lambda (_date719_ _pad-with720_ _port721_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date719_
                             '1
                             std/srfi/19#date::t
                             '#f)
                            _pad-with720_
                            '9)
                           _port721_)))
          (cons '#\p
                (lambda (_date723_ _pad-with724_ _port725_)
                  (display (std/srfi/19#tm:locale-am/pm
                            (##structure-ref
                             _date723_
                             '4
                             std/srfi/19#date::t
                             '#f))
                           _port725_)))
          (cons '#\r
                (lambda (_date727_ _pad-with728_ _port729_)
                  (display (std/srfi/19#date->string _date727_ '"~I:~M:~S ~p")
                           _port729_)))
          (cons '#\s
                (lambda (_date731_ _pad-with732_ _port733_)
                  (display (##structure-ref
                            (std/srfi/19#date->time-utc _date731_)
                            '3
                            std/srfi/19#time::t
                            '#f)
                           _port733_)))
          (cons '#\S
                (lambda (_date735_ _pad-with736_ _port737_)
                  (if (> (##structure-ref _date735_ '1 std/srfi/19#date::t '#f)
                         std/srfi/19#tm:nano)
                      (display (std/srfi/19#tm:padding
                                (+ (##structure-ref
                                    _date735_
                                    '2
                                    std/srfi/19#date::t
                                    '#f)
                                   '1)
                                _pad-with736_
                                '2)
                               _port737_)
                      (display (std/srfi/19#tm:padding
                                (##structure-ref
                                 _date735_
                                 '2
                                 std/srfi/19#date::t
                                 '#f)
                                _pad-with736_
                                '2)
                               _port737_))))
          (cons '#\t
                (lambda (_date739_ _pad-with740_ _port741_)
                  (display (integer->char '9) _port741_)))
          (cons '#\T
                (lambda (_date743_ _pad-with744_ _port745_)
                  (display (std/srfi/19#date->string _date743_ '"~H:~M:~S")
                           _port745_)))
          (cons '#\U
                (lambda (_date747_ _pad-with748_ _port749_)
                  (if (> (std/srfi/19#tm:days-before-first-week _date747_ '0)
                         '0)
                      (display (std/srfi/19#tm:padding
                                (+ (std/srfi/19#date-week-number _date747_ '0)
                                   '1)
                                '#\0
                                '2)
                               _port749_)
                      (display (std/srfi/19#tm:padding
                                (std/srfi/19#date-week-number _date747_ '0)
                                '#\0
                                '2)
                               _port749_))))
          (cons '#\V
                (lambda (_date751_ _pad-with752_ _port753_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#date-week-number _date751_ '1)
                            '#\0
                            '2)
                           _port753_)))
          (cons '#\w
                (lambda (_date755_ _pad-with756_ _port757_)
                  (display (std/srfi/19#date-week-day _date755_) _port757_)))
          (cons '#\x
                (lambda (_date759_ _pad-with760_ _port761_)
                  (display (std/srfi/19#date->string
                            _date759_
                            std/srfi/19#tm:locale-short-date-format)
                           _port761_)))
          (cons '#\X
                (lambda (_date763_ _pad-with764_ _port765_)
                  (display (std/srfi/19#date->string
                            _date763_
                            std/srfi/19#tm:locale-time-format)
                           _port765_)))
          (cons '#\W
                (lambda (_date767_ _pad-with768_ _port769_)
                  (if (> (std/srfi/19#tm:days-before-first-week _date767_ '1)
                         '0)
                      (display (std/srfi/19#tm:padding
                                (+ (std/srfi/19#date-week-number _date767_ '1)
                                   '1)
                                '#\0
                                '2)
                               _port769_)
                      (display (std/srfi/19#tm:padding
                                (std/srfi/19#date-week-number _date767_ '1)
                                '#\0
                                '2)
                               _port769_))))
          (cons '#\y
                (lambda (_date771_ _pad-with772_ _port773_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#tm:last-n-digits
                             (##structure-ref
                              _date771_
                              '7
                              std/srfi/19#date::t
                              '#f)
                             '2)
                            _pad-with772_
                            '2)
                           _port773_)))
          (cons '#\Y
                (lambda (_date775_ _pad-with776_ _port777_)
                  (display (##structure-ref
                            _date775_
                            '7
                            std/srfi/19#date::t
                            '#f)
                           _port777_)))
          (cons '#\z
                (lambda (_date779_ _pad-with780_ _port781_)
                  (std/srfi/19#tm:tz-printer
                   (##structure-ref _date779_ '8 std/srfi/19#date::t '#f)
                   _port781_)))
          (cons '#\Z
                (lambda (_date783_ _pad-with784_ _port785_)
                  (std/srfi/19#tm:locale-print-time-zone _date783_ _port785_)))
          (cons '#\1
                (lambda (_date787_ _pad-with788_ _port789_)
                  (display (std/srfi/19#date->string _date787_ '"~Y-~m-~d")
                           _port789_)))
          (cons '#\2
                (lambda (_date791_ _pad-with792_ _port793_)
                  (display (std/srfi/19#date->string _date791_ '"~k:~M:~S~z")
                           _port793_)))
          (cons '#\3
                (lambda (_date795_ _pad-with796_ _port797_)
                  (display (std/srfi/19#date->string _date795_ '"~k:~M:~S")
                           _port797_)))
          (cons '#\4
                (lambda (_date799_ _pad-with800_ _port801_)
                  (display (std/srfi/19#date->string
                            _date799_
                            '"~Y-~m-~dT~k:~M:~S~z")
                           _port801_)))
          (cons '#\5
                (lambda (_date803_ _pad-with804_ _port805_)
                  (display (std/srfi/19#date->string
                            _date803_
                            '"~Y-~m-~dT~k:~M:~S")
                           _port805_)))))
  (define std/srfi/19#tm:get-formatter
    (lambda (_char630_)
      (let ((_associated632_ (assoc _char630_ std/srfi/19#tm:directives)))
        (if _associated632_ (cdr _associated632_) '#f))))
  (define std/srfi/19#tm:date-printer
    (lambda (_date614_ _index615_ _format-string616_ _str-len617_ _port618_)
      (if (>= _index615_ _str-len617_)
          '#!void
          (let ((_current-char620_ (string-ref _format-string616_ _index615_)))
            (if (not (char=? _current-char620_ '#\~))
                (begin
                  (display _current-char620_ _port618_)
                  (std/srfi/19#tm:date-printer
                   _date614_
                   (+ _index615_ '1)
                   _format-string616_
                   _str-len617_
                   _port618_))
                (if (= (+ _index615_ '1) _str-len617_)
                    (std/srfi/19#tm:time-error
                     'tm:date-printer
                     'bad-date-format-string
                     _format-string616_)
                    (let ((_pad-char?622_
                           (string-ref _format-string616_ (+ _index615_ '1))))
                      (if (char=? _pad-char?622_ '#\-)
                          (if (= (+ _index615_ '2) _str-len617_)
                              (std/srfi/19#tm:time-error
                               'tm:date-printer
                               'bad-date-format-string
                               _format-string616_)
                              (let ((_formatter624_
                                     (std/srfi/19#tm:get-formatter
                                      (string-ref
                                       _format-string616_
                                       (+ _index615_ '2)))))
                                (if (not _formatter624_)
                                    (std/srfi/19#tm:time-error
                                     'tm:date-printer
                                     'bad-date-format-string
                                     _format-string616_)
                                    (begin
                                      (_formatter624_ _date614_ '#f _port618_)
                                      (std/srfi/19#tm:date-printer
                                       _date614_
                                       (+ _index615_ '3)
                                       _format-string616_
                                       _str-len617_
                                       _port618_)))))
                          (if (char=? _pad-char?622_ '#\_)
                              (if (= (+ _index615_ '2) _str-len617_)
                                  (std/srfi/19#tm:time-error
                                   'tm:date-printer
                                   'bad-date-format-string
                                   _format-string616_)
                                  (let ((_formatter626_
                                         (std/srfi/19#tm:get-formatter
                                          (string-ref
                                           _format-string616_
                                           (+ _index615_ '2)))))
                                    (if (not _formatter626_)
                                        (std/srfi/19#tm:time-error
                                         'tm:date-printer
                                         'bad-date-format-string
                                         _format-string616_)
                                        (begin
                                          (_formatter626_
                                           _date614_
                                           '#\space
                                           _port618_)
                                          (std/srfi/19#tm:date-printer
                                           _date614_
                                           (+ _index615_ '3)
                                           _format-string616_
                                           _str-len617_
                                           _port618_)))))
                              (let ((_formatter628_
                                     (std/srfi/19#tm:get-formatter
                                      (string-ref
                                       _format-string616_
                                       (+ _index615_ '1)))))
                                (if (not _formatter628_)
                                    (std/srfi/19#tm:time-error
                                     'tm:date-printer
                                     'bad-date-format-string
                                     _format-string616_)
                                    (begin
                                      (_formatter628_ _date614_ '#\0 _port618_)
                                      (std/srfi/19#tm:date-printer
                                       _date614_
                                       (+ _index615_ '2)
                                       _format-string616_
                                       _str-len617_
                                       _port618_)))))))))))))
  (define std/srfi/19#date->string
    (lambda (_date605_ . _format-string606_)
      (let ((_str-port611_ (open-output-string))
            (_fmt-str612_
             (let ((_maybe-arg608_ _format-string606_))
               (if (null? _maybe-arg608_)
                   '"~c"
                   (if (null? (cdr _maybe-arg608_))
                       (car _maybe-arg608_)
                       (error '"too many optional arguments"
                              _maybe-arg608_))))))
        (std/srfi/19#tm:date-printer
         _date605_
         '0
         _fmt-str612_
         (string-length _fmt-str612_)
         _str-port611_)
        (get-output-string _str-port611_))))
  (define std/srfi/19#tm:char->int
    (lambda (_ch603_)
      (if (char=? _ch603_ '#\0)
          '0
          (if (char=? _ch603_ '#\1)
              '1
              (if (char=? _ch603_ '#\2)
                  '2
                  (if (char=? _ch603_ '#\3)
                      '3
                      (if (char=? _ch603_ '#\4)
                          '4
                          (if (char=? _ch603_ '#\5)
                              '5
                              (if (char=? _ch603_ '#\6)
                                  '6
                                  (if (char=? _ch603_ '#\7)
                                      '7
                                      (if (char=? _ch603_ '#\8)
                                          '8
                                          (if (char=? _ch603_ '#\9)
                                              '9
                                              (std/srfi/19#tm:time-error
                                               'string->date
                                               'bad-date-template-string
                                               (list '"Non-integer character"
                                                     _ch603_))))))))))))))
  (define std/srfi/19#tm:integer-reader
    (lambda (_upto586_ _port587_)
      (letrec ((_accum-int589_
                (lambda (_port591_ _accum592_ _nchars593_)
                  (let ((_ch595_ (peek-char _port591_)))
                    (if (or (eof-object? _ch595_)
                            (not (char-numeric? _ch595_))
                            (and _upto586_ (>= _nchars593_ _upto586_)))
                        _accum592_
                        (_accum-int589_
                         _port591_
                         (+ (* _accum592_ '10)
                            (std/srfi/19#tm:char->int (read-char _port591_)))
                         (+ _nchars593_ '1)))))))
        (_accum-int589_ _port587_ '0 '0))))
  (define std/srfi/19#tm:make-integer-reader
    (lambda (_upto582_)
      (lambda (_port584_)
        (std/srfi/19#tm:integer-reader _upto582_ _port584_))))
  (define std/srfi/19#tm:fractional-integer-reader
    (lambda (_upto565_ _port566_)
      (letrec ((_accum-int568_
                (lambda (_port570_ _accum571_ _nchars572_)
                  (let ((_ch574_ (peek-char _port570_)))
                    (if (or (eof-object? _ch574_)
                            (not (char-numeric? _ch574_))
                            (and _upto565_ (>= _nchars572_ _upto565_)))
                        (* _accum571_ (expt '10 (- _upto565_ _nchars572_)))
                        (_accum-int568_
                         _port570_
                         (+ (* _accum571_ '10)
                            (std/srfi/19#tm:char->int (read-char _port570_)))
                         (+ _nchars572_ '1)))))))
        (_accum-int568_ _port566_ '0 '0))))
  (define std/srfi/19#tm:make-fractional-integer-reader
    (lambda (_upto561_)
      (lambda (_port563_)
        (std/srfi/19#tm:fractional-integer-reader _upto561_ _port563_))))
  (define std/srfi/19#tm:integer-reader-exact
    (lambda (_n548_ _port549_)
      (let ((_padding-ok551_ '#t))
        (letrec ((_accum-int553_
                  (lambda (_port555_ _accum556_ _nchars557_)
                    (let ((_ch559_ (peek-char _port555_)))
                      (if (>= _nchars557_ _n548_)
                          _accum556_
                          (if (eof-object? _ch559_)
                              (std/srfi/19#tm:time-error
                               'string->date
                               'bad-date-template-string
                               '"Premature ending to integer read.")
                              (if (char-numeric? _ch559_)
                                  (begin
                                    (set! _padding-ok551_ '#f)
                                    (_accum-int553_
                                     _port555_
                                     (+ (* _accum556_ '10)
                                        (std/srfi/19#tm:char->int
                                         (read-char _port555_)))
                                     (+ _nchars557_ '1)))
                                  (if _padding-ok551_
                                      (begin
                                        (read-char _port555_)
                                        (_accum-int553_
                                         _port555_
                                         _accum556_
                                         (+ _nchars557_ '1)))
                                      (std/srfi/19#tm:time-error
                                       'string->date
                                       'bad-date-template-string
                                       '"Non-numeric characters in integer read.")))))))))
          (_accum-int553_ _port549_ '0 '0)))))
  (define std/srfi/19#tm:make-integer-exact-reader
    (lambda (_n544_)
      (lambda (_port546_)
        (std/srfi/19#tm:integer-reader-exact _n544_ _port546_))))
  (define std/srfi/19#tm:zone-reader
    (lambda (_port526_)
      (let ((_offset528_ '0) (_positive?529_ '#f))
        (let ((_ch531_ (read-char _port526_)))
          (if (eof-object? _ch531_)
              (std/srfi/19#tm:time-error
               'string->date
               'bad-date-template-string
               (list '"Invalid time zone +/-" _ch531_))
              '#!void)
          (if (or (char=? _ch531_ '#\Z) (char=? _ch531_ '#\z))
              '0
              (begin
                (if (char=? _ch531_ '#\+)
                    (set! _positive?529_ '#t)
                    (if (char=? _ch531_ '#\-)
                        (set! _positive?529_ '#f)
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-template-string
                         (list '"Invalid time zone +/-" _ch531_))))
                (let ((_ch536_ (read-char _port526_)))
                  (if (eof-object? _ch536_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch536_))
                      '#!void)
                  (set! _offset528_
                        (* (std/srfi/19#tm:char->int _ch536_) '10 '60 '60)))
                (let ((_ch538_ (read-char _port526_)))
                  (if (eof-object? _ch538_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch538_))
                      '#!void)
                  (set! _offset528_
                        (+ _offset528_
                           (* (std/srfi/19#tm:char->int _ch538_) '60 '60))))
                (let ((_ch540_ (read-char _port526_)))
                  (if (eof-object? _ch540_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch540_))
                      '#!void)
                  (set! _offset528_
                        (+ _offset528_
                           (* (std/srfi/19#tm:char->int _ch540_) '10 '60))))
                (let ((_ch542_ (read-char _port526_)))
                  (if (eof-object? _ch542_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch542_))
                      '#!void)
                  (set! _offset528_
                        (+ _offset528_
                           (* (std/srfi/19#tm:char->int _ch542_) '60))))
                (if _positive?529_ _offset528_ (- _offset528_))))))))
  (define std/srfi/19#tm:locale-reader
    (lambda (_port511_ _indexer512_)
      (let ((_string-port514_ (open-output-string)))
        (letrec ((_read-char-string516_
                  (lambda ()
                    (let ((_ch524_ (peek-char _port511_)))
                      (if (char-alphabetic? _ch524_)
                          (begin
                            (write-char (read-char _port511_) _string-port514_)
                            (_read-char-string516_))
                          (get-output-string _string-port514_))))))
          (let* ((_str518_ (_read-char-string516_))
                 (_index520_ (_indexer512_ _str518_)))
            (if _index520_
                _index520_
                (std/srfi/19#tm:time-error
                 'string->date
                 'bad-date-template-string
                 (list '"Invalid string for " _indexer512_))))))))
  (define std/srfi/19#tm:make-locale-reader
    (lambda (_indexer507_)
      (lambda (_port509_)
        (std/srfi/19#tm:locale-reader _port509_ _indexer507_))))
  (define std/srfi/19#tm:make-char-id-reader
    (lambda (_char503_)
      (lambda (_port505_)
        (if (char=? _char503_ (read-char _port505_))
            _char503_
            (std/srfi/19#tm:time-error
             'string->date
             'bad-date-template-string
             '"Invalid character match.")))))
  (define std/srfi/19#tm:read-directives
    (let ((_ireader4437_ (std/srfi/19#tm:make-integer-reader '4))
          (_ireader2438_ (std/srfi/19#tm:make-integer-reader '2))
          (_fireader9439_ (std/srfi/19#tm:make-fractional-integer-reader '9))
          (_ireaderf440_ (std/srfi/19#tm:make-integer-reader '#f))
          (_eireader2441_ (std/srfi/19#tm:make-integer-exact-reader '2))
          (_eireader4442_ (std/srfi/19#tm:make-integer-exact-reader '4))
          (_locale-reader-abbr-weekday443_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-abbr-weekday->index))
          (_locale-reader-long-weekday444_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-long-weekday->index))
          (_locale-reader-abbr-month445_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-abbr-month->index))
          (_locale-reader-long-month446_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-long-month->index))
          (_char-fail447_ (lambda (_ch432_) '#t))
          (_do-nothing448_ (lambda (_val434_ _object435_) '#!void)))
      (list (list '#\~
                  _char-fail447_
                  (std/srfi/19#tm:make-char-id-reader '#\~)
                  _do-nothing448_)
            (list '#\a
                  char-alphabetic?
                  _locale-reader-abbr-weekday443_
                  _do-nothing448_)
            (list '#\A
                  char-alphabetic?
                  _locale-reader-long-weekday444_
                  _do-nothing448_)
            (list '#\b
                  char-alphabetic?
                  _locale-reader-abbr-month445_
                  (lambda (_val450_ _object451_)
                    (##structure-set!
                     _object451_
                     _val450_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\B
                  char-alphabetic?
                  _locale-reader-long-month446_
                  (lambda (_val453_ _object454_)
                    (##structure-set!
                     _object454_
                     _val453_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\d
                  char-numeric?
                  _ireader2438_
                  (lambda (_val456_ _object457_)
                    (##structure-set!
                     _object457_
                     _val456_
                     '5
                     std/srfi/19#date::t
                     '#f)))
            (list '#\e
                  _char-fail447_
                  _eireader2441_
                  (lambda (_val459_ _object460_)
                    (##structure-set!
                     _object460_
                     _val459_
                     '5
                     std/srfi/19#date::t
                     '#f)))
            (list '#\h
                  char-alphabetic?
                  _locale-reader-abbr-month445_
                  (lambda (_val462_ _object463_)
                    (##structure-set!
                     _object463_
                     _val462_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\H
                  char-numeric?
                  _ireader2438_
                  (lambda (_val465_ _object466_)
                    (##structure-set!
                     _object466_
                     _val465_
                     '4
                     std/srfi/19#date::t
                     '#f)))
            (list '#\k
                  _char-fail447_
                  _eireader2441_
                  (lambda (_val468_ _object469_)
                    (##structure-set!
                     _object469_
                     _val468_
                     '4
                     std/srfi/19#date::t
                     '#f)))
            (list '#\m
                  char-numeric?
                  _ireader2438_
                  (lambda (_val471_ _object472_)
                    (##structure-set!
                     _object472_
                     _val471_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\M
                  char-numeric?
                  _ireader2438_
                  (lambda (_val474_ _object475_)
                    (##structure-set!
                     _object475_
                     _val474_
                     '3
                     std/srfi/19#date::t
                     '#f)))
            (list '#\N
                  char-numeric?
                  _fireader9439_
                  (lambda (_val477_ _object478_)
                    (##structure-set!
                     _object478_
                     _val477_
                     '1
                     std/srfi/19#date::t
                     '#f)))
            (list '#\S
                  char-numeric?
                  _ireader2438_
                  (lambda (_val480_ _object481_)
                    (##structure-set!
                     _object481_
                     _val480_
                     '2
                     std/srfi/19#date::t
                     '#f)))
            (list '#\y
                  _char-fail447_
                  _eireader2441_
                  (lambda (_val483_ _object484_)
                    (##structure-set!
                     _object484_
                     (std/srfi/19#tm:natural-year _val483_)
                     '7
                     std/srfi/19#date::t
                     '#f)))
            (list '#\Y
                  char-numeric?
                  _ireader4437_
                  (lambda (_val486_ _object487_)
                    (##structure-set!
                     _object487_
                     _val486_
                     '7
                     std/srfi/19#date::t
                     '#f)))
            (list '#\z
                  (lambda (_c489_)
                    (let ((_$e491_ (char=? _c489_ '#\Z)))
                      (if _$e491_
                          _$e491_
                          (let ((_$e494_ (char=? _c489_ '#\z)))
                            (if _$e494_
                                _$e494_
                                (let ((_$e497_ (char=? _c489_ '#\+)))
                                  (if _$e497_
                                      _$e497_
                                      (char=? _c489_ '#\-))))))))
                  std/srfi/19#tm:zone-reader
                  (lambda (_val500_ _object501_)
                    (##structure-set!
                     _object501_
                     _val500_
                     '8
                     std/srfi/19#date::t
                     '#f))))))
  (define std/srfi/19#tm:string->date
    (lambda (_date400_
             _index401_
             _format-string402_
             _str-len403_
             _port404_
             _template-string405_)
      (letrec ((_skip-until407_
                (lambda (_port427_ _skipper428_)
                  (let ((_ch430_ (peek-char _port427_)))
                    (if (eof-object? _ch430_)
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-format-string
                         _template-string405_)
                        (if (not (_skipper428_ _ch430_))
                            (begin
                              (read-char _port427_)
                              (_skip-until407_ _port427_ _skipper428_))
                            '#!void))))))
        (if (>= _index401_ _str-len403_)
            '#!void
            (let ((_current-char409_
                   (string-ref _format-string402_ _index401_)))
              (if (not (char=? _current-char409_ '#\~))
                  (let ((_port-char411_ (read-char _port404_)))
                    (if (or (eof-object? _port-char411_)
                            (not (char=? _current-char409_ _port-char411_)))
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-format-string
                         _template-string405_)
                        '#!void)
                    (std/srfi/19#tm:string->date
                     _date400_
                     (+ _index401_ '1)
                     _format-string402_
                     _str-len403_
                     _port404_
                     _template-string405_))
                  (if (> (+ _index401_ '1) _str-len403_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-format-string
                       _template-string405_)
                      (let* ((_format-char416_
                              (string-ref
                               _format-string402_
                               (+ _index401_ '1)))
                             (_format-info418_
                              (assoc _format-char416_
                                     std/srfi/19#tm:read-directives)))
                        (if (not _format-info418_)
                            (std/srfi/19#tm:time-error
                             'string->date
                             'bad-date-format-string
                             _template-string405_)
                            (let ((_skipper421_ (cadr _format-info418_))
                                  (_reader422_ (caddr _format-info418_))
                                  (_actor423_ (cadddr _format-info418_)))
                              (_skip-until407_ _port404_ _skipper421_)
                              (let ((_val425_ (_reader422_ _port404_)))
                                (if (eof-object? _val425_)
                                    (std/srfi/19#tm:time-error
                                     'string->date
                                     'bad-date-format-string
                                     _template-string405_)
                                    (_actor423_ _val425_ _date400_)))
                              (std/srfi/19#tm:string->date
                               _date400_
                               (+ _index401_ '2)
                               _format-string402_
                               _str-len403_
                               _port404_
                               _template-string405_)))))))))))
  (define std/srfi/19#string->date
    (lambda (_input-string391_ _template-string392_)
      (letrec ((_tm:date-ok?394_
                (lambda (_date398_)
                  (if (##structure-ref _date398_ '1 std/srfi/19#date::t '#f)
                      (if (##structure-ref
                           _date398_
                           '2
                           std/srfi/19#date::t
                           '#f)
                          (if (##structure-ref
                               _date398_
                               '3
                               std/srfi/19#date::t
                               '#f)
                              (if (##structure-ref
                                   _date398_
                                   '4
                                   std/srfi/19#date::t
                                   '#f)
                                  (if (##structure-ref
                                       _date398_
                                       '5
                                       std/srfi/19#date::t
                                       '#f)
                                      (if (##structure-ref
                                           _date398_
                                           '6
                                           std/srfi/19#date::t
                                           '#f)
                                          (if (##structure-ref
                                               _date398_
                                               '7
                                               std/srfi/19#date::t
                                               '#f)
                                              (##structure-ref
                                               _date398_
                                               '8
                                               std/srfi/19#date::t
                                               '#f)
                                              '#f)
                                          '#f)
                                      '#f)
                                  '#f)
                              '#f)
                          '#f)
                      '#f))))
        (let ((_newdate396_
               (let ()
                 (declare (not safe))
                 (##structure
                  std/srfi/19#date::t
                  '0
                  '0
                  '0
                  '0
                  '#f
                  '#f
                  '#f
                  '0))))
          (std/srfi/19#tm:string->date
           _newdate396_
           '0
           _template-string392_
           (string-length _template-string392_)
           (open-input-string _input-string391_)
           _template-string392_)
          (if (_tm:date-ok?394_ _newdate396_)
              _newdate396_
              (std/srfi/19#tm:time-error
               'string->date
               'bad-date-format-string
               (list '"Incomplete date read. "
                     _newdate396_
                     _template-string392_))))))))
