# Assorted examples of netinfo usage
#
# Stuart Cassoff
# January 2007
# July 2007
# Summer 2012
#

package require netinfo
namespace import netinfo::*

set ::errorInfo {}

loadProtocolData
loadServiceData
loadNetworkData
loadHostData

puts pbno:[protocol -number 123]
puts pbna:[protocol -name ptp]
puts pbna:[protocol -name ip]
puts pbal:[protocol -aliases {HOPOPT}]
puts pbal:[protocol -aliases IP-ENCAP]
puts sbpt:[service -port 9]
puts sbal:[service -aliases mail]
puts sbna:[service -name smtp]
puts sbna:[service -name time -protocol udp]
puts sbal:[service -aliases null]
puts sbal:[service -aliases sink]
puts sbna:[service -name domain]
puts nbna:[network -name loopback]
puts nbno:[network -number 127]
puts hbad:[host -address 127.0.0.1]
puts hbal:[host -aliases localhost]

puts h:[hostData [host -aliases localhost] -address]
puts h:[hostData [host -aliases localhost -domain inet6] -address]

puts p:[protocol -number 123]
puts p:[protocolData [protocol -number 123] -comment]
puts p:[protocolData [protocol -number 123] -comment -name]

puts s:[service -port 9]
puts s:[service -port 9 -protocol udp]
puts s:[service -port 9 -protocol *]
puts s:[serviceData [lindex [service -port 9 -protocol *] 1] -protocol]

puts n:[networkData [network -number 224] -name]

puts pf:[protocolFields]
puts sf:[serviceFields]
puts nf:[networkFields]
puts hf:[hostFields]
puts ef:[etherFields]

puts err:$::errorInfo

# EOF
