// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_Category_HeaderFile
#define _Interface_Category_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Interface_GTool.hxx>
#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <Handle_Interface_Protocol.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
#include <Standard_CString.hxx>
class Interface_GTool;
class TColStd_HArray1OfInteger;
class Interface_Protocol;
class Standard_Transient;
class Interface_ShareTool;
class Interface_InterfaceModel;


//! This class manages categories
//! A category is defined by a name and a number, and can be
//! seen as a way of rough classification, i.e. less precise than
//! a cdl type.
//! Hence, it is possible to dispatch every entity in about
//! a dozen of categories, twenty is a reasonable maximum.
//!
//! Basically, the system provides the following categories :
//! Shape (Geometry, BRep, CSG, Features, etc...)
//! Drawing (Drawing, Views, Annotations, Pictures, Scketches ...)
//! Structure (Component & Part, Groups & Patterns ...)
//! Description (Meta-Data : Relations, Properties, Product ...)
//! Auxiliary   (those which do not enter in the above list)
//! and some dedicated categories
//! FEA , Kinematics , Piping , etc...
//! plus Professional  for other dedicated non-classed categories
//!
//! In addition, this class provides a way to compute then quickly
//! query category numbers for an entire model.
//! Values are just recorded as a list of numbers, control must
//! then be done in a wider context (which must provide a Graph)
class Interface_Category 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates a Category, with no protocol yet
  Standard_EXPORT Interface_Category();
  
  //! Creates a Category with a given protocol
  Standard_EXPORT Interface_Category(const Handle(Interface_Protocol)& proto);
  
  //! Creates a Category with a given GTool
  Standard_EXPORT Interface_Category(const Handle(Interface_GTool)& gtool);
  
  //! Sets/Changes Protocol
  Standard_EXPORT   void SetProtocol (const Handle(Interface_Protocol)& proto) ;
  
  //! Determines the Category Number for an entity in its context,
  //! by using general service CategoryNumber
  Standard_EXPORT   Standard_Integer CatNum (const Handle(Standard_Transient)& ent, const Interface_ShareTool& shares) ;
  
  //! Clears the recorded list of category numbers for a Model
  Standard_EXPORT   void ClearNums() ;
  
  //! Computes the Category Number for each entity and records it,
  //! in an array (ent.number -> category number)
  //! Hence, it can be queried by the method Num.
  //! The Model itself is not recorded, this method is intended to
  //! be used in a wider context (which detains also a Graph, etc)
  Standard_EXPORT   void Compute (const Handle(Interface_InterfaceModel)& model, const Interface_ShareTool& shares) ;
  
  //! Returns the category number recorded for an entity number
  //! Returns 0 if out of range
  Standard_EXPORT   Standard_Integer Num (const Standard_Integer nument)  const;
  
  //! Records a new Category defined by its names, produces a number
  //! New if not yet recorded
  Standard_EXPORT static   Standard_Integer AddCategory (const Standard_CString name) ;
  
  //! Returns the count of recorded categories
  Standard_EXPORT static   Standard_Integer NbCategories() ;
  
  //! Returns the name of a category, according to its number
  Standard_EXPORT static   Standard_CString Name (const Standard_Integer num) ;
  
  //! Returns the number of a category, according to its name
  Standard_EXPORT static   Standard_Integer Number (const Standard_CString name) ;
  
  //! Default initialisation
  //! (protected against several calls : passes only once)
  Standard_EXPORT static   void Init() ;




protected:





private:



  Handle(Interface_GTool) thegtool;
  Handle(TColStd_HArray1OfInteger) thenum;


};







#endif // _Interface_Category_HeaderFile
