/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import java.util.LinkedList;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpanTagHandler
extends DefaultHandler {
    private Element currentElement = null;
    private Element topElement = null;
    private int generateMessage = 0;
    private long characterCount = 0L;

    public Element getTopElement() {
        return this.topElement;
    }

    public int getGenerateMessage() {
        return this.generateMessage;
    }

    public void countNestedElements(Element e) {
        LinkedList<Element> elementQueue = new LinkedList<Element>();
        int divElementsCounter = 0;
        int spanElementsCounter = 0;
        elementQueue.add(e);
        while (!elementQueue.isEmpty()) {
            e = (Element)elementQueue.remove();
            if (e == null || e.elementName == null) continue;
            if (e.elementName.compareToIgnoreCase("DIV") == 0) {
                ++divElementsCounter;
            } else if (e.elementName.compareToIgnoreCase("SPAN") == 0) {
                ++spanElementsCounter;
            }
            for (int i = 0; i < e.nestedElements.size(); ++i) {
                Element childElement = e.nestedElements.get(i);
                elementQueue.add(childElement);
            }
        }
        long numWords = 1L + this.characterCount / 6L;
        if (numWords > 50L && ((double)divElementsCounter / (double)numWords > 0.1 || (double)spanElementsCounter / (double)numWords > 0.1)) {
            ++this.generateMessage;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element newElement = new Element(qName);
        newElement.setParentElement(this.currentElement);
        if (this.currentElement != null) {
            this.currentElement.addNestedElement(newElement);
            this.currentElement = newElement;
        } else {
            this.topElement = this.currentElement = newElement;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentElement = this.currentElement.getParentElement();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characterCount += (long)length;
    }

    class Element {
        Element parentElement;
        final Vector<Element> nestedElements = new Vector();
        final String elementName;

        public Element(String name) {
            this.elementName = name;
        }

        public void setParentElement(Element e) {
            this.parentElement = e;
        }

        public Element getParentElement() {
            return this.parentElement;
        }

        public void addNestedElement(Element e) {
            this.nestedElements.add(e);
        }
    }
}

