/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ncx.NCXHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;

public class NCXChecker
implements ContentChecker {
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public NCXChecker(ValidationContext context) {
        Preconditions.checkState((boolean)"application/x-dtbncx+xml".equals(context.mimeType));
        this.context = context;
        this.report = context.report;
        this.path = context.path;
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = (OCFPackage)this.context.ocf.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(ocf.getName()), this.path);
        } else {
            String uid;
            XMLParser ncxParser = new XMLParser(this.context);
            ncxParser.addValidator(XMLValidators.NCX_RNG.get());
            ncxParser.addValidator(XMLValidators.NCX_SCH.get());
            NCXHandler ncxHandler = new NCXHandler(ncxParser, this.path, (XRefChecker)this.context.xrefChecker.get());
            ncxParser.addXMLHandler(ncxHandler);
            ncxParser.process();
            String ncxId = ncxHandler.getUid();
            if (ncxId != null && !ncxId.equals(ncxId.trim())) {
                this.report.message(MessageId.NCX_004, ncxParser.getLocation(), new Object[0]);
            }
            if ((uid = ocf.getOpfData().values().iterator().next().getUniqueIdentifier()) != null && ncxId != null && !uid.equals(ncxId.trim())) {
                this.report.message(MessageId.NCX_001, ncxParser.getLocation(), ncxHandler.getUid(), uid);
            }
        }
    }
}

