/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtil {
    static final String workingDirectory = System.getProperty("user.dir");
    private static final Pattern REGEX_URI_SCHEME = Pattern.compile("^\\p{Alpha}(\\p{Alnum}|\\.|\\+|-)*:");
    private static final Pattern REGEX_URI = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern REGEX_URI_FRAGMENT = Pattern.compile("#");
    private static final Pattern REGEX_REMOTE_URI = Pattern.compile("^[^:/?#]+://.*");

    public static boolean isRemote(String path) {
        return REGEX_REMOTE_URI.matcher((CharSequence)Preconditions.checkNotNull((Object)path)).matches();
    }

    public static String resolveRelativeReference(String base, String ref) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)ref);
        if (REGEX_URI_SCHEME.matcher(ref).lookingAt()) {
            return ref;
        }
        if (base == null) {
            return PathUtil.normalizePath(ref);
        }
        try {
            ref = URLDecoder.decode(ref.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
        base = PathUtil.normalizePath(REGEX_URI_FRAGMENT.split(base)[0]);
        ref = ref.startsWith("#") ? base + PathUtil.normalizePath(ref) : base.substring(0, base.lastIndexOf("/") + 1) + PathUtil.normalizePath(ref);
        return PathUtil.normalizePath(ref);
    }

    public static String normalizePath(String path) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)path);
        if (path.startsWith("data:")) {
            return path;
        }
        Matcher matcher = REGEX_URI.matcher(path);
        String prepath = "";
        String postpath = "";
        if (matcher.matches()) {
            prepath = (matcher.group(1) != null ? matcher.group(1) : "") + (matcher.group(3) != null ? matcher.group(3) : "");
            path = matcher.group(5);
            postpath = (matcher.group(6) != null ? matcher.group(6) : "") + (matcher.group(8) != null ? matcher.group(8) : "");
        }
        Stack<String> segments = new Stack<String>();
        Iterator tokenized = Splitter.on((char)'/').trimResults().split((CharSequence)path).iterator();
        block10: while (tokenized.hasNext()) {
            String segment;
            switch (segment = (String)tokenized.next()) {
                case ".": {
                    if (tokenized.hasNext()) continue block10;
                    segments.push("");
                    continue block10;
                }
                case "": {
                    if (!segments.empty() && tokenized.hasNext()) continue block10;
                    segments.push("");
                    continue block10;
                }
                case "..": {
                    if (segments.size() > 0 && !"..".equals(segments.peek()) && !"".equals(segments.peek())) {
                        segments.pop();
                    } else {
                        segments.push(segment);
                    }
                    if (tokenized.hasNext()) continue block10;
                    segments.push("");
                    continue block10;
                }
            }
            segments.push(segment);
        }
        return prepath + Joiner.on((char)'/').join(segments) + postpath;
    }

    public static String removeWorkingDirectory(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        return path.replace(workingDirectory, ".");
    }

    public static String getFragment(String uri) {
        int hash = ((String)Preconditions.checkNotNull((Object)uri)).indexOf("#") + 1;
        return hash > 0 ? Strings.emptyToNull((String)uri.substring(hash)) : null;
    }

    public static String removeFragment(String uri) {
        int hash = ((String)Preconditions.checkNotNull((Object)uri)).indexOf("#");
        return hash > -1 ? uri.substring(0, hash) : uri;
    }
}

