/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.elgamal.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.elgamal.ElGamalPublicKey;
import net.i2p.crypto.elgamal.spec.ElGamalParameterSpec;
import net.i2p.crypto.elgamal.spec.ElGamalPublicKeySpec;

public class ElGamalPublicKeyImpl
implements ElGamalPublicKey,
DHPublicKey {
    private static final long serialVersionUID = 8712728417091216948L;
    private BigInteger y;
    private ElGamalParameterSpec elSpec;

    public ElGamalPublicKeyImpl(ElGamalPublicKeySpec spec) {
        this.y = spec.getY();
        this.elSpec = new ElGamalParameterSpec(spec.getParams().getP(), spec.getParams().getG());
    }

    public ElGamalPublicKeyImpl(DHPublicKeySpec spec) {
        this.y = spec.getY();
        this.elSpec = new ElGamalParameterSpec(spec.getP(), spec.getG());
    }

    public ElGamalPublicKeyImpl(ElGamalPublicKey key) {
        this.y = key.getY();
        this.elSpec = key.getParameters();
    }

    public ElGamalPublicKeyImpl(DHPublicKey key) {
        this.y = key.getY();
        this.elSpec = new ElGamalParameterSpec(key.getParams().getP(), key.getParams().getG());
    }

    public ElGamalPublicKeyImpl(BigInteger y, ElGamalParameterSpec elSpec) {
        this.y = y;
        this.elSpec = elSpec;
    }

    public ElGamalPublicKeyImpl(X509EncodedKeySpec spec) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        byte[] pb = this.elSpec.getP().toByteArray();
        byte[] gb = this.elSpec.getG().toByteArray();
        byte[] yb = this.y.toByteArray();
        int seq3len = ElGamalPublicKeyImpl.spaceFor(pb.length) + ElGamalPublicKeyImpl.spaceFor(gb.length);
        int seq2len = 8 + ElGamalPublicKeyImpl.spaceFor(seq3len);
        int seq1len = ElGamalPublicKeyImpl.spaceFor(seq2len) + ElGamalPublicKeyImpl.spaceFor(yb.length + 1);
        int totlen = ElGamalPublicKeyImpl.spaceFor(seq1len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq1len);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq2len);
        rv[idx++] = 6;
        rv[idx++] = 6;
        rv[idx++] = 43;
        rv[idx++] = 14;
        rv[idx++] = 7;
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = 1;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seq3len);
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, pb.length);
        System.arraycopy(pb, 0, rv, idx, pb.length);
        idx += pb.length;
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, gb.length);
        System.arraycopy(gb, 0, rv, idx, gb.length);
        idx += gb.length;
        rv[idx++] = 3;
        idx = SigUtil.intToASN1(rv, idx, yb.length + 1);
        rv[idx++] = 0;
        System.arraycopy(yb, 0, rv, idx, yb.length);
        return rv;
    }

    static int spaceFor(int val) {
        int rv = val > 255 ? 3 : (val > 127 ? 2 : 1);
        return 1 + rv + val;
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.y = (BigInteger)in.readObject();
        this.elSpec = new ElGamalParameterSpec((BigInteger)in.readObject(), (BigInteger)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getY());
        out.writeObject(this.elSpec.getP());
        out.writeObject(this.elSpec.getG());
    }
}

