"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var goal_spec_1 = require("./goal_spec");
var picked_shapes_1 = require("./picked_shapes");
var EMPTY_TOOLTIP = Object.freeze({
    header: null,
    values: [],
});
exports.getTooltipInfoSelector = re_reselect_1.default([goal_spec_1.getSpecOrNull, picked_shapes_1.getPickedShapes], function (spec, pickedShapes) {
    if (!spec) {
        return EMPTY_TOOLTIP;
    }
    var tooltipInfo = {
        header: null,
        values: [],
    };
    pickedShapes.forEach(function (shape) {
        tooltipInfo.values.push({
            label: 'Actual',
            color: 'white',
            isHighlighted: false,
            isVisible: true,
            seriesIdentifier: {
                specId: spec.id,
                key: spec.id,
            },
            value: shape.actual,
            formattedValue: "" + shape.actual,
        });
    });
    return tooltipInfo;
})(function (state) { return state.chartId; });
//# sourceMappingURL=tooltip.js.map