"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("../../../../scales/types");
function isWithinRectBounds(_a, _b) {
    var x = _a.x, y = _a.y;
    var startX = _b.startX, endX = _b.endX, startY = _b.startY, endY = _b.endY;
    var withinXBounds = x >= startX && x <= endX;
    var withinYBounds = y >= startY && y <= endY;
    return withinXBounds && withinYBounds;
}
exports.isWithinRectBounds = isWithinRectBounds;
function computeRectAnnotationDimensions(annotationSpec, yScales, xScale, isHistogram) {
    if (isHistogram === void 0) { isHistogram = false; }
    var dataValues = annotationSpec.dataValues;
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    var rectsProps = [];
    dataValues.forEach(function (dataValue) {
        var _a, _b;
        var _c = dataValue.coordinates, x0 = _c.x0, x1 = _c.x1, y0 = _c.y0, y1 = _c.y1;
        if (x0 == null && x1 == null && y0 == null && y1 == null) {
            return;
        }
        _a = __read(limitValueToDomainRange(xScale, x0, x1, isHistogram), 2), x0 = _a[0], x1 = _a[1];
        _b = __read(limitValueToDomainRange(yScale, y0, y1), 2), y0 = _b[0], y1 = _b[1];
        if (x0 == null || x1 == null || y0 == null || y1 == null) {
            return;
        }
        var xAndWidth = null;
        if (types_1.isBandScale(xScale)) {
            xAndWidth = scaleXonBandScale(xScale, x0, x1);
        }
        else if (types_1.isContinuousScale(xScale)) {
            xAndWidth = scaleXonContinuousScale(xScale, x0, x1, isHistogram);
        }
        if (!xAndWidth) {
            return;
        }
        var scaledY1 = yScale.pureScale(y1);
        var scaledY0 = yScale.pureScale(y0);
        if (scaledY1 == null || scaledY0 == null) {
            return;
        }
        var height = Math.abs(scaledY0 - scaledY1);
        var rectDimensions = __assign(__assign({}, xAndWidth), { y: scaledY1, height: height });
        rectsProps.push({
            rect: rectDimensions,
            details: dataValue.details,
        });
    });
    return rectsProps;
}
exports.computeRectAnnotationDimensions = computeRectAnnotationDimensions;
function scaleXonBandScale(xScale, x0, x1) {
    var padding = (xScale.step - xScale.originalBandwidth) / 2;
    var scaledX1 = xScale.scale(x1);
    var scaledX0 = xScale.scale(x0);
    if (scaledX1 == null || scaledX0 == null) {
        return null;
    }
    scaledX1 += xScale.originalBandwidth + padding;
    if (scaledX1 > xScale.range[1]) {
        scaledX1 = xScale.range[1];
    }
    scaledX0 -= padding;
    if (scaledX0 < xScale.range[0]) {
        scaledX0 = xScale.range[0];
    }
    var width = Math.abs(scaledX1 - scaledX0);
    return {
        x: scaledX0,
        width: width,
    };
}
function scaleXonContinuousScale(xScale, x0, x1, isHistogramModeEnabled) {
    if (isHistogramModeEnabled === void 0) { isHistogramModeEnabled = false; }
    if (typeof x1 !== 'number' || typeof x0 !== 'number') {
        return null;
    }
    var scaledX0 = xScale.scale(x0);
    var scaledX1;
    if (xScale.totalBarsInCluster > 0 && !isHistogramModeEnabled) {
        scaledX1 = xScale.scale(x1 + xScale.minInterval);
    }
    else {
        scaledX1 = xScale.scale(x1);
    }
    if (scaledX1 == null || scaledX0 == null) {
        return null;
    }
    var width = Math.abs(scaledX1 - scaledX0);
    return {
        x: scaledX0 - (xScale.bandwidthPadding / 2) * xScale.totalBarsInCluster,
        width: width,
    };
}
function limitValueToDomainRange(scale, minValue, maxValue, isHistogram) {
    if (isHistogram === void 0) { isHistogram = false; }
    var _a = __read(scale.domain, 1), domainStartValue = _a[0];
    var domainEndValue = scale.domain.length > 0 ? scale.domain[scale.domain.length - 1] : scale.domain[0];
    var min = getMin(domainStartValue, minValue);
    var max = getMax(isHistogram ? domainEndValue + scale.minInterval : domainEndValue, maxValue);
    if (!types_1.isContinuousScale(scale)) {
        return [min, max];
    }
    if (min !== null && max !== null && min > max) {
        return [null, null];
    }
    return [min, max];
}
function getMax(max, value) {
    if (value == null) {
        return max;
    }
    if (typeof value === 'number') {
        return Math.min(value, max);
    }
    return value;
}
function getMin(min, value) {
    if (value == null) {
        return min;
    }
    if (typeof value === 'number') {
        return Math.max(value, min);
    }
    return value;
}
//# sourceMappingURL=dimensions.js.map