"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = require("../state/utils/common");
var spec_1 = require("../state/utils/spec");
var specs_1 = require("../utils/specs");
var dimensions_1 = require("./line/dimensions");
var dimensions_2 = require("./rect/dimensions");
function getAnnotationAxis(axesSpecs, groupId, domainType, chartRotation) {
    var _a = spec_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isHorizontalRotated = common_1.isHorizontalRotation(chartRotation);
    var isXDomainAnnotation = isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    var rotatedAnnotation = isHorizontalRotated ? annotationAxis : isXDomainAnnotation ? yAxis : xAxis;
    return rotatedAnnotation ? rotatedAnnotation.position : undefined;
}
exports.getAnnotationAxis = getAnnotationAxis;
function isXDomain(domainType) {
    return domainType === specs_1.AnnotationDomainTypes.XDomain;
}
exports.isXDomain = isXDomain;
function getTransformedCursor(cursorPosition, chartDimensions, chartRotation, projectArea) {
    if (projectArea === void 0) { projectArea = false; }
    var height = chartDimensions.height, width = chartDimensions.width, left = chartDimensions.left, top = chartDimensions.top;
    var x = cursorPosition.x, y = cursorPosition.y;
    if (projectArea) {
        x = cursorPosition.x - left;
        y = cursorPosition.y - top;
    }
    if (chartRotation === null) {
        return { x: x, y: y };
    }
    switch (chartRotation) {
        case 90:
            return { x: y, y: width - x };
        case -90:
            return { x: height - y, y: x };
        case 180:
            return { x: width - x, y: height - y };
        case 0:
        default:
            return { x: x, y: y };
    }
}
exports.getTransformedCursor = getTransformedCursor;
function invertTranformedCursor(cursorPosition, chartDimensions, chartRotation, projectArea) {
    if (projectArea === void 0) { projectArea = false; }
    var height = chartDimensions.height, width = chartDimensions.width, left = chartDimensions.left, top = chartDimensions.top;
    var x = cursorPosition.x, y = cursorPosition.y;
    switch (chartRotation) {
        case 0:
        case null:
            break;
        case 90:
            x = width - cursorPosition.y;
            y = cursorPosition.x;
            break;
        case -90:
            y = height - cursorPosition.x;
            x = cursorPosition.y;
            break;
        case 180:
        default:
            y = height - cursorPosition.y;
            x = width - cursorPosition.x;
    }
    if (projectArea) {
        x += left;
        y += top;
    }
    return { x: x, y: y };
}
exports.invertTranformedCursor = invertTranformedCursor;
function computeAnnotationDimensions(annotations, chartDimensions, chartRotation, yScales, xScale, axesSpecs, isHistogramModeEnabled) {
    var annotationDimensions = new Map();
    annotations.forEach(function (annotationSpec) {
        var id = annotationSpec.id;
        if (specs_1.isLineAnnotation(annotationSpec)) {
            var groupId = annotationSpec.groupId, domainType = annotationSpec.domainType;
            var annotationAxisPosition = getAnnotationAxis(axesSpecs, groupId, domainType, chartRotation);
            var dimensions = dimensions_1.computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, isHistogramModeEnabled, annotationAxisPosition);
            if (dimensions) {
                annotationDimensions.set(id, dimensions);
            }
        }
        else if (specs_1.isRectAnnotation(annotationSpec)) {
            var dimensions = dimensions_2.computeRectAnnotationDimensions(annotationSpec, yScales, xScale, isHistogramModeEnabled);
            if (dimensions) {
                annotationDimensions.set(id, dimensions);
            }
        }
    });
    return annotationDimensions;
}
exports.computeAnnotationDimensions = computeAnnotationDimensions;
//# sourceMappingURL=utils.js.map