"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var dimensions_1 = require("../../../../../utils/dimensions");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderTitle(ctx, props) {
    var _a = props.axisSpec, title = _a.title, position = _a.position, axisTitle = props.axisStyle.axisTitle;
    if (!title || !axisTitle.visible) {
        return null;
    }
    if (axis_type_utils_1.isHorizontalAxis(position)) {
        return renderHorizontalTitle(ctx, props);
    }
    return renderVerticalTitle(ctx, props);
}
exports.renderTitle = renderTitle;
function renderVerticalTitle(ctx, props) {
    var height = props.axisPosition.height, _a = props.axisSpec, title = _a.title, position = _a.position, hideAxis = _a.hide, maxLabelBboxWidth = props.axisTicksDimensions.maxLabelBboxWidth, _b = props.axisStyle, axisTitle = _b.axisTitle, tickLine = _b.tickLine, tickLabel = _b.tickLabel, debug = props.debug;
    if (!title) {
        return null;
    }
    var tickDimension = axis_utils_1.shouldShowTicks(tickLine, hideAxis) ? tickLine.size + tickLine.padding : 0;
    var titlePadding = dimensions_1.getSimplePadding(axisTitle.visible ? axisTitle.padding : 0);
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var labelWidth = tickLabel.visible ? labelPadding.outer + maxLabelBboxWidth + labelPadding.inner : 0;
    var top = height;
    var left = position === commons_1.Position.Left ? titlePadding.outer : tickDimension + labelWidth + titlePadding.inner;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: height, height: axisTitle.fontSize }, undefined, undefined, -90);
    }
    var font = {
        fontFamily: axisTitle.fontFamily,
        fontVariant: 'normal',
        fontStyle: axisTitle.fontStyle ? axisTitle.fontStyle : 'normal',
        fontWeight: 'normal',
        textColor: axisTitle.fill,
        textOpacity: 1,
    };
    text_1.renderText(ctx, {
        x: left + axisTitle.fontSize / 2,
        y: top - height / 2,
    }, title, __assign(__assign({}, font), { fill: axisTitle.fill, align: 'center', baseline: 'middle', fontSize: axisTitle.fontSize }), -90);
}
function renderHorizontalTitle(ctx, props) {
    var width = props.axisPosition.width, _a = props.axisSpec, title = _a.title, position = _a.position, hideAxis = _a.hide, maxLabelBboxHeight = props.axisTicksDimensions.maxLabelBboxHeight, _b = props.axisStyle, axisTitle = _b.axisTitle, tickLine = _b.tickLine, tickLabel = _b.tickLabel, debug = props.debug;
    if (!title) {
        return;
    }
    var tickDimension = axis_utils_1.shouldShowTicks(tickLine, hideAxis) ? tickLine.size + tickLine.padding : 0;
    var titlePadding = dimensions_1.getSimplePadding(axisTitle.visible ? axisTitle.padding : 0);
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var labelHeight = tickLabel.visible ? maxLabelBboxHeight + labelPadding.outer + labelPadding.inner : 0;
    var top = position === commons_1.Position.Top ? titlePadding.outer : labelHeight + tickDimension + titlePadding.inner;
    var left = 0;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: width, height: axisTitle.fontSize });
    }
    var font = {
        fontFamily: axisTitle.fontFamily,
        fontVariant: 'normal',
        fontStyle: axisTitle.fontStyle ? axisTitle.fontStyle : 'normal',
        fontWeight: 'normal',
        textColor: axisTitle.fill,
        textOpacity: 1,
    };
    text_1.renderText(ctx, {
        x: left + width / 2,
        y: top + axisTitle.fontSize / 2,
    }, title, __assign(__assign({}, font), { fill: axisTitle.fill, align: 'center', baseline: 'middle', fontSize: axisTitle.fontSize }));
}
//# sourceMappingURL=title.js.map