"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var is_brush_available_1 = require("./is_brush_available");
var getCurrentPointerPositionSelector = function (state) { return state.interactions.pointer.current.position; };
exports.getPointerCursorSelector = re_reselect_1.default([
    get_tooltip_values_highlighted_geoms_1.getHighlightedGeomsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    getCurrentPointerPositionSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    is_brush_available_1.isBrushAvailableSelector,
], function (highlightedGeometries, settingsSpec, currentPointerPosition, _a, isBrushAvailable) {
    var chartDimensions = _a.chartDimensions;
    var x = currentPointerPosition.x, y = currentPointerPosition.y;
    var xPos = x - chartDimensions.left;
    var yPos = y - chartDimensions.top;
    if (xPos < 0 || xPos >= chartDimensions.width) {
        return 'default';
    }
    if (yPos < 0 || yPos >= chartDimensions.height) {
        return 'default';
    }
    if (highlightedGeometries.length > 0 && (settingsSpec.onElementClick || settingsSpec.onElementOver)) {
        return 'pointer';
    }
    return isBrushAvailable ? 'crosshair' : 'default';
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_cursor_pointer.js.map