/*
 * Decompiled with CFR 0.152.
 */
package lucee.runtime.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import lucee.commons.io.res.ContentType;
import lucee.commons.io.res.Resource;
import lucee.commons.io.res.ResourceProvider;
import lucee.commons.io.res.filter.ResourceFilter;
import lucee.commons.io.res.filter.ResourceNameFilter;
import lucee.runtime.PageContext;
import lucee.runtime.PageSource;
import lucee.runtime.exp.PageException;

public interface ResourceUtil {
    public static final char FILE_SEPERATOR = File.separatorChar;
    public static final char FILE_ANTI_SEPERATOR = (char)(FILE_SEPERATOR == '/' ? 92 : 47);
    public static final short TYPE_DIR = 0;
    public static final short TYPE_FILE = 1;
    public static final short LEVEL_FILE = 0;
    public static final short LEVEL_PARENT_FILE = 1;
    public static final short LEVEL_GRAND_PARENT_FILE = 2;

    public Resource toResourceExisting(PageContext var1, String var2) throws PageException;

    public Resource toResourceExistingParent(PageContext var1, String var2) throws PageException;

    public Resource toResourceNotExisting(PageContext var1, String var2);

    public Resource createResource(Resource var1, short var2, short var3);

    public void setAttribute(Resource var1, String var2) throws IOException;

    @Deprecated
    public String getMimeType(Resource var1, String var2);

    @Deprecated
    public String getMimeType(byte[] var1, String var2);

    public boolean isChildOf(Resource var1, Resource var2);

    public String getPathToChild(Resource var1, Resource var2);

    @Deprecated
    public String getExtension(Resource var1);

    public String getExtension(Resource var1, String var2);

    @Deprecated
    public String getExtension(String var1);

    public String getExtension(String var1, String var2);

    public void copyRecursive(Resource var1, Resource var2) throws IOException;

    public void copyRecursive(Resource var1, Resource var2, ResourceFilter var3) throws IOException;

    public void removeChildren(Resource var1) throws IOException;

    public void removeChildren(Resource var1, ResourceNameFilter var2) throws IOException;

    public void removeChildren(Resource var1, ResourceFilter var2) throws IOException;

    public void moveTo(Resource var1, Resource var2) throws IOException;

    public boolean isEmpty(Resource var1);

    public boolean isEmptyDirectory(Resource var1);

    public boolean isEmptyFile(Resource var1);

    public String translatePath(String var1, boolean var2, boolean var3);

    public String[] translatePathName(String var1);

    public String merge(String var1, String var2);

    public String removeScheme(String var1, String var2);

    public void checkCreateDirectoryOK(Resource var1, boolean var2) throws IOException;

    public void checkCreateFileOK(Resource var1, boolean var2) throws IOException;

    public void checkCopyToOK(Resource var1, Resource var2) throws IOException;

    public void checkMoveToOK(Resource var1, Resource var2) throws IOException;

    public void checkGetInputStreamOK(Resource var1) throws IOException;

    public void checkGetOutputStreamOK(Resource var1) throws IOException;

    public void checkRemoveOK(Resource var1) throws IOException;

    @Deprecated
    public String toString(Resource var1, String var2) throws IOException;

    public String toString(Resource var1, Charset var2) throws IOException;

    public String contractPath(PageContext var1, String var2);

    public Resource getHomeDirectory();

    public Resource getSystemDirectory();

    public Resource getTempDirectory();

    public String parsePlaceHolder(String var1);

    public ResourceFilter getExtensionResourceFilter(String var1, boolean var2);

    public ResourceFilter getExtensionResourceFilter(String[] var1, boolean var2);

    public ContentType getContentType(Resource var1);

    public Resource toResourceExistingParent(PageContext var1, String var2, boolean var3) throws PageException;

    public Resource toResourceNotExisting(PageContext var1, String var2, boolean var3, boolean var4);

    public boolean isUNCPath(String var1);

    public Resource toExactResource(Resource var1);

    public String prettifyPath(String var1);

    public String getCanonicalPathSilent(Resource var1);

    public Resource getCanonicalResourceSilent(Resource var1);

    public boolean createNewResourceSilent(Resource var1);

    public void touch(Resource var1) throws IOException;

    public void clear(Resource var1) throws IOException;

    public Resource changeExtension(Resource var1, String var2);

    public void deleteContent(Resource var1, ResourceFilter var2);

    public void copy(Resource var1, Resource var2) throws IOException;

    public void removeChildrenSilent(Resource var1, ResourceNameFilter var2);

    public void removeChildrenSilent(Resource var1, ResourceFilter var2);

    public void removeChildrenSilent(Resource var1);

    public void removeSilent(Resource var1, boolean var2);

    public void createFileSilent(Resource var1, boolean var2);

    public void createDirectorySilent(Resource var1, boolean var2);

    public long getRealSize(Resource var1, ResourceFilter var2);

    public int getChildCount(Resource var1, ResourceFilter var2);

    public boolean isEmptyDirectory(Resource var1, ResourceFilter var2);

    public void deleteEmptyFolders(Resource var1) throws IOException;

    public Resource getResource(PageContext var1, PageSource var2, Resource var3);

    public int directrySize(Resource var1, ResourceFilter var2);

    public int directrySize(Resource var1, ResourceNameFilter var2);

    public String[] names(Resource[] var1);

    public Resource[] merge(Resource[] var1, Resource ... var2);

    public void removeEmptyFolders(Resource var1) throws IOException;

    public List<Resource> listRecursive(Resource var1, ResourceFilter var2);

    public char getSeparator(ResourceProvider var1);

    public ResourceProvider getFileResourceProvider();
}

