/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;
import org.lwjgl.openal.EFXUtil;
import org.lwjgl.util.WaveData;

public final class EFX10Test {
    public static void main(String[] args) throws Exception {
        EFX10Test.silentTests();
        EFX10Test.playbackTest();
        EFX10Test.efxUtilTest();
    }

    private static void setupEfx() throws Exception {
        if (!AL.isCreated()) {
            AL.create();
        }
        if (!ALC10.alcIsExtensionPresent((ALCdevice)AL.getDevice(), (String)"ALC_EXT_EFX")) {
            throw new Exception("No ALC_EXT_EFX supported by driver.");
        }
        System.out.println("ALC_EXT_EFX found.");
    }

    private static void silentTests() throws Exception {
        EFX10Test.setupEfx();
        ALCdevice device = AL.getDevice();
        IntBuffer contextAttribList = BufferUtils.createIntBuffer((int)8);
        contextAttribList.put(4103);
        contextAttribList.put(44100);
        contextAttribList.put(4104);
        contextAttribList.put(60);
        contextAttribList.put(4105);
        contextAttribList.put(0);
        contextAttribList.rewind();
        contextAttribList.put(131075);
        contextAttribList.put(2);
        ALCcontext newContext = ALC10.alcCreateContext((ALCdevice)device, (IntBuffer)contextAttribList);
        if (newContext == null) {
            throw new Exception("Failed to create context.");
        }
        int contextCurResult = ALC10.alcMakeContextCurrent((ALCcontext)newContext);
        if (contextCurResult == 0) {
            throw new Exception("Failed to make context current.");
        }
        System.out.println("AL_VERSION: " + AL10.alGetString((int)45058));
        IntBuffer buff = BufferUtils.createIntBuffer((int)1);
        ALC10.alcGetInteger((ALCdevice)device, (int)131073, (IntBuffer)buff);
        System.out.println("ALC_EFX_MAJOR_VERSION: " + buff.get(0));
        ALC10.alcGetInteger((ALCdevice)device, (int)131074, (IntBuffer)buff);
        System.out.println("ALC_EFX_MINOR_VERSION: " + buff.get(0));
        ALC10.alcGetInteger((ALCdevice)device, (int)131075, (IntBuffer)buff);
        int maxAuxSends = buff.get(0);
        System.out.println("ALC_MAX_AUXILIARY_SENDS: " + maxAuxSends);
        int numAuxSlots = 0;
        int[] auxEffectSlots = new int[4];
        AL10.alGetError();
        for (numAuxSlots = 0; numAuxSlots < 4; ++numAuxSlots) {
            auxEffectSlots[numAuxSlots] = EFX10.alGenAuxiliaryEffectSlots();
            if (AL10.alGetError() != 0) break;
        }
        System.out.println("Created " + numAuxSlots + " aux effect slots.");
        int numEffects = 0;
        int[] effects = new int[2];
        for (numEffects = 0; numEffects < 2; ++numEffects) {
            effects[numEffects] = EFX10.alGenEffects();
            if (AL10.alGetError() != 0) break;
        }
        System.out.println("Created " + numEffects + " effects.");
        AL10.alGetError();
        if (EFX10.alIsEffect((int)effects[0])) {
            EFX10.alEffecti((int)effects[0], (int)32769, (int)1);
            if (AL10.alGetError() != 0) {
                System.out.println("Reverb effect not supported.");
            } else {
                EFX10.alEffectf((int)effects[0], (int)5, (float)5.0f);
                System.out.println("Reverb effect created.");
            }
        } else {
            throw new Exception("First effect not a valid effect.");
        }
        AL10.alGetError();
        if (EFX10.alIsEffect((int)effects[1])) {
            EFX10.alEffecti((int)effects[1], (int)32769, (int)5);
            if (AL10.alGetError() != 0) {
                System.out.println("Flanger effect not support.");
            } else {
                EFX10.alEffecti((int)effects[1], (int)2, (int)180);
                System.out.println("Flanger effect created.");
            }
        } else {
            throw new Exception("Second effect not a valid effect.");
        }
        AL10.alGetError();
        int filter = EFX10.alGenFilters();
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to create filter.");
        }
        System.out.println("Generated a filter.");
        if (EFX10.alIsFilter((int)filter)) {
            EFX10.alFilteri((int)filter, (int)32769, (int)1);
            if (AL10.alGetError() != 0) {
                System.out.println("Low pass filter not supported.");
            } else {
                EFX10.alFilterf((int)filter, (int)1, (float)0.5f);
                EFX10.alFilterf((int)filter, (int)2, (float)0.5f);
                System.out.println("Low pass filter created.");
            }
        }
        AL10.alGetError();
        EFX10.alAuxiliaryEffectSloti((int)auxEffectSlots[0], (int)1, (int)effects[0]);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to attach effect to aux effect slot.");
        }
        System.out.println("Successfully loaded effect into effect slot.");
        int source = AL10.alGenSources();
        AL11.alSource3i((int)source, (int)131078, (int)auxEffectSlots[0], (int)0, (int)0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to configure Source Send 0");
        }
        System.out.println("Linked aux effect slot to soutce slot 0");
        AL11.alSource3i((int)source, (int)131078, (int)auxEffectSlots[1], (int)1, (int)filter);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to configure Source Send 1");
        }
        System.out.println("Linked aux effect slot to soutce slot 1");
        AL11.alSource3i((int)source, (int)131078, (int)0, (int)0, (int)0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to disable Source Send 0");
        }
        System.out.println("Disabled source send 0");
        AL11.alSource3i((int)source, (int)131078, (int)0, (int)1, (int)0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to disable Source Send 1");
        }
        System.out.println("Disabled source send 1");
        AL10.alSourcei((int)source, (int)131077, (int)filter);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully applied a direct path filter");
            AL10.alSourcei((int)source, (int)131077, (int)0);
            if (AL10.alGetError() == 0) {
                System.out.println("Successfully removed direct filter");
            }
            AL11.alSource3i((int)source, (int)131078, (int)auxEffectSlots[0], (int)0, (int)filter);
            if (AL10.alGetError() == 0) {
                System.out.println("Successfully applied aux send filter");
                AL11.alSource3i((int)source, (int)131078, (int)auxEffectSlots[0], (int)0, (int)0);
                if (AL10.alGetError() == 0) {
                    System.out.println("Successfully removed filter");
                }
            }
        }
        AL10.alSourcef((int)source, (int)131081, (float)0.5f);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully set cone outside gain filter");
        }
        AL10.alListenerf((int)131076, (float)0.3f);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully set distance units");
        }
        IntBuffer auxEffectSlotsBuf = (IntBuffer)BufferUtils.createIntBuffer((int)auxEffectSlots.length).put(auxEffectSlots).rewind();
        EFX10.alDeleteAuxiliaryEffectSlots((IntBuffer)auxEffectSlotsBuf);
        IntBuffer effectsBuf = (IntBuffer)BufferUtils.createIntBuffer((int)effects.length).put(effects).rewind();
        EFX10.alDeleteEffects((IntBuffer)effectsBuf);
        EFX10.alDeleteFilters((int)filter);
        AL.destroy();
    }

    private static void playbackTest() throws Exception {
        EFX10Test.setupEfx();
        int source = AL10.alGenSources();
        int buffer = AL10.alGenBuffers();
        WaveData waveFile = WaveData.create((String)"Footsteps.wav");
        if (waveFile == null) {
            System.out.println("Failed to load Footsteps.wav! Skipping playback test.");
            AL.destroy();
            return;
        }
        AL10.alBufferData((int)buffer, (int)waveFile.format, (ByteBuffer)waveFile.data, (int)waveFile.samplerate);
        waveFile.dispose();
        AL10.alSourcei((int)source, (int)4105, (int)buffer);
        AL10.alSourcei((int)source, (int)4103, (int)1);
        System.out.println("Playing sound unaffected by EFX ...");
        AL10.alSourcePlay((int)source);
        Thread.sleep(7500L);
        int effectSlot = EFX10.alGenAuxiliaryEffectSlots();
        int reverbEffect = EFX10.alGenEffects();
        EFX10.alEffecti((int)reverbEffect, (int)32769, (int)1);
        EFX10.alEffectf((int)reverbEffect, (int)5, (float)5.0f);
        EFX10.alAuxiliaryEffectSloti((int)effectSlot, (int)1, (int)reverbEffect);
        AL11.alSource3i((int)source, (int)131078, (int)effectSlot, (int)0, (int)0);
        System.out.println("Playing sound with reverb ...");
        AL10.alSourcePlay((int)source);
        Thread.sleep(7500L);
        int filter = EFX10.alGenFilters();
        EFX10.alFilteri((int)filter, (int)32769, (int)1);
        EFX10.alFilterf((int)filter, (int)1, (float)0.5f);
        EFX10.alFilterf((int)filter, (int)2, (float)0.5f);
        AL10.alSourcei((int)source, (int)131077, (int)filter);
        System.out.println("Playing sound with reverb and direct low pass filter ...");
        AL10.alSourcePlay((int)source);
        Thread.sleep(7500L);
        AL10.alSourcei((int)source, (int)131077, (int)0);
        AL11.alSource3i((int)source, (int)131078, (int)0, (int)0, (int)0);
        EFX10.alAuxiliaryEffectSloti((int)effectSlot, (int)1, (int)0);
        EFX10.alDeleteEffects((int)reverbEffect);
        EFX10.alDeleteFilters((int)filter);
        int echoEffect = EFX10.alGenEffects();
        EFX10.alEffecti((int)echoEffect, (int)32769, (int)4);
        EFX10.alAuxiliaryEffectSloti((int)effectSlot, (int)1, (int)echoEffect);
        AL11.alSource3i((int)source, (int)131078, (int)effectSlot, (int)0, (int)0);
        System.out.println("Playing sound with echo effect ...");
        AL10.alSourcePlay((int)source);
        Thread.sleep(7500L);
        AL.destroy();
    }

    private static void efxUtilTest() throws Exception {
        EFX10Test.setupEfx();
        System.out.println();
        System.out.println("Checking supported effects ...");
        if (EFXUtil.isEffectSupported((int)0)) {
            System.out.println("AL_EFFECT_NULL is supported.");
        } else {
            System.out.println("AL_EFFECT_NULL is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)32768)) {
            System.out.println("AL_EFFECT_EAXREVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_EAXREVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)1)) {
            System.out.println("AL_EFFECT_REVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_REVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)2)) {
            System.out.println("AL_EFFECT_CHORUS is supported.");
        } else {
            System.out.println("AL_EFFECT_CHORUS is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)3)) {
            System.out.println("AL_EFFECT_DISTORTION is supported.");
        } else {
            System.out.println("AL_EFFECT_DISTORTION is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)4)) {
            System.out.println("AL_EFFECT_ECHO is supported.");
        } else {
            System.out.println("AL_EFFECT_ECHO is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)5)) {
            System.out.println("AL_EFFECT_FLANGER is supported.");
        } else {
            System.out.println("AL_EFFECT_FLANGER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)6)) {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)7)) {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is supported.");
        } else {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)8)) {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)9)) {
            System.out.println("AL_EFFECT_RING_MODULATOR is supported.");
        } else {
            System.out.println("AL_EFFECT_RING_MODULATOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)10)) {
            System.out.println("AL_EFFECT_AUTOWAH is supported.");
        } else {
            System.out.println("AL_EFFECT_AUTOWAH is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)11)) {
            System.out.println("AL_EFFECT_COMPRESSOR is supported.");
        } else {
            System.out.println("AL_EFFECT_COMPRESSOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)12)) {
            System.out.println("AL_EFFECT_EQUALIZER is supported.");
        } else {
            System.out.println("AL_EFFECT_EQUALIZER is NOT supported.");
        }
        System.out.println();
        System.out.println("Checking supported filters ...");
        if (EFXUtil.isFilterSupported((int)0)) {
            System.out.println("AL_FILTER_NULL is supported.");
        } else {
            System.out.println("AL_FILTER_NULL is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)1)) {
            System.out.println("AL_FILTER_LOWPASS is supported.");
        } else {
            System.out.println("AL_FILTER_LOWPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)2)) {
            System.out.println("AL_FILTER_HIGHPASS is supported.");
        } else {
            System.out.println("AL_FILTER_HIGHPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)3)) {
            System.out.println("AL_FILTER_BANDPASS is supported.");
        } else {
            System.out.println("AL_FILTER_BANDPASS is NOT supported.");
        }
    }
}

