/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;

public class FullScreenWindowedTest {
    private DisplayMode mode;
    private Vector2f quadPosition;
    private Vector2f quadVelocity;
    private float angle;
    private float angleRotation = 1.0f;
    private static final float MAX_SPEED = 20.0f;

    public void execute() {
        this.initialize();
        this.mainLoop();
        this.cleanup();
    }

    private void switchMode() throws LWJGLException {
        this.mode = this.findDisplayMode(800, 600, Display.getDisplayMode().getBitsPerPixel());
        Display.setDisplayModeAndFullscreen((DisplayMode)this.mode);
    }

    private void initialize() {
        try {
            this.switchMode();
            Display.create();
            this.glInit();
            this.quadPosition = new Vector2f(100.0f, 100.0f);
            this.quadVelocity = new Vector2f(1.0f, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown((int)1) && !Display.isCloseRequested()) {
            if (Display.isVisible()) {
                this.processKeyboard();
                this.logic();
                this.render();
            } else {
                if (Display.isDirty()) {
                    this.render();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Display.update();
        }
    }

    private void logic() {
        this.angle += this.angleRotation;
        if (this.angle > 90.0f) {
            this.angle = 0.0f;
        }
        this.quadPosition.x += this.quadVelocity.x;
        this.quadPosition.y += this.quadVelocity.y;
        if (this.quadPosition.x + 50.0f >= (float)this.mode.getWidth() || this.quadPosition.x - 50.0f <= 0.0f) {
            this.quadVelocity.x *= -1.0f;
        }
        if (this.quadPosition.y + 50.0f >= (float)this.mode.getHeight() || this.quadPosition.y - 50.0f <= 0.0f) {
            this.quadVelocity.y *= -1.0f;
        }
    }

    private void render() {
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.quadPosition.x, (float)this.quadPosition.y, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void processKeyboard() {
        if (Keyboard.isKeyDown((int)33)) {
            try {
                this.switchMode();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)17)) {
            try {
                this.mode = new DisplayMode(640, 480);
                Display.setDisplayModeAndFullscreen((DisplayMode)this.mode);
                this.glInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)200)) {
            this.quadVelocity.y += 0.1f;
        }
        if (Keyboard.isKeyDown((int)208)) {
            this.quadVelocity.y -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)205)) {
            this.quadVelocity.x += 0.1f;
        }
        if (Keyboard.isKeyDown((int)203)) {
            this.quadVelocity.x -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)78)) {
            this.angleRotation += 0.1f;
        }
        if (Keyboard.isKeyDown((int)74)) {
            this.angleRotation -= 0.1f;
        }
        if (this.quadVelocity.x < -20.0f) {
            this.quadVelocity.x = -20.0f;
        }
        if (this.quadVelocity.x > 20.0f) {
            this.quadVelocity.x = 20.0f;
        }
        if (this.quadVelocity.y < -20.0f) {
            this.quadVelocity.y = -20.0f;
        }
        if (this.quadVelocity.y > 20.0f) {
            this.quadVelocity.y = 20.0f;
        }
        if (this.angleRotation < 0.0f) {
            this.angleRotation = 0.0f;
        }
        if (this.angleRotation > 20.0f) {
            this.angleRotation = 20.0f;
        }
        while (Mouse.next()) {
        }
    }

    private void cleanup() {
        Display.destroy();
    }

    private DisplayMode findDisplayMode(int width, int height, int bpp) throws LWJGLException {
        DisplayMode[] modes;
        for (DisplayMode mode : modes = Display.getAvailableDisplayModes()) {
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getBitsPerPixel() < bpp || mode.getFrequency() > 60) continue;
            return mode;
        }
        return Display.getDesktopDisplayMode();
    }

    private void glInit() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)this.mode.getWidth(), (float)0.0f, (float)this.mode.getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)this.mode.getWidth(), (int)this.mode.getHeight());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Display.setVSyncEnabled((boolean)true);
    }

    public static void main(String[] args) {
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively");
        System.out.println("Move quad using arrowkeys, and change rotation using +/-");
        FullScreenWindowedTest fswTest = new FullScreenWindowedTest();
        fswTest.execute();
        System.exit(0);
    }
}

