/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMaterial")
public class AIMaterial
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPROPERTIES;
    public static final int MNUMPROPERTIES;
    public static final int MNUMALLOCATED;

    public AIMaterial(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMaterial.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiMaterialProperty **")
    public PointerBuffer mProperties() {
        return AIMaterial.nmProperties(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumProperties() {
        return AIMaterial.nmNumProperties(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumAllocated() {
        return AIMaterial.nmNumAllocated(this.address());
    }

    public AIMaterial mProperties(@NativeType(value="struct aiMaterialProperty **") PointerBuffer value) {
        AIMaterial.nmProperties(this.address(), value);
        return this;
    }

    public AIMaterial mNumAllocated(@NativeType(value="unsigned int") int value) {
        AIMaterial.nmNumAllocated(this.address(), value);
        return this;
    }

    public AIMaterial set(PointerBuffer mProperties, int mNumAllocated) {
        this.mProperties(mProperties);
        this.mNumAllocated(mNumAllocated);
        return this;
    }

    public AIMaterial set(AIMaterial src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMaterial malloc() {
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMaterial calloc() {
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMaterial create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMaterial create(long address) {
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)address);
    }

    @Nullable
    public static AIMaterial createSafe(long address) {
        return address == 0L ? null : (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMaterial.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMaterial.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMaterial.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIMaterial mallocStack() {
        return AIMaterial.mallocStack(MemoryStack.stackGet());
    }

    public static AIMaterial callocStack() {
        return AIMaterial.callocStack(MemoryStack.stackGet());
    }

    public static AIMaterial mallocStack(MemoryStack stack) {
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMaterial callocStack(MemoryStack stack) {
        return (AIMaterial)AIMaterial.wrap(AIMaterial.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMaterial.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMaterial.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMaterial.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nmProperties(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MPROPERTIES)), (int)AIMaterial.nmNumProperties(struct));
    }

    public static int nmNumProperties(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMPROPERTIES);
    }

    public static int nmNumAllocated(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMALLOCATED);
    }

    public static void nmProperties(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MPROPERTIES), (long)MemoryUtil.memAddress((CustomBuffer)value));
        AIMaterial.nmNumProperties(struct, value.remaining());
    }

    public static void nmNumProperties(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMPROPERTIES, value);
    }

    public static void nmNumAllocated(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMALLOCATED, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MPROPERTIES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMaterial.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIMaterial.__struct((Struct.Member[])new Struct.Member[]{AIMaterial.__member((int)POINTER_SIZE), AIMaterial.__member((int)4), AIMaterial.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPROPERTIES = layout.offsetof(0);
        MNUMPROPERTIES = layout.offsetof(1);
        MNUMALLOCATED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMaterial, Buffer>
    implements NativeResource {
        private static final AIMaterial ELEMENT_FACTORY = AIMaterial.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMaterial getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiMaterialProperty **")
        public PointerBuffer mProperties() {
            return AIMaterial.nmProperties(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumProperties() {
            return AIMaterial.nmNumProperties(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumAllocated() {
            return AIMaterial.nmNumAllocated(this.address());
        }

        public Buffer mProperties(@NativeType(value="struct aiMaterialProperty **") PointerBuffer value) {
            AIMaterial.nmProperties(this.address(), value);
            return this;
        }

        public Buffer mNumAllocated(@NativeType(value="unsigned int") int value) {
            AIMaterial.nmNumAllocated(this.address(), value);
            return this;
        }
    }
}

