/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.i18n.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;

public class DoubleTextField
extends TextField {
    public static final String DEFAULT_FORMAT = "#####0.0#####";
    private static final Color INVALID_BACKGROUND = new Color(255, 128, 128);
    private Color defaultBG;
    private boolean valid = true;
    private DecimalFormat scanFormat;

    private void init(double value, String format) throws ParseException {
        this.scanFormat = new DecimalFormat(format, new DecimalFormatSymbols(I18n.getDefaultLocale()));
        ((TextComponent)this).setText(this.scanFormat.format(value));
        this.defaultBG = ((Component)this).getBackground();
        this.addTextListener(new 1());
    }

    public DoubleTextField() {
        this(0.0);
    }

    public DoubleTextField(double value) {
        try {
            this.init(value, DEFAULT_FORMAT);
        }
        catch (ParseException parseException) {}
    }

    public DoubleTextField(double value, String format) throws ParseException {
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        this.init(value, format);
    }

    public boolean isValid() {
        return this.valid;
    }

    public double getValue() throws ParseException {
        return this.isValid() ? this.scanFormat.parse(this.getText()).doubleValue() : 0.0;
    }

    public void setValue(double value) {
        ((TextComponent)this).setText(this.scanFormat.format(value));
    }

    private final class 1
    implements TextListener {
        public void textValueChanged(TextEvent e) {
            String text = DoubleTextField.this.getText();
            ParsePosition pos = new ParsePosition(0);
            DoubleTextField.this.valid = DoubleTextField.this.scanFormat.parse(text, pos) != null;
            if (pos.getIndex() != text.length()) {
                DoubleTextField.this.valid = false;
            }
            if (DoubleTextField.this.valid) {
                ((Component)DoubleTextField.this).setBackground(DoubleTextField.this.defaultBG);
            } else {
                ((Component)DoubleTextField.this).setBackground(INVALID_BACKGROUND);
            }
        }

        /* synthetic */ 1() {
        }
    }
}

