/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.trafo;

import de.escape.quincunx.trafo.Point2D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;

public final class Vector2D {
    public float x;
    public float y;

    public Vector2D() {
    }

    public Vector2D(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2D(Point2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector2D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2D(Point3D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector2D(float xx, float yy) {
        this.x = xx;
        this.y = yy;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void scale(float f) {
        if (f != 1.0f) {
            this.x *= f;
            this.y *= f;
        }
    }

    public void normalize() {
        this.scale(1.0f / this.length());
    }

    public void add(Vector2D v) {
        this.x += v.x;
        this.y += v.y;
    }

    public Vector2D plus(Vector2D v) {
        Vector2D ret = new Vector2D(this);
        ret.add(v);
        return ret;
    }

    public Point2D plus(Point2D p) {
        Point2D ret = new Point2D(p);
        ret.add(this);
        return ret;
    }

    public void sub(Vector2D v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public Point2D minus(Point2D p) {
        Point2D ret = new Point2D(p);
        ret.sub(this);
        ret.scale(-1.0f);
        return ret;
    }

    public Vector2D minus(Vector2D v) {
        Vector2D ret = new Vector2D(this);
        ret.sub(v);
        return ret;
    }

    public float mult(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public boolean equals(Vector2D v) {
        return v.x == this.x && v.y == this.y;
    }

    public String toString() {
        return new String(new StringBuffer().append("<").append(this.x).append(",").append(this.y).append(">"));
    }
}

