/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.RunnerListener;
import processing.app.SketchException;
import processing.mode.android.AndroidBuild;
import processing.mode.android.Device;
import processing.mode.android.DeviceListener;
import processing.mode.java.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidRunner
implements DeviceListener {
    AndroidBuild build;
    RunnerListener listener;
    private volatile Device lastRunDevice = null;
    private static final Pattern LOCATION = Pattern.compile("\\(([^:]+):(\\d+)\\)");
    private static final Pattern EXCEPTION_PARSER = Pattern.compile("^\\s*([a-z]+(?:\\.[a-z]+)+)(?:: .+)?$", 2);

    public AndroidRunner(AndroidBuild build, RunnerListener listener) {
        this.build = build;
        this.listener = listener;
    }

    public void launch(Future<Device> deviceFuture) {
        this.listener.statusNotice("Waiting for device to become available...");
        Device device = this.waitForDevice(deviceFuture, this.listener);
        if (device == null || !device.isAlive()) {
            this.listener.statusError("Device killed or disconnected.");
            return;
        }
        device.addListener(this);
        this.listener.statusNotice("Installing sketch on " + device.getId());
        if (!device.installApp(this.build.getPathForAPK(), this.listener)) {
            this.listener.statusError("Device killed or disconnected.");
            return;
        }
        this.listener.statusNotice("Starting sketch on " + device.getId());
        if (this.startSketch(this.build, device)) {
            this.listener.statusNotice("Sketch launched on the " + (device.isEmulator() ? "emulator" : "phone") + ".");
        } else {
            this.listener.statusError("Could not start the sketch.");
        }
        this.listener.stopIndeterminate();
        this.lastRunDevice = device;
    }

    private boolean startSketch(AndroidBuild build, Device device) {
        String packageName = build.getPackageName();
        String className = build.getSketchClassName();
        try {
            if (device.launchApp(packageName, className)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    private Device waitForDevice(Future<Device> deviceFuture, RunnerListener listener) {
        for (int i = 0; i < 120; ++i) {
            if (listener.isHalted()) {
                deviceFuture.cancel(true);
                return null;
            }
            try {
                return deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                listener.statusError("Interrupted.");
                return null;
            }
            catch (ExecutionException e) {
                listener.statusError(e);
                return null;
            }
            catch (TimeoutException expected) {
                continue;
            }
        }
        listener.statusError("No, on second thought, I'm giving up on waiting for that device to show up.");
        return null;
    }

    @Override
    public void stackTrace(List<String> trace) {
        Iterator<String> frames = trace.iterator();
        String exceptionLine = frames.next();
        Matcher m = EXCEPTION_PARSER.matcher(exceptionLine);
        if (!m.matches()) {
            System.err.println("Can't parse this exception line:");
            System.err.println(exceptionLine);
            this.listener.statusError("Unknown exception");
            return;
        }
        String exceptionClass = m.group(1);
        if (Runner.handleCommonErrors(exceptionClass, exceptionLine, this.listener)) {
            return;
        }
        while (frames.hasNext()) {
            int lineNumber;
            Matcher lm;
            String line = frames.next();
            if (!line.contains("processing.android") || !(lm = LOCATION.matcher(line)).find()) continue;
            String filename = lm.group(1);
            SketchException rex = this.build.placeException(exceptionLine, filename, lineNumber = Integer.parseInt(lm.group(2)) - 1);
            this.listener.statusError(rex == null ? new SketchException(exceptionLine, false) : rex);
            return;
        }
    }

    public void close() {
        if (this.lastRunDevice != null) {
            this.lastRunDevice.bringLauncherToFront();
        }
    }

    @Override
    public void sketchStopped() {
        this.listener.stopIndeterminate();
        this.listener.statusHalt();
    }
}

