/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.StreamPump;
import processing.core.PApplet;
import processing.mode.android.AVD;
import processing.mode.android.Devices;

class EmulatorController {
    private static final EmulatorController INSTANCE = new EmulatorController();
    private volatile State state = State.NOT_RUNNING;

    EmulatorController() {
    }

    public static EmulatorController getInstance() {
        return INSTANCE;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (Base.DEBUG) {
            System.out.println("Emulator state: " + (Object)((Object)state));
            new Exception().printStackTrace(System.out);
        }
        this.state = state;
    }

    public synchronized void launch() throws IOException {
        if (this.state != State.NOT_RUNNING) {
            String illegal = "You can't launch an emulator whose state is " + (Object)((Object)this.state);
            throw new IllegalStateException(illegal);
        }
        String portString = Preferences.get("android.emulator.port");
        if (portString == null) {
            portString = "5566";
            Preferences.set("android.emulator.port", portString);
        }
        String[] cmd = new String[]{"emulator", "-avd", AVD.defaultAVD.name, "-port", portString, "-no-boot-anim"};
        final Process p = Runtime.getRuntime().exec(cmd);
        ProcessRegistry.watch(p);
        new StreamPump(p.getInputStream(), "emulator: ").addTarget(System.out).start();
        this.setState(State.WAITING_FOR_BOOT);
        final String title = PApplet.join((String[])cmd, (char)' ');
        StreamPump outie = new StreamPump(p.getInputStream(), "out: " + title);
        outie.addTarget(new LineProcessor(){

            public void processLine(String line) {
                if (!line.contains("the cache image is used by another emulator")) {
                    System.out.println(title + ": " + line);
                }
            }
        });
        StreamPump errie = new StreamPump(p.getErrorStream(), "err: " + title);
        errie.addTarget(new LineProcessor(){

            public void processLine(String line) {
                if (!line.contains("This application, or a library it uses, is using NSQuickDrawView")) {
                    System.err.println(title + ": " + line);
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block6: while (true) {
                    String device;
                    Iterator<String> i$;
                    try {
                        if (EmulatorController.this.state == State.WAITING_FOR_BOOT) {
                            if (Base.DEBUG) {
                                System.out.println("sleeping for 2 seconds " + new Date().toString());
                            }
                        } else {
                            System.err.println("EmulatorController: Emulator never booted. " + (Object)((Object)EmulatorController.this.state));
                            return;
                        }
                        Thread.sleep(2000L);
                        i$ = Devices.list().iterator();
                    }
                    catch (Exception e) {
                        System.err.println("While waiting for emulator to boot " + e);
                        p.destroy();
                        return;
                    }
                    finally {
                        latch.countDown();
                    }
                    do {
                        if (!i$.hasNext()) continue block6;
                    } while (!(device = i$.next()).contains("emulator"));
                    break;
                }
                EmulatorController.this.setState(State.RUNNING);
            }
        }, "EmulatorController: Wait for emulator to boot").start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        System.err.println("Emulator was interrupted.");
                    }
                    finally {
                        p.destroy();
                        ProcessRegistry.unwatch(p);
                    }
                }
                finally {
                    EmulatorController.this.setState(State.NOT_RUNNING);
                }
            }
        }, "EmulatorController: Process manager").start();
        try {
            latch.await();
        }
        catch (InterruptedException drop) {
            System.err.println("Interrupted while waiting for emulator to launch.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_RUNNING,
        WAITING_FOR_BOOT,
        RUNNING;

    }
}

